<?php

// تحميل التطبيق
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

// إزالة الصلاحيات التي أضفناها سابقاً من جميع المستخدمين
$users = App\Models\User::all();
$elevatorPermission = App\Models\Permission::where('slug', 'manage_elevators')->first();
$companyPermission = App\Models\Permission::where('slug', 'manage_companies')->first();
$customerPermission = App\Models\Permission::where('slug', 'manage_customers')->first();

if ($elevatorPermission && $companyPermission && $customerPermission) {
    foreach ($users as $user) {
        // إزالة الصلاحيات المباشرة من المستخدمين
        $user->permissions()->detach([$elevatorPermission->id, $companyPermission->id, $customerPermission->id]);
        echo "تم إزالة صلاحيات إدارة المصاعد والشركات والعملاء من المستخدم: " . $user->name . "\n";
    }
}

// إعادة تعيين الصلاحيات بشكل صحيح حسب الأدوار
$adminRole = App\Models\Role::where('slug', 'admin')->first();
$branchManagerRole = App\Models\Role::where('slug', 'branch_manager')->first();

// التأكد من أن دور المدير لديه صلاحيات إدارة المصاعد والشركات والعملاء
if ($adminRole && $elevatorPermission && $companyPermission && $customerPermission) {
    $adminRole->permissions()->syncWithoutDetaching([
        $elevatorPermission->id,
        $companyPermission->id,
        $customerPermission->id
    ]);
    echo "تم تعيين صلاحيات إدارة المصاعد والشركات والعملاء لدور المدير\n";
}

// التأكد من أن دور مدير الفرع لديه صلاحيات إدارة المصاعد والشركات والعملاء
if ($branchManagerRole && $elevatorPermission && $companyPermission && $customerPermission) {
    $branchManagerRole->permissions()->syncWithoutDetaching([
        $elevatorPermission->id,
        $companyPermission->id,
        $customerPermission->id
    ]);
    echo "تم تعيين صلاحيات إدارة المصاعد والشركات والعملاء لدور مدير الفرع\n";
}

// إضافة الصلاحيات الفرعية لكل دور
$elevatorViewPermission = App\Models\Permission::where('slug', 'view_elevator')->first();
$elevatorCreatePermission = App\Models\Permission::where('slug', 'create_elevator')->first();
$elevatorEditPermission = App\Models\Permission::where('slug', 'edit_elevator')->first();
$elevatorDeletePermission = App\Models\Permission::where('slug', 'delete_elevator')->first();

$companyViewPermission = App\Models\Permission::where('slug', 'view_company')->first();
$companyCreatePermission = App\Models\Permission::where('slug', 'create_company')->first();
$companyEditPermission = App\Models\Permission::where('slug', 'edit_company')->first();
$companyDeletePermission = App\Models\Permission::where('slug', 'delete_company')->first();

$customerViewPermission = App\Models\Permission::where('slug', 'view_customer')->first();
$customerCreatePermission = App\Models\Permission::where('slug', 'create_customer')->first();
$customerEditPermission = App\Models\Permission::where('slug', 'edit_customer')->first();
$customerDeletePermission = App\Models\Permission::where('slug', 'delete_customer')->first();

// إضافة صلاحيات العرض فقط لدور المستخدم العادي
$userRole = App\Models\Role::where('slug', 'user')->first();
if ($userRole && $elevatorViewPermission && $companyViewPermission && $customerViewPermission) {
    $userRole->permissions()->syncWithoutDetaching([
        $elevatorViewPermission->id,
        $companyViewPermission->id,
        $customerViewPermission->id
    ]);
    echo "تم تعيين صلاحيات عرض المصاعد والشركات والعملاء لدور المستخدم العادي\n";
}

// إضافة صلاحيات العرض والتعديل لدور الفني
$technicianRole = App\Models\Role::where('slug', 'technician')->first();
if ($technicianRole && $elevatorViewPermission && $elevatorEditPermission && $companyViewPermission && $customerViewPermission) {
    $technicianRole->permissions()->syncWithoutDetaching([
        $elevatorViewPermission->id,
        $elevatorEditPermission->id,
        $companyViewPermission->id,
        $customerViewPermission->id
    ]);
    echo "تم تعيين صلاحيات عرض وتعديل المصاعد وعرض الشركات والعملاء لدور الفني\n";
}

// التأكد من أن المستخدم الحالي لديه الصلاحيات المناسبة
$currentUser = App\Models\User::find(6); // استخدم معرف المستخدم الحالي من سجل الأخطاء
if ($currentUser) {
    // التحقق من دور المستخدم
    $isAdmin = $currentUser->hasRole($adminRole);
    $isBranchManager = $currentUser->hasRole($branchManagerRole);

    if ($isAdmin) {
        echo "المستخدم الحالي هو مدير ولديه بالفعل جميع الصلاحيات\n";
    } elseif ($isBranchManager) {
        echo "المستخدم الحالي هو مدير فرع ولديه بالفعل صلاحيات إدارة المصاعد\n";
    } else {
        // إضافة دور مدير الفرع للمستخدم الحالي
        $currentUser->roles()->syncWithoutDetaching([$branchManagerRole->id]);
        echo "تم تعيين دور مدير الفرع للمستخدم الحالي: " . $currentUser->name . "\n";
    }
}

// إصلاح مشكلة عمود 'active' في جدول المستخدمين
echo "إصلاح مشكلة عمود 'active' في استعلامات المستخدمين...\n";

// إضافة نطاق عام (Global Scope) إلى نموذج المستخدم
$userModelPath = __DIR__ . '/app/Models/User.php';
$userModelContent = file_get_contents($userModelPath);

// التحقق مما إذا كان النطاق العام موجوداً بالفعل
if (strpos($userModelContent, 'ActiveColumnScope') === false) {
    // إنشاء ملف النطاق العام
    $scopePath = __DIR__ . '/app/Scopes/ActiveColumnScope.php';
    $scopeDir = dirname($scopePath);

    if (!is_dir($scopeDir)) {
        mkdir($scopeDir, 0755, true);
    }

    $scopeContent = '<?php

namespace App\Scopes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;

class ActiveColumnScope implements Scope
{
    /**
     * تطبيق النطاق على استعلام Eloquent.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @param  \Illuminate\Database\Eloquent\Model  $model
     * @return void
     */
    public function apply(Builder $builder, Model $model)
    {
        // لا نقوم بأي شيء هنا، سنتعامل مع الاستعلامات في طريقة extend
    }

    /**
     * تسجيل الاستماع لإضافة النطاق.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @return void
     */
    public function extend(Builder $builder)
    {
        $builder->macro(\'withActive\', function (Builder $builder) {
            return $builder;
        });

        // تعديل استعلامات where لاستبدال active بـ is_active
        $this->replaceWhereActive($builder);
    }

    /**
     * استبدال استعلامات where التي تستخدم عمود active بـ is_active
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @return void
     */
    protected function replaceWhereActive(Builder $builder)
    {
        $query = $builder->getQuery();
        
        // تعديل طريقة where
        $originalWhere = $query->where;
        $query->where = function ($column, $operator = null, $value = null, $boolean = \'and\') use ($originalWhere, $query) {
            // إذا كان العمود هو \'active\'، استبدله بـ \'is_active\'
            if ($column === \'active\') {
                $column = \'is_active\';
            }
            
            // استدعاء الدالة الأصلية
            return $originalWhere->call($query, $column, $operator, $value, $boolean);
        };
    }
}';

    file_put_contents($scopePath, $scopeContent);
    echo "تم إنشاء ملف النطاق العام: ActiveColumnScope\n";

    // تعديل نموذج المستخدم لإضافة النطاق العام
    $userModelUpdated = str_replace(
        "namespace App\Models;\n",
        "namespace App\Models;\n\nuse App\Scopes\ActiveColumnScope;",
        $userModelContent
    );

    $userModelUpdated = str_replace(
        "protected static function boot()\n    {\n        parent::boot();",
        "protected static function boot()\n    {\n        parent::boot();\n        \n        // إضافة نطاق عام لاستبدال عمود 'active' بـ 'is_active'\n        static::addGlobalScope(new ActiveColumnScope());",
        $userModelUpdated
    );

    file_put_contents($userModelPath, $userModelUpdated);
    echo "تم تحديث نموذج المستخدم لإضافة النطاق العام\n";
} else {
    echo "النطاق العام موجود بالفعل في نموذج المستخدم\n";
}

// مسح الكاش
\Illuminate\Support\Facades\Cache::forget('spatie.permission.cache');
\Illuminate\Support\Facades\Artisan::call('cache:clear');
echo "تم مسح الكاش\n";

echo "تم الانتهاء من إصلاح الصلاحيات وإعادة تعيينها بشكل صحيح.\n";
