<?php

/**
 * سكريبت لإعادة إنشاء قيود المحاسبة للإيداعات النقدية السابقة
 * 
 * يمكن تشغيل هذا السكريبت مباشرة من سطر الأوامر:
 * php fix_deposit_journal_entries.php
 * 
 * أو يمكن تحديد تاريخ معين:
 * php fix_deposit_journal_entries.php 2025-09-29
 */

// تحميل الإطار
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\CashTransaction;
use App\Models\JournalEntry;
use App\Http\Controllers\CashTransactionController;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

// الحصول على التاريخ من معاملات سطر الأوامر
$date = isset($argv[1]) ? $argv[1] : null;

echo "بدء إعادة إنشاء قيود المحاسبة للإيداعات النقدية...\n";

// البحث عن الإيداعات النقدية التي لم يتم إنشاء قيود محاسبية لها
$query = CashTransaction::where('type', 'deposit')
    ->whereNotExists(function ($query) {
        $query->select(DB::raw(1))
            ->from('cash_transaction_entries')
            ->whereRaw('cash_transaction_entries.cash_transaction_id = cash_transactions.id');
    });

// تطبيق فلتر التاريخ إذا تم تحديده
if ($date) {
    $query->whereDate('created_at', $date);
    echo "تم تحديد التاريخ: {$date}\n";
}

$deposits = $query->get();

echo "تم العثور على {$deposits->count()} إيداع بدون قيود محاسبية.\n";

if ($deposits->isEmpty()) {
    echo "لا توجد إيداعات تحتاج إلى إعادة إنشاء قيود محاسبية.\n";
    exit(0);
}

$controller = new CashTransactionController();
$successCount = 0;
$errorCount = 0;

foreach ($deposits as $deposit) {
    echo "معالجة الإيداع رقم {$deposit->id} بتاريخ {$deposit->created_at}...\n";

    try {
        DB::beginTransaction();

        // استدعاء دالة إنشاء قيد المحاسبة
        $entry = $controller->createJournalEntryForDeposit($deposit);

        if ($entry) {
            echo "تم إنشاء قيد المحاسبة رقم {$entry->id} للإيداع رقم {$deposit->id} بنجاح.\n";
            $successCount++;
        } else {
            echo "فشل إنشاء قيد المحاسبة للإيداع رقم {$deposit->id}.\n";
            $errorCount++;
        }

        DB::commit();
    } catch (\Exception $e) {
        DB::rollBack();
        echo "حدث خطأ أثناء إنشاء قيد المحاسبة للإيداع رقم {$deposit->id}: " . $e->getMessage() . "\n";
        Log::error("حدث خطأ أثناء إعادة إنشاء قيد المحاسبة للإيداع رقم {$deposit->id}: " . $e->getMessage());
        $errorCount++;
    }
}

echo "اكتملت العملية. تم إنشاء {$successCount} قيد محاسبي بنجاح. فشل إنشاء {$errorCount} قيد محاسبي.\n";
