<?php

// Cargar la aplicación
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

// Obtener todos los registros de journal entries que estén publicados
$entries = \App\Models\JournalEntry::where('is_posted', true)->get();
echo "Total de registros publicados encontrados: " . $entries->count() . "\n\n";

$fixed = 0;
$skipped = 0;
$errors = 0;

foreach ($entries as $entry) {
    echo "Procesando ID: " . $entry->id . " - Número: " . $entry->entry_number . "\n";

    // Verificar si ya tiene un registro en customer_statements
    $existingStatements = \App\Models\CustomerStatement::where('reference_type', 'App\\Models\\JournalEntry')
        ->where('reference_id', $entry->id)
        ->count();

    if ($existingStatements > 0) {
        echo "  - Ya tiene " . $existingStatements . " registros en customer_statements. Omitiendo.\n";
        $skipped++;
        continue;
    }

    // Intentar crear un registro de estado de cuenta para este asiento contable
    try {
        $result = \App\Models\CustomerStatement::createForJournalEntry($entry);

        if ($result) {
            echo "  - Se creó correctamente un registro de estado de cuenta para el cliente.\n";
            $fixed++;
        } else {
            echo "  - No se pudo crear un registro de estado de cuenta. Posiblemente no tiene cuentas de clientes asociadas.\n";
            $skipped++;
        }
    } catch (\Exception $e) {
        echo "  - Error al crear el registro de estado de cuenta: " . $e->getMessage() . "\n";
        $errors++;
    }

    echo "----------------------------------------\n";
}

echo "\nResumen:\n";
echo "Total de asientos procesados: " . $entries->count() . "\n";
echo "Asientos corregidos: " . $fixed . "\n";
echo "Asientos omitidos: " . $skipped . "\n";
echo "Errores: " . $errors . "\n";
