<?php
require __DIR__ . '/vendor/autoload.php';
require __DIR__ . '/bootstrap/app.php';

$app = app();
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use App\Models\JournalEntry;
use App\Models\JournalEntryItem;
use App\Models\ChartOfAccount;
use App\Models\Customer;
use App\Models\CustomerStatement;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

// تحقق من القيد المحاسبي رقم 33
echo "Checking Journal Entry 33...\n";
$entry = JournalEntry::find(33);

if (!$entry) {
    echo "Journal Entry 33 not found!\n";
    exit;
}

echo "Found Journal Entry 33: " . $entry->entry_number . "\n";

// تحقق من العميل رقم 2
echo "Checking Customer ID 2...\n";
$customer = Customer::find(2);

if (!$customer) {
    echo "Customer ID 2 not found!\n";
    exit;
}

echo "Found Customer ID 2: " . $customer->name . "\n";

// البحث عن حسابات العملاء في القيد المحاسبي
echo "Finding customer account items in Journal Entry 33...\n";
$customerAccountItems = JournalEntryItem::where('journal_entry_id', 33)
    ->whereHas('account', function ($query) {
        $query->where('account_type', 'asset')
            ->where(function ($q) {
                $q->where('sub_type', 'accounts_receivable')
                    ->orWhere('sub_type', 'customer_receivable');
            });
    })
    ->get();

echo "Found " . $customerAccountItems->count() . " customer account items.\n";

// الحصول على عنصر حساب العميل الأول
$item = $customerAccountItems->first();

if (!$item) {
    echo "No customer account item found in Journal Entry 33!\n";
    exit;
}

echo "Using account item with debit: " . $item->debit . ", credit: " . $item->credit . "\n";

// الحصول على آخر رصيد للعميل رقم 2
$lastStatement = CustomerStatement::where('customer_id', 2)
    ->orderBy('id', 'desc')
    ->first();

$currentBalance = $lastStatement ? $lastStatement->balance : 0;
echo "Last balance for customer ID 2: " . $currentBalance . "\n";

// حساب الرصيد الجديد
$debitAmount = $item->debit;
$creditAmount = $item->credit;
$netAmount = $creditAmount - $debitAmount;
$newBalance = $currentBalance - $netAmount;

echo "Debit: " . $debitAmount . ", Credit: " . $creditAmount . ", Net: " . $netAmount . ", New Balance: " . $newBalance . "\n";

// الحصول على معلومات المرجع بناءً على مرجع القيد المحاسبي
$referenceType = $entry->reference_type;
$referenceId = $entry->reference_id;
$description = $entry->description;

// إذا كان المرجع فاتورة، نحصل على مزيد من التفاصيل
if ($referenceType == 'App\Models\Invoice' && $referenceId) {
    $invoice = \App\Models\Invoice::find($referenceId);
    if ($invoice) {
        $description = 'فاتورة رقم ' . $invoice->invoice_number . ' (قيد محاسبي: ' . $entry->entry_number . ')';
    }
}
// إذا كان المرجع دفعة، نحصل على مزيد من التفاصيل
else if ($referenceType == 'App\Models\Payment' && $referenceId) {
    $payment = \App\Models\Payment::find($referenceId);
    if ($payment && $payment->invoice) {
        $description = 'دفعة للفاتورة رقم ' . $payment->invoice->invoice_number . ' (قيد محاسبي: ' . $entry->entry_number . ')';
    }
}

echo "Description: " . $description . "\n";

// إنشاء سجل كشف الحساب للعميل رقم 2
echo "Creating statement for customer ID 2...\n";
$statement = CustomerStatement::create([
    'company_id' => $entry->company_id,
    'customer_id' => 2,
    'branch_id' => null, // ليس لدينا معلومات الفرع من القيد المحاسبي
    'transaction_date' => $entry->entry_date,
    'reference_number' => $entry->entry_number,
    'reference_type' => 'App\Models\JournalEntry',
    'reference_id' => $entry->id,
    'description' => $description,
    'debit' => $debitAmount,
    'credit' => $creditAmount,
    'balance' => $newBalance
]);

echo "Created statement ID: " . $statement->id . " for customer ID: 2\n";

// التحقق من سجلات كشف الحساب للعميل رقم 2
echo "\nChecking statements for customer ID 2...\n";
$customer2Statements = CustomerStatement::where('customer_id', 2)
    ->where('reference_type', 'App\Models\JournalEntry')
    ->where('reference_id', 33)
    ->get();

if ($customer2Statements->count() > 0) {
    echo "Found " . $customer2Statements->count() . " statements for customer ID 2 and Journal Entry 33.\n";
    foreach ($customer2Statements as $stmt) {
        echo "Statement ID: " . $stmt->id .
            ", Date: " . $stmt->transaction_date .
            ", Reference: " . $stmt->reference_number .
            ", Debit: " . $stmt->debit .
            ", Credit: " . $stmt->credit .
            ", Balance: " . $stmt->balance . "\n";
    }
} else {
    echo "No statements found for customer ID 2 and Journal Entry 33.\n";
}

echo "\nFix completed!\n";
