<?php

require_once __DIR__ . '/vendor/autoload.php';

use App\Models\ChartOfAccount;
use Illuminate\Support\Facades\DB;

// تهيئة Laravel
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

echo "بدء تعديل حساب البنوك للشركة 3 ليكون تحت الأصول المتداولة...\n";

// البحث عن حساب البنوك للشركة 3
$bankAccount = ChartOfAccount::where('account_code', 'BANK')
    ->where('company_id', 3)
    ->first();

if (!$bankAccount) {
    echo "لم يتم العثور على حساب البنوك للشركة 3!\n";
    exit;
}

echo "تم العثور على حساب البنوك للشركة 3 (ID: {$bankAccount->id}).\n";

// البحث عن حساب الأصول المتداولة للشركة 3
$currentAssetsAccount = ChartOfAccount::where('account_code', '1100')
    ->where('company_id', 3)
    ->first();

if (!$currentAssetsAccount) {
    echo "لم يتم العثور على حساب الأصول المتداولة للشركة 3!\n";

    // البحث عن حساب الأصول للشركة 3
    $assetsAccount = ChartOfAccount::where('account_code', '1000')
        ->where('company_id', 3)
        ->first();

    if (!$assetsAccount) {
        echo "لم يتم العثور على حساب الأصول للشركة 3!\n";
        exit;
    }

    echo "تم العثور على حساب الأصول للشركة 3 (ID: {$assetsAccount->id}).\n";
    echo "سيتم إنشاء حساب الأصول المتداولة للشركة 3...\n";

    // إنشاء حساب الأصول المتداولة
    $currentAssetsAccount = ChartOfAccount::create([
        'company_id' => 3,
        'parent_id' => $assetsAccount->id,
        'account_code' => '1100',
        'name' => 'الأصول المتداولة',
        'name_en' => 'Current Assets',
        'account_type' => 'asset',
        'sub_type' => 'current_asset',
        'description' => 'حساب الأصول المتداولة',
        'is_active' => true,
        'is_system' => true,
        'opening_balance' => 0,
        'current_balance' => 0,
        'currency' => 'SAR',
        'balance_type' => 'debit',
        'is_cash_account' => false,
        'is_bank_account' => false,
        'level' => $assetsAccount->level + 1,
        'is_parent' => true
    ]);

    echo "تم إنشاء حساب الأصول المتداولة للشركة 3 (ID: {$currentAssetsAccount->id}).\n";
} else {
    echo "تم العثور على حساب الأصول المتداولة للشركة 3 (ID: {$currentAssetsAccount->id}).\n";
}

// تحديث حساب البنوك ليكون تحت الأصول المتداولة
try {
    // تحديث الحساب
    $bankAccount->parent_id = $currentAssetsAccount->id;
    $bankAccount->level = $currentAssetsAccount->level + 1;
    $bankAccount->name = 'البنوك';
    $bankAccount->name_en = 'Banks';
    $bankAccount->description = 'حساب البنوك الرئيسي';
    $bankAccount->save();

    echo "تم تحديث حساب البنوك للشركة 3 بنجاح ليكون تحت الأصول المتداولة.\n";

    echo "تم الانتهاء من العملية بنجاح!\n";
} catch (\Exception $e) {
    echo "حدث خطأ أثناء تحديث حساب البنوك: " . $e->getMessage() . "\n";
}
