<?php

require __DIR__ . '/vendor/autoload.php';

use App\Models\CashRegister;
use App\Models\ChartOfAccount;
use Illuminate\Support\Facades\DB;

// تهيئة تطبيق Laravel
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "بدء عملية ربط الخزائن بالحسابات في شجرة الحسابات...\n";

// الحصول على جميع الخزائن
$cashRegisters = CashRegister::all();
echo "تم العثور على " . $cashRegisters->count() . " خزينة.\n";

$fixed = 0;
$alreadyLinked = 0;

foreach ($cashRegisters as $cashRegister) {
    echo "\nمعالجة الخزينة: {$cashRegister->name} (ID: {$cashRegister->id})\n";

    // التحقق مما إذا كانت الخزينة مرتبطة بحساب
    $linkedAccount = DB::table('cash_register_accounts')
        ->where('cash_register_id', $cashRegister->id)
        ->first();

    if ($linkedAccount) {
        // الخزينة مرتبطة بالفعل بحساب
        $account = ChartOfAccount::find($linkedAccount->account_id);

        if ($account) {
            echo "الخزينة مرتبطة بالفعل بالحساب: {$account->name} (ID: {$account->id})\n";

            // التحقق من تطابق اسم الحساب مع اسم الخزينة
            if ($account->name !== $cashRegister->name) {
                echo "تحديث اسم الحساب ليتطابق مع اسم الخزينة...\n";
                $account->name = $cashRegister->name;
                $account->name_en = $cashRegister->name;
                $account->description = 'حساب الخزينة: ' . $cashRegister->name;
                $account->save();
                echo "تم تحديث اسم الحساب بنجاح.\n";
                $fixed++;
            } else {
                $alreadyLinked++;
            }
        } else {
            echo "الحساب المرتبط غير موجود! إنشاء حساب جديد...\n";
            $account = createAccountForCashRegister($cashRegister);

            // تحديث السجل في جدول الربط
            DB::table('cash_register_accounts')
                ->where('id', $linkedAccount->id)
                ->update([
                    'account_id' => $account->id,
                    'updated_at' => now()
                ]);

            echo "تم إنشاء وربط حساب جديد بنجاح.\n";
            $fixed++;
        }
    } else {
        // الخزينة غير مرتبطة بحساب
        echo "الخزينة غير مرتبطة بأي حساب. إنشاء وربط حساب جديد...\n";
        $account = createAccountForCashRegister($cashRegister);

        // ربط الخزينة بالحساب
        DB::table('cash_register_accounts')->insert([
            'cash_register_id' => $cashRegister->id,
            'account_id' => $account->id,
            'created_at' => now(),
            'updated_at' => now()
        ]);

        echo "تم إنشاء وربط حساب جديد بنجاح.\n";
        $fixed++;
    }
}

echo "\n=== ملخص العملية ===\n";
echo "إجمالي الخزائن: " . $cashRegisters->count() . "\n";
echo "الخزائن التي تم إصلاحها: " . $fixed . "\n";
echo "الخزائن المرتبطة بالفعل بشكل صحيح: " . $alreadyLinked . "\n";
echo "تم الانتهاء من عملية ربط الخزائن بالحسابات بنجاح.\n";

/**
 * إنشاء حساب للخزينة
 */
function createAccountForCashRegister(CashRegister $cashRegister)
{
    // البحث عن حساب الأصول النقدية الرئيسي
    $parentAccount = ChartOfAccount::where('company_id', $cashRegister->company_id)
        ->where('account_type', 'asset')
        ->where('is_cash_account', true)
        ->whereNull('parent_id')
        ->first();

    if (!$parentAccount) {
        // إنشاء حساب الأصول النقدية الرئيسي إذا لم يكن موجوداً
        echo "إنشاء حساب الأصول النقدية الرئيسي...\n";
        $parentAccount = ChartOfAccount::create([
            'company_id' => $cashRegister->company_id,
            'account_code' => 'CASH',
            'name' => 'النقدية',
            'name_en' => 'Cash',
            'account_type' => 'asset',
            'sub_type' => 'cash',
            'parent_id' => null,
            'description' => 'حساب النقدية الرئيسي',
            'is_active' => true,
            'is_system' => true,
            'opening_balance' => 0,
            'current_balance' => 0,
            'currency' => $cashRegister->currency,
            'balance_type' => 'debit',
            'is_cash_account' => true,
            'is_bank_account' => false,
            'level' => 1
        ]);
    }

    // إنشاء حساب للخزينة
    $account = ChartOfAccount::create([
        'company_id' => $cashRegister->company_id,
        'account_code' => 'CASH-' . $cashRegister->id,
        'name' => $cashRegister->name,
        'name_en' => $cashRegister->name,
        'account_type' => 'asset',
        'sub_type' => 'cash',
        'parent_id' => $parentAccount->id,
        'description' => 'حساب الخزينة: ' . $cashRegister->name,
        'is_active' => $cashRegister->is_active,
        'is_system' => false,
        'opening_balance' => $cashRegister->initial_balance,
        'current_balance' => $cashRegister->current_balance,
        'currency' => $cashRegister->currency,
        'balance_type' => 'debit',
        'is_cash_account' => true,
        'is_bank_account' => false,
        'level' => $parentAccount->level + 1
    ]);

    return $account;
}
