<?php

/**
 * سكريبت لإصلاح مستويات حسابات البنوك
 * يقوم بالتحقق من مستويات حسابات البنوك وتصحيحها
 */

require_once __DIR__ . '/vendor/autoload.php';

use App\Models\ChartOfAccount;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

// تهيئة Laravel
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

echo "بدء تصحيح مستويات حسابات البنوك...\n";

// الحصول على جميع الشركات التي لديها حسابات بنكية
$companies = DB::table('chart_of_accounts')
    ->where('account_code', 'BANK')
    ->distinct()
    ->pluck('company_id');

echo "عدد الشركات التي لديها حسابات بنكية: " . $companies->count() . "\n";

foreach ($companies as $companyId) {
    echo "\nمعالجة الشركة رقم: {$companyId}\n";

    // البحث عن حساب الأصول
    $assetsAccount = ChartOfAccount::where('company_id', $companyId)
        ->where('account_code', '1000')
        ->first();

    if (!$assetsAccount) {
        echo "  ! خطأ: لم يتم العثور على حساب الأصول للشركة {$companyId}\n";
        continue;
    }

    echo "  - تم العثور على حساب الأصول (ID: {$assetsAccount->id}, المستوى: {$assetsAccount->level})\n";

    // التحقق من مستوى حساب الأصول
    if ($assetsAccount->level != 1) {
        echo "  - تصحيح مستوى حساب الأصول من {$assetsAccount->level} إلى 1\n";
        $assetsAccount->level = 1;
        $assetsAccount->save();
    }

    // البحث عن حساب الأصول المتداولة
    $currentAssetsAccount = ChartOfAccount::where('company_id', $companyId)
        ->where('parent_id', $assetsAccount->id)
        ->where('account_code', '1100')
        ->first();

    if (!$currentAssetsAccount) {
        echo "  ! خطأ: لم يتم العثور على حساب الأصول المتداولة للشركة {$companyId}\n";
        continue;
    }

    echo "  - تم العثور على حساب الأصول المتداولة (ID: {$currentAssetsAccount->id}, المستوى: {$currentAssetsAccount->level})\n";

    // التحقق من مستوى حساب الأصول المتداولة
    $correctLevel = $assetsAccount->level + 1;
    if ($currentAssetsAccount->level != $correctLevel) {
        echo "  - تصحيح مستوى حساب الأصول المتداولة من {$currentAssetsAccount->level} إلى {$correctLevel}\n";
        $currentAssetsAccount->level = $correctLevel;
        $currentAssetsAccount->save();
    }

    // البحث عن حساب البنوك الرئيسي
    $bankAccount = ChartOfAccount::where('company_id', $companyId)
        ->where('parent_id', $currentAssetsAccount->id)
        ->where('account_code', 'BANK')
        ->first();

    if (!$bankAccount) {
        echo "  ! خطأ: لم يتم العثور على حساب البنوك الرئيسي للشركة {$companyId}\n";
        continue;
    }

    echo "  - تم العثور على حساب البنوك الرئيسي (ID: {$bankAccount->id}, المستوى: {$bankAccount->level})\n";

    // التحقق من مستوى حساب البنوك الرئيسي
    $correctLevel = $currentAssetsAccount->level + 1;
    if ($bankAccount->level != $correctLevel) {
        echo "  - تصحيح مستوى حساب البنوك الرئيسي من {$bankAccount->level} إلى {$correctLevel}\n";
        $bankAccount->level = $correctLevel;
        $bankAccount->save();
    }

    // البحث عن الحسابات البنكية الفردية
    $individualBankAccounts = ChartOfAccount::where('company_id', $companyId)
        ->where('parent_id', $bankAccount->id)
        ->where('is_bank_account', true)
        ->get();

    echo "  - عدد الحسابات البنكية الفردية: " . $individualBankAccounts->count() . "\n";

    // تصحيح مستويات الحسابات البنكية الفردية
    foreach ($individualBankAccounts as $account) {
        $correctLevel = $bankAccount->level + 1;
        if ($account->level != $correctLevel) {
            echo "  - تصحيح مستوى الحساب {$account->id} ({$account->name}) من {$account->level} إلى {$correctLevel}\n";
            $account->level = $correctLevel;
            $account->save();
        }
    }

    // التحقق من وجود حساب البنوك الرئيسي تحت الأصول المتداولة
    if ($bankAccount->parent_id != $currentAssetsAccount->id) {
        echo "  ! تحذير: حساب البنوك الرئيسي ليس تحت حساب الأصول المتداولة\n";
        echo "  - تصحيح الحساب الأب لحساب البنوك الرئيسي من {$bankAccount->parent_id} إلى {$currentAssetsAccount->id}\n";
        $bankAccount->parent_id = $currentAssetsAccount->id;
        $bankAccount->save();
    }
}

echo "\nتم الانتهاء من تصحيح مستويات حسابات البنوك.\n";
