<?php

/**
 * سكريبت لإصلاح مشكلة تكرار حساب البنك الرئيسي
 */

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';

use App\Models\ChartOfAccount;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

// تهيئة التطبيق
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "بدء إصلاح مشكلة تكرار حساب البنك الرئيسي...\n";

// البحث عن حسابات البنك الرئيسية للشركة 3 (بما في ذلك المحذوفة)
$bankAccounts = ChartOfAccount::withTrashed()
    ->where('company_id', 3)
    ->where('account_code', 'BANK')
    ->get();

echo "عدد حسابات البنك الرئيسية للشركة 3: " . $bankAccounts->count() . "\n";

// إذا كان هناك أكثر من حساب بنك رئيسي للشركة 3
if ($bankAccounts->count() > 1) {
    echo "تم العثور على أكثر من حساب بنك رئيسي للشركة 3. سيتم الاحتفاظ بالحساب الأول وحذف الباقي.\n";

    // الاحتفاظ بالحساب الأول
    $mainAccount = $bankAccounts->first();
    echo "الحساب الرئيسي: ID: {$mainAccount->id}, الاسم: {$mainAccount->name}, المستوى: {$mainAccount->level}, محذوف: " . ($mainAccount->trashed() ? 'نعم' : 'لا') . "\n";

    // استرجاع الحساب الرئيسي إذا كان محذوفاً
    if ($mainAccount->trashed()) {
        $mainAccount->restore();
        echo "تم استرجاع الحساب الرئيسي من الحذف.\n";
    }

    // حذف الحسابات الأخرى نهائياً
    foreach ($bankAccounts as $account) {
        if ($account->id != $mainAccount->id) {
            echo "حذف الحساب: ID: {$account->id}, الاسم: {$account->name}, المستوى: {$account->level}\n";

            // نقل الحسابات الفرعية إلى الحساب الرئيسي
            $childAccounts = ChartOfAccount::withTrashed()
                ->where('parent_id', $account->id)
                ->get();

            echo "  عدد الحسابات الفرعية: " . $childAccounts->count() . "\n";

            foreach ($childAccounts as $child) {
                echo "  نقل الحساب الفرعي: ID: {$child->id}, الاسم: {$child->name} إلى الحساب الرئيسي ID: {$mainAccount->id}\n";
                $child->parent_id = $mainAccount->id;
                $child->level = $mainAccount->level + 1;
                $child->save();
            }

            // حذف الحساب نهائياً من قاعدة البيانات
            try {
                DB::statement("DELETE FROM chart_of_accounts WHERE id = ?", [$account->id]);
                echo "  تم حذف الحساب نهائياً من قاعدة البيانات.\n";
            } catch (\Exception $e) {
                echo "  فشل في حذف الحساب: " . $e->getMessage() . "\n";

                // محاولة تحديث الحساب بدلاً من حذفه
                try {
                    DB::statement("UPDATE chart_of_accounts SET account_code = ? WHERE id = ?", ["BANK-DELETED-{$account->id}", $account->id]);
                    echo "  تم تغيير رمز الحساب إلى BANK-DELETED-{$account->id}.\n";
                } catch (\Exception $e2) {
                    echo "  فشل في تحديث الحساب: " . $e2->getMessage() . "\n";
                }
            }
        }
    }
} else if ($bankAccounts->count() == 1) {
    $account = $bankAccounts->first();
    echo "يوجد حساب بنك رئيسي واحد فقط للشركة 3: ID: {$account->id}, الاسم: {$account->name}, المستوى: {$account->level}, محذوف: " . ($account->trashed() ? 'نعم' : 'لا') . "\n";

    // استرجاع الحساب إذا كان محذوفاً
    if ($account->trashed()) {
        $account->restore();
        echo "تم استرجاع الحساب من الحذف.\n";
    }

    // التحقق من الحساب الأب
    $currentAssetsAccount = ChartOfAccount::where('company_id', 3)
        ->where('account_code', '1100')
        ->first();

    if ($currentAssetsAccount && $account->parent_id != $currentAssetsAccount->id) {
        echo "تصحيح الحساب الأب للحساب الرئيسي من {$account->parent_id} إلى {$currentAssetsAccount->id}.\n";
        $account->parent_id = $currentAssetsAccount->id;
        $account->level = $currentAssetsAccount->level + 1;
        $account->save();
    }

    // التحقق من مستويات الحسابات الفرعية
    $childAccounts = ChartOfAccount::where('parent_id', $account->id)->get();
    echo "عدد الحسابات الفرعية: " . $childAccounts->count() . "\n";

    foreach ($childAccounts as $child) {
        if ($child->level != $account->level + 1) {
            echo "تصحيح مستوى الحساب الفرعي: ID: {$child->id}, الاسم: {$child->name} من {$child->level} إلى " . ($account->level + 1) . "\n";
            $child->level = $account->level + 1;
            $child->save();
        }
    }
} else {
    echo "لا يوجد حساب بنك رئيسي للشركة 3. سيتم إنشاء حساب جديد.\n";

    // البحث عن حساب الأصول المتداولة
    $currentAssetsAccount = ChartOfAccount::where('company_id', 3)
        ->where('account_code', '1100')
        ->first();

    if (!$currentAssetsAccount) {
        echo "لم يتم العثور على حساب الأصول المتداولة للشركة 3. لا يمكن إنشاء حساب البنك الرئيسي.\n";
        exit;
    }

    // إنشاء حساب البنك الرئيسي
    $bankAccount = new ChartOfAccount();
    $bankAccount->company_id = 3;
    $bankAccount->account_code = 'BANK';
    $bankAccount->name = 'حسابات بنكية';
    $bankAccount->name_en = 'Bank Accounts';
    $bankAccount->account_type = 'asset';
    $bankAccount->sub_type = 'bank';
    $bankAccount->parent_id = $currentAssetsAccount->id;
    $bankAccount->description = 'حساب الأصول البنكية الرئيسي';
    $bankAccount->is_active = true;
    $bankAccount->is_system = true;
    $bankAccount->is_parent = true;
    $bankAccount->opening_balance = 0;
    $bankAccount->current_balance = 0;
    $bankAccount->currency = 'SAR';
    $bankAccount->balance_type = 'debit';
    $bankAccount->is_cash_account = false;
    $bankAccount->is_bank_account = true;
    $bankAccount->level = $currentAssetsAccount->level + 1;

    try {
        $bankAccount->save();
        echo "تم إنشاء حساب البنك الرئيسي بنجاح: ID: {$bankAccount->id}\n";
    } catch (\Exception $e) {
        echo "فشل في إنشاء حساب البنك الرئيسي: " . $e->getMessage() . "\n";
    }
}

echo "\nتم الانتهاء من إصلاح مشكلة تكرار حساب البنك الرئيسي.\n";
