<?php

// Cargar la aplicación
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

// Función para verificar si un asiento contable tiene cuentas de clientes
function hasCustomerAccounts($journalEntry)
{
    $items = \App\Models\JournalEntryItem::where('journal_entry_id', $journalEntry->id)->get();

    foreach ($items as $item) {
        $account = \App\Models\ChartOfAccount::find($item->account_id);

        if ($account && $account->account_type == 'asset' && $account->sub_type == 'accounts_receivable' && !$account->is_parent) {
            return true;
        }
    }

    return false;
}

// Obtener todos los registros de journal entries que estén publicados
$entries = \App\Models\JournalEntry::where('is_posted', true)->get();
echo "Total de registros publicados encontrados: " . $entries->count() . "\n\n";

$fixed = 0;
$skipped = 0;
$errors = 0;
$noCustomerAccounts = 0;

foreach ($entries as $entry) {
    echo "Procesando ID: " . $entry->id . " - Número: " . $entry->entry_number . "\n";

    // Verificar si ya tiene un registro en customer_statements
    $existingStatements = \App\Models\CustomerStatement::where('reference_type', 'App\\Models\\JournalEntry')
        ->where('reference_id', $entry->id)
        ->count();

    if ($existingStatements > 0) {
        echo "  - Ya tiene " . $existingStatements . " registros en customer_statements. Omitiendo.\n";
        $skipped++;
        continue;
    }

    // Verificar si el asiento contable tiene cuentas de clientes
    if (!hasCustomerAccounts($entry)) {
        echo "  - No tiene cuentas de clientes. Omitiendo.\n";
        $noCustomerAccounts++;
        continue;
    }

    // Intentar crear un registro de estado de cuenta para este asiento contable
    try {
        $result = \App\Models\CustomerStatement::createForJournalEntry($entry);

        if ($result) {
            echo "  - Se creó correctamente un registro de estado de cuenta para el cliente.\n";
            $fixed++;
        } else {
            echo "  - No se pudo crear un registro de estado de cuenta a pesar de tener cuentas de clientes.\n";
            $errors++;
        }
    } catch (\Exception $e) {
        echo "  - Error al crear el registro de estado de cuenta: " . $e->getMessage() . "\n";
        $errors++;
    }

    echo "----------------------------------------\n";
}

echo "\nResumen:\n";
echo "Total de asientos procesados: " . $entries->count() . "\n";
echo "Asientos corregidos: " . $fixed . "\n";
echo "Asientos omitidos (ya tenían registros): " . $skipped . "\n";
echo "Asientos sin cuentas de clientes: " . $noCustomerAccounts . "\n";
echo "Errores: " . $errors . "\n";

// Verificar si hay asientos que deberían tener registros pero no los tienen
echo "\nVerificando asientos que deberían tener registros pero no los tienen...\n";

$missingStatements = 0;

foreach ($entries as $entry) {
    $hasCustomerAccounts = hasCustomerAccounts($entry);
    $hasStatements = \App\Models\CustomerStatement::where('reference_type', 'App\\Models\\JournalEntry')
        ->where('reference_id', $entry->id)
        ->exists();

    if ($hasCustomerAccounts && !$hasStatements) {
        $missingStatements++;
        echo "Asiento ID: " . $entry->id . " - Número: " . $entry->entry_number . " tiene cuentas de clientes pero no tiene registros en customer_statements.\n";
    }
}

echo "\nAsientos con cuentas de clientes pero sin registros en customer_statements: " . $missingStatements . "\n";

// Verificar si hay registros huérfanos en customer_statements
echo "\nVerificando registros huérfanos en customer_statements...\n";

$orphanedStatements = \App\Models\CustomerStatement::where('reference_type', 'App\\Models\\JournalEntry')
    ->whereNotIn('reference_id', $entries->pluck('id'))
    ->count();

echo "Registros huérfanos en customer_statements: " . $orphanedStatements . "\n";
