# نظام الإشعارات المتقدم للصيانة الدورية

## نظرة عامة

يوفر نظام الإشعارات المتقدم للصيانة الدورية آلية شاملة لإدارة وتتبع جدولة الصيانة وإرسال إشعارات مخصصة للمستخدمين المعنيين. يتضمن النظام عدة أنواع من الإشعارات بناءً على حالة الصيانة وأولويتها.

## أنواع الإشعارات

### 1. إشعارات الصيانة المستقبلية
- **النوع**: `maintenance_due`
- **الوصف**: إشعارات للصيانة المستحقة خلال الأيام القادمة (عادة 7 أيام)
- **الأولوية**: عادية

### 2. إشعارات الصيانة العاجلة
- **النوع**: `maintenance_urgent`
- **الوصف**: إشعارات للصيانة المستحقة خلال يومين
- **الأولوية**: عالية

### 3. إشعارات الصيانة اليومية
- **النوع**: `maintenance_today`
- **الوصف**: إشعارات للصيانة المستحقة اليوم
- **الأولوية**: عالية
- **خصائص إضافية**: `requires_immediate_action: true`

### 4. إشعارات الصيانة المتأخرة
- **النوع**: `maintenance_overdue`
- **الوصف**: إشعارات للصيانة التي تجاوزت موعدها المحدد
- **الأولوية**: عالية

### 5. إشعارات الصيانة المتأخرة بشكل حرج
- **النوع**: `maintenance_critical_overdue`
- **الوصف**: إشعارات للصيانة المتأخرة لأكثر من 7 أيام
- **الأولوية**: حرجة

## جدولة الإشعارات

يتم التحقق من حالة الصيانة وإنشاء الإشعارات المناسبة من خلال عدة أوامر مجدولة:

### 1. التحقق من الصيانة المستقبلية
- **الأمر**: `maintenance:check-schedules`
- **الجدولة**: يومياً في الساعة 8:00 صباحاً
- **الوظيفة**: التحقق من الصيانة المستحقة خلال الأيام القادمة (7 أيام)

### 2. التحقق من الصيانة المستحقة اليوم
- **الأمر**: `maintenance:check-daily`
- **الجدولة**: يومياً في الساعة 7:00 صباحاً و 12:00 ظهراً
- **الوظيفة**: التحقق من الصيانة المستحقة اليوم وإرسال إشعارات فورية

### 3. التحقق من الصيانة المتأخرة
- **الأمر**: `maintenance:check-overdue`
- **الجدولة**: يومياً في الساعة 9:00 صباحاً
- **الوظيفة**: التحقق من الصيانة المتأخرة وإرسال إشعارات بمستويات أولوية مختلفة

### 4. التحقق من جميع أنواع الصيانة
- **الأمر**: `maintenance:check-all`
- **الجدولة**: أسبوعياً يوم الأحد في الساعة 6:00 صباحاً وشهرياً في اليوم الأول
- **الوظيفة**: التحقق من جميع أنواع الصيانة (اليومية، المستقبلية، المتأخرة) وإرسال الإشعارات

## إرسال الإشعارات

يتم إرسال الإشعارات المعلقة بشكل دوري من خلال:

- **الأمر**: `notifications:send-pending`
- **الجدولة**: كل ساعة
- **الوظيفة**: إرسال جميع الإشعارات المعلقة عبر القنوات المختلفة (البريد الإلكتروني، الرسائل النصية، إشعارات التطبيق)

## واجهة المستخدم

### 1. لوحة التحكم
- عرض ملخص للصيانة المستحقة والمتأخرة
- عرض الإشعارات العاجلة التي تتطلب اهتماماً فورياً
- روابط سريعة للوصول إلى تفاصيل الصيانة وجدولتها

### 2. صفحة الإشعارات
- عرض جميع الإشعارات مع إمكانية التصفية حسب النوع والأولوية والحالة
- تمييز الإشعارات غير المقروءة
- إمكانية تحديد الإشعارات كمقروءة أو حذفها

### 3. صفحة تفاصيل الإشعار
- عرض تفاصيل كاملة للإشعار
- روابط للوصول إلى جدولة الصيانة وبيانات المصعد
- عرض البيانات الإضافية المرتبطة بالإشعار

## الفئات المستهدفة

يتم توجيه الإشعارات إلى فئات مختلفة من المستخدمين بناءً على نوع الإشعار وأولويته:

1. **الفنيون**: يتلقون إشعارات الصيانة اليومية والعاجلة والمتأخرة
2. **مدراء الصيانة**: يتلقون جميع أنواع الإشعارات
3. **مدراء الفروع**: يتلقون إشعارات الصيانة العاجلة والمتأخرة
4. **المدراء العامون**: يتلقون فقط إشعارات الصيانة المتأخرة بشكل حرج

## الاستخدام

### 1. تشغيل جدولة الإشعارات
```bash
# تشغيل جميع الأوامر المجدولة
php artisan schedule:run

# تشغيل أمر محدد يدوياً
php artisan maintenance:check-daily
php artisan maintenance:check-overdue
php artisan maintenance:check-all
php artisan notifications:send-pending
```

### 2. إعداد Cron Job
يجب إعداد Cron Job لتشغيل جدولة Laravel كل دقيقة:

```
* * * * * cd /path-to-your-project && php artisan schedule:run >> /dev/null 2>&1
```

## التخصيص

يمكن تخصيص نظام الإشعارات من خلال:

1. تعديل فترات التحقق في ملف `app/Console/Kernel.php`
2. إضافة أنواع جديدة من الإشعارات في خدمة `NotificationService`
3. تخصيص قوالب الإشعارات في مجلد `resources/views/notifications`
4. تعديل قنوات الإرسال في ملف `config/notifications.php`