# نظام إدارة أقساط الفواتير

## نظرة عامة

نظام إدارة أقساط الفواتير هو جزء من نظام ERP الخاص بالمصاعد، ويوفر إمكانية تقسيط الفواتير على دفعات متعددة، ومتابعة حالة الأقساط، وإرسال تذكيرات للعملاء بالأقساط المستحقة.

## الميزات الرئيسية

1. **إنشاء وإدارة الأقساط**:
   - إنشاء أقساط للفواتير بشكل يدوي أو تلقائي
   - تحديد مبلغ وتاريخ استحقاق كل قسط
   - تعديل وحذف الأقساط

2. **متابعة حالة الأقساط**:
   - عرض الأقساط المدفوعة والمستحقة والمتأخرة
   - تحديث حالة الأقساط تلقائياً
   - تسجيل المدفوعات للأقساط

3. **التقارير والإحصائيات**:
   - لوحة معلومات شاملة للأقساط
   - تقارير الأقساط المتأخرة
   - تقارير الأقساط المستحقة قريباً
   - إحصائيات مالية للأقساط

4. **نظام الإشعارات والتذكيرات**:
   - إرسال تذكيرات للعملاء بالأقساط المستحقة
   - إشعارات للمستخدمين المسؤولين عن متابعة الأقساط
   - تسجيل سجلات الإشعارات

## الصفحات الرئيسية

1. **لوحة معلومات الأقساط** (`/invoice-installments/dashboard`):
   - عرض إحصائيات الأقساط
   - الأقساط المستحقة خلال الأسبوع القادم
   - الأقساط المتأخرة
   - رسوم بيانية للأقساط

2. **قائمة الأقساط** (`/invoice-installments`):
   - عرض جميع الأقساط
   - تصفية وفرز الأقساط
   - إجراءات سريعة للأقساط

3. **تقرير الأقساط المتأخرة** (`/invoice-installments/reports/overdue`):
   - عرض الأقساط المتأخرة
   - إحصائيات الأقساط المتأخرة
   - إجراءات للأقساط المتأخرة

4. **تقرير الأقساط المستحقة قريباً** (`/invoice-installments/reports/upcoming`):
   - عرض الأقساط المستحقة خلال الـ 30 يوم القادمة
   - إحصائيات الأقساط المستحقة
   - إجراءات للأقساط المستحقة

## الأوامر المجدولة

1. **تحديث حالة الأقساط المتأخرة** (`installments:update-overdue`):
   - يعمل يومياً في الساعة 00:05 صباحاً
   - يحدث حالة الأقساط المتأخرة تلقائياً
   - يحدث حالة الفواتير المرتبطة بالأقساط المتأخرة

2. **إرسال تذكيرات الأقساط** (`installments:send-reminders`):
   - يعمل يومياً في الساعة 09:00 صباحاً
   - يرسل تذكيرات للعملاء بالأقساط المستحقة خلال 7 أيام
   - يرسل تذكيرات للعملاء بالأقساط المتأخرة

## نموذج البيانات

### جدول `invoice_installments`

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | int | المعرف الفريد للقسط |
| invoice_id | int | معرف الفاتورة المرتبطة |
| amount | decimal | مبلغ القسط |
| paid_amount | decimal | المبلغ المدفوع من القسط |
| due_date | date | تاريخ استحقاق القسط |
| status | enum | حالة القسط (pending, paid, overdue, cancelled) |
| notes | text | ملاحظات إضافية |
| created_at | timestamp | تاريخ إنشاء القسط |
| updated_at | timestamp | تاريخ آخر تحديث للقسط |

## الطرق المساعدة

### نموذج `InvoiceInstallment`

1. **`isPaid()`**: التحقق من أن القسط مدفوع بالكامل
2. **`isPartiallyPaid()`**: التحقق من أن القسط مدفوع جزئياً
3. **`isOverdue()`**: التحقق من أن القسط متأخر
4. **`getRemainingAmount()`**: الحصول على المبلغ المتبقي للقسط
5. **`getPaymentProgressPercentage()`**: الحصول على نسبة الدفع للقسط
6. **`getStatusLabel()`**: الحصول على وسم حالة القسط
7. **`getDaysRemainingOrOverdue()`**: الحصول على الأيام المتبقية أو المتأخرة للقسط

### ملف المساعدة `InstallmentHelper`

1. **`createInstallmentsForInvoice()`**: إنشاء أقساط تلقائية للفاتورة
2. **`getInstallmentStats()`**: الحصول على إحصائيات الأقساط للشركة
3. **`getUpcomingInstallments()`**: الحصول على الأقساط المستحقة قريباً
4. **`getOverdueInstallments()`**: الحصول على الأقساط المتأخرة

## الإشعارات

### `InstallmentDueNotification`

إشعار يتم إرساله للعملاء والمستخدمين المسؤولين عن متابعة الأقساط، ويحتوي على:

- تفاصيل القسط المستحق أو المتأخر
- تاريخ الاستحقاق
- المبلغ المستحق
- رابط لعرض تفاصيل الفاتورة

## الصلاحيات المطلوبة

- **`view_installments`**: عرض الأقساط
- **`create_installments`**: إنشاء أقساط جديدة
- **`edit_installments`**: تعديل الأقساط
- **`delete_installments`**: حذف الأقساط
- **`record_installment_payments`**: تسجيل مدفوعات للأقساط
- **`send_installment_reminders`**: إرسال تذكيرات للأقساط
- **`view_installment_reports`**: عرض تقارير الأقساط

## كيفية الاستخدام

### إنشاء أقساط لفاتورة

```php
use App\Helpers\InstallmentHelper;

// إنشاء 3 أقساط شهرية للفاتورة
$result = InstallmentHelper::createInstallmentsForInvoice(
    $invoice,
    3,
    now()->format('Y-m-d'),
    'month',
    'أقساط شهرية'
);

if ($result['success']) {
    // تم إنشاء الأقساط بنجاح
    $installments = $result['installments'];
} else {
    // حدث خطأ أثناء إنشاء الأقساط
    $errorMessage = $result['message'];
}
```

### تسجيل دفعة لقسط

```php
use App\Models\InvoiceInstallment;
use App\Models\Payment;
use Illuminate\Support\Facades\DB;

DB::beginTransaction();

try {
    // الحصول على القسط
    $installment = InvoiceInstallment::findOrFail($installmentId);
    
    // إنشاء سجل الدفعة
    $payment = new Payment([
        'company_id' => $companyId,
        'invoice_id' => $installment->invoice_id,
        'payment_method_id' => $paymentMethodId,
        'amount' => $amount,
        'payment_date' => $paymentDate,
        'reference_number' => $referenceNumber,
        'notes' => $notes,
        'status' => 'completed',
        'created_by' => auth()->id(),
    ]);
    
    // ربط الدفعة بالقسط
    $installment->payments()->save($payment);
    
    // تحديث المبلغ المدفوع للقسط
    $installment->paid_amount += $amount;
    
    // تحديث حالة القسط
    if ($installment->paid_amount >= $installment->amount) {
        $installment->status = 'paid';
    } elseif ($installment->status === 'overdue') {
        $installment->status = 'partially_paid';
    }
    
    $installment->save();
    
    // تحديث المبالغ المدفوعة والمستحقة للفاتورة
    $invoice = $installment->invoice;
    $invoice->paid_amount += $amount;
    $invoice->due_amount -= $amount;
    
    // تحديث حالة الفاتورة
    if ($invoice->due_amount <= 0) {
        $invoice->status = 'paid';
    } else {
        $invoice->status = 'partially_paid';
    }
    
    $invoice->save();
    
    DB::commit();
    
    return true;
} catch (\Exception $e) {
    DB::rollBack();
    return false;
}
```

### الحصول على إحصائيات الأقساط

```php
use App\Helpers\InstallmentHelper;

// الحصول على إحصائيات الأقساط للشركة الحالية
$stats = InstallmentHelper::getInstallmentStats(auth()->user()->company_id);

// عرض الإحصائيات
echo "إجمالي الأقساط: " . $stats['total'] . "\n";
echo "الأقساط المدفوعة: " . $stats['paid'] . "\n";
echo "الأقساط قيد الانتظار: " . $stats['pending'] . "\n";
echo "الأقساط المتأخرة: " . $stats['overdue'] . "\n";
echo "إجمالي المبالغ: " . $stats['total_amount'] . "\n";
echo "المبالغ المدفوعة: " . $stats['paid_amount'] . "\n";
echo "المبالغ المستحقة: " . $stats['due_amount'] . "\n";
echo "المبالغ المتأخرة: " . $stats['overdue_amount'] . "\n";
```