# نظام إدارة مهام الموظفين

## نظرة عامة

نظام إدارة مهام الموظفين هو إضافة جديدة لنظام إدارة الموارد البشرية في Elevators ERP. يوفر هذا النظام إمكانية إنشاء وتتبع وإدارة المهام المسندة للموظفين، مع دعم كامل للتعليقات والمرفقات وتتبع حالة المهام.

## الميزات الرئيسية

- إنشاء مهام جديدة وتعيينها لموظف واحد أو أكثر
- تتبع حالة المهام (قيد الانتظار، قيد التنفيذ، مكتملة، ملغية)
- تحديد أولوية المهام (منخفضة، متوسطة، عالية، عاجلة)
- تتبع نسبة إنجاز المهام
- إضافة تعليقات على المهام
- إرفاق ملفات بالمهام
- لوحة معلومات تحليلية للمهام
- تقارير وإحصائيات عن المهام

## هيكل النظام

### النماذج (Models)

- `Task`: نموذج المهمة الرئيسي
- `TaskAssignee`: نموذج تعيين المهام للموظفين
- `TaskComment`: نموذج تعليقات المهام
- `TaskAttachment`: نموذج مرفقات المهام

### المتحكمات (Controllers)

- `TaskController`: إدارة المهام (عرض، إنشاء، تعديل، حذف)
- `TaskAssigneeController`: إدارة تعيين المهام للموظفين
- `TaskCommentController`: إدارة تعليقات المهام
- `TaskAttachmentController`: إدارة مرفقات المهام
- `TaskDashboardController`: عرض لوحة معلومات المهام

### المسارات (Routes)

جميع مسارات النظام موجودة في ملف `routes/hrm.php` تحت مجموعة `hrm.tasks`.

### الصلاحيات (Permissions)

تم إنشاء مجموعة من الصلاحيات لنظام إدارة المهام في ملف `EmployeeTasksPermissionsSeeder.php`:

- `view_employee_tasks`: عرض المهام
- `create_employee_task`: إنشاء مهام جديدة
- `edit_employee_task`: تعديل المهام
- `delete_employee_task`: حذف المهام
- `manage_employee_tasks`: إدارة كاملة للمهام
- `update_task_status`: تحديث حالة المهام
- `update_task_progress`: تحديث نسبة إنجاز المهام
- `view_task_assignments`: عرض تعيينات المهام
- `create_task_assignment`: إضافة موظفين للمهام
- `delete_task_assignment`: إزالة موظفين من المهام
- `manage_task_assignments`: إدارة كاملة لتعيينات المهام
- `view_task_comments`: عرض تعليقات المهام
- `create_task_comment`: إضافة تعليقات على المهام
- `edit_task_comment`: تعديل التعليقات
- `delete_task_comment`: حذف التعليقات
- `manage_task_comments`: إدارة كاملة للتعليقات
- `view_task_attachments`: عرض مرفقات المهام
- `upload_task_attachment`: رفع مرفقات للمهام
- `delete_task_attachment`: حذف مرفقات المهام
- `manage_task_attachments`: إدارة كاملة لمرفقات المهام
- `view_task_dashboard`: عرض لوحة معلومات المهام
- `view_task_reports`: عرض تقارير المهام
- `export_task_reports`: تصدير تقارير المهام

## واجهات المستخدم

### قائمة المهام
`resources/views/hrm/tasks/index.blade.php`

عرض قائمة بجميع المهام مع إمكانية التصفية والبحث.

### إنشاء مهمة جديدة
`resources/views/hrm/tasks/create.blade.php`

نموذج لإنشاء مهمة جديدة وتعيينها للموظفين.

### عرض تفاصيل المهمة
`resources/views/hrm/tasks/show.blade.php`

عرض تفاصيل المهمة مع التعليقات والمرفقات وسجل التغييرات.

### تعديل المهمة
`resources/views/hrm/tasks/edit.blade.php`

نموذج لتعديل المهمة وتحديث حالتها ونسبة الإنجاز.

### لوحة معلومات المهام
`resources/views/hrm/tasks/dashboard.blade.php`

لوحة معلومات تحليلية تعرض إحصائيات وبيانات عن المهام.

## العلاقات مع الأنظمة الأخرى

- **نظام إدارة الموظفين**: ربط المهام بالموظفين من خلال نموذج `Employee`
- **نظام الأقسام**: ربط المهام بالأقسام من خلال نموذج `Department`
- **نظام الإشعارات**: إرسال إشعارات للموظفين عند تعيين مهام جديدة أو تحديث حالة المهام

## التطوير المستقبلي

- إضافة نظام تذكير للمهام المتأخرة
- إضافة إمكانية تكرار المهام بشكل دوري
- إضافة نظام تقييم أداء الموظفين بناءً على إنجاز المهام
- إضافة إمكانية ربط المهام بالمشاريع
- تطوير واجهة مستخدم متقدمة باستخدام تقنيات JavaScript الحديثة

## الاستخدام

### إنشاء مهمة جديدة

1. انتقل إلى "إدارة الموارد البشرية" > "إدارة المهام" > "إضافة مهمة جديدة"
2. أدخل عنوان المهمة ووصفها
3. حدد الموظفين المكلفين بالمهمة
4. حدد تاريخ البدء وتاريخ الانتهاء
5. حدد أولوية المهمة
6. انقر على "حفظ" لإنشاء المهمة

### متابعة المهام

1. انتقل إلى "إدارة الموارد البشرية" > "إدارة المهام" > "قائمة المهام"
2. استخدم خيارات التصفية لعرض المهام حسب الحالة أو الأولوية أو الموظف
3. انقر على عنوان المهمة لعرض تفاصيلها

### تحديث حالة المهمة

1. افتح صفحة تفاصيل المهمة
2. انقر على "تعديل"
3. حدد الحالة الجديدة ونسبة الإنجاز
4. انقر على "حفظ" لتحديث المهمة

### إضافة تعليق

1. افتح صفحة تفاصيل المهمة
2. اكتب تعليقك في مربع النص أسفل الصفحة
3. انقر على "إضافة تعليق"

### رفع مرفق

1. افتح صفحة تفاصيل المهمة
2. انقر على "إضافة مرفق"
3. اختر الملف من جهازك
4. أدخل وصفاً للمرفق
5. انقر على "رفع"

## استكشاف الأخطاء وإصلاحها

### المهام لا تظهر في القائمة

- تأكد من أن المستخدم لديه صلاحية `view_employee_tasks`
- تحقق من إعدادات التصفية في صفحة قائمة المهام

### خطأ عند إنشاء مهمة جديدة

- تأكد من إدخال جميع الحقول المطلوبة
- تحقق من صحة تنسيق التواريخ
- تأكد من اختيار موظف واحد على الأقل للمهمة

### خطأ عند رفع مرفقات

- تحقق من حجم الملف (الحد الأقصى: 10 ميجابايت)
- تأكد من أن نوع الملف مسموح به
- تحقق من صلاحيات المجلد `storage/app/public/task_attachments`