# توثيق واجهة برمجة التطبيقات (API) - نظام إدارة مهام الموظفين

## مقدمة

يوفر نظام إدارة مهام الموظفين واجهة برمجة تطبيقات (API) تتيح للتطبيقات الخارجية التفاعل مع النظام. تستخدم واجهة البرمجة معيار REST وتستجيب بتنسيق JSON.

## نقاط النهاية (Endpoints)

### المصادقة

جميع طلبات API تتطلب مصادقة باستخدام Laravel Sanctum. يجب إرسال رمز الوصول (Access Token) في رأس الطلب:

```
Authorization: Bearer {token}
```

### المهام

#### الحصول على قائمة المهام

```
GET /api/hrm/tasks
```

**المعلمات**:

- `status` (اختياري): تصفية حسب الحالة (pending, in_progress, completed, cancelled)
- `priority` (اختياري): تصفية حسب الأولوية (low, medium, high, urgent)
- `employee_id` (اختياري): تصفية حسب معرف الموظف
- `start_date` (اختياري): تصفية حسب تاريخ البدء
- `due_date` (اختياري): تصفية حسب تاريخ الاستحقاق
- `overdue` (اختياري): تصفية المهام المتأخرة (true/false)
- `search` (اختياري): البحث في العنوان والوصف

**الاستجابة**:

```json
{
  "data": [
    {
      "id": 1,
      "title": "عنوان المهمة",
      "description": "وصف المهمة",
      "status": "pending",
      "status_label": "قيد الانتظار",
      "priority": "medium",
      "priority_label": "متوسطة",
      "start_date": "2023-07-01",
      "due_date": "2023-07-15",
      "progress": 0,
      "is_overdue": false,
      "days_remaining": 5,
      "created_by": {
        "id": 1,
        "name": "اسم المستخدم"
      },
      "assignees": [
        {
          "id": 1,
          "employee": {
            "id": 1,
            "full_name": "اسم الموظف"
          }
        }
      ],
      "created_at": "2023-07-01T10:00:00.000000Z",
      "updated_at": "2023-07-01T10:00:00.000000Z"
    }
  ],
  "links": {
    "first": "http://example.com/api/hrm/tasks?page=1",
    "last": "http://example.com/api/hrm/tasks?page=1",
    "prev": null,
    "next": null
  },
  "meta": {
    "current_page": 1,
    "from": 1,
    "last_page": 1,
    "path": "http://example.com/api/hrm/tasks",
    "per_page": 15,
    "to": 1,
    "total": 1
  }
}
```

#### الحصول على تفاصيل مهمة

```
GET /api/hrm/tasks/{id}
```

**الاستجابة**:

```json
{
  "data": {
    "id": 1,
    "title": "عنوان المهمة",
    "description": "وصف المهمة",
    "status": "pending",
    "status_label": "قيد الانتظار",
    "priority": "medium",
    "priority_label": "متوسطة",
    "start_date": "2023-07-01",
    "due_date": "2023-07-15",
    "progress": 0,
    "is_overdue": false,
    "days_remaining": 5,
    "created_by": {
      "id": 1,
      "name": "اسم المستخدم"
    },
    "assignees": [
      {
        "id": 1,
        "employee": {
          "id": 1,
          "full_name": "اسم الموظف"
        }
      }
    ],
    "comments": [
      {
        "id": 1,
        "user": {
          "id": 1,
          "name": "اسم المستخدم"
        },
        "comment": "نص التعليق",
        "created_at": "2023-07-01T10:30:00.000000Z"
      }
    ],
    "attachments": [
      {
        "id": 1,
        "user": {
          "id": 1,
          "name": "اسم المستخدم"
        },
        "file_name": "اسم الملف.pdf",
        "file_size": 1024,
        "file_type": "application/pdf",
        "description": "وصف المرفق",
        "created_at": "2023-07-01T10:45:00.000000Z"
      }
    ],
    "created_at": "2023-07-01T10:00:00.000000Z",
    "updated_at": "2023-07-01T10:00:00.000000Z"
  }
}
```

#### إنشاء مهمة جديدة

```
POST /api/hrm/tasks
```

**المعلمات**:

- `title` (مطلوب): عنوان المهمة
- `description` (اختياري): وصف المهمة
- `status` (مطلوب): حالة المهمة (pending, in_progress, completed, cancelled)
- `priority` (مطلوب): أولوية المهمة (low, medium, high, urgent)
- `start_date` (مطلوب): تاريخ بدء المهمة (YYYY-MM-DD)
- `due_date` (مطلوب): تاريخ استحقاق المهمة (YYYY-MM-DD)
- `progress` (اختياري): نسبة الإنجاز (0-100)
- `assignees` (مطلوب): مصفوفة تحتوي على معرفات الموظفين المكلفين بالمهمة

**الاستجابة**:

```json
{
  "data": {
    "id": 1,
    "title": "عنوان المهمة",
    "description": "وصف المهمة",
    "status": "pending",
    "status_label": "قيد الانتظار",
    "priority": "medium",
    "priority_label": "متوسطة",
    "start_date": "2023-07-01",
    "due_date": "2023-07-15",
    "progress": 0,
    "is_overdue": false,
    "days_remaining": 5,
    "created_by": {
      "id": 1,
      "name": "اسم المستخدم"
    },
    "assignees": [
      {
        "id": 1,
        "employee": {
          "id": 1,
          "full_name": "اسم الموظف"
        }
      }
    ],
    "created_at": "2023-07-01T10:00:00.000000Z",
    "updated_at": "2023-07-01T10:00:00.000000Z"
  },
  "message": "تم إنشاء المهمة بنجاح"
}
```

#### تحديث مهمة

```
PUT /api/hrm/tasks/{id}
```

**المعلمات**:

- `title` (اختياري): عنوان المهمة
- `description` (اختياري): وصف المهمة
- `status` (اختياري): حالة المهمة (pending, in_progress, completed, cancelled)
- `priority` (اختياري): أولوية المهمة (low, medium, high, urgent)
- `start_date` (اختياري): تاريخ بدء المهمة (YYYY-MM-DD)
- `due_date` (اختياري): تاريخ استحقاق المهمة (YYYY-MM-DD)
- `progress` (اختياري): نسبة الإنجاز (0-100)

**الاستجابة**:

```json
{
  "data": {
    "id": 1,
    "title": "عنوان المهمة المحدث",
    "description": "وصف المهمة المحدث",
    "status": "in_progress",
    "status_label": "قيد التنفيذ",
    "priority": "high",
    "priority_label": "عالية",
    "start_date": "2023-07-01",
    "due_date": "2023-07-20",
    "progress": 25,
    "is_overdue": false,
    "days_remaining": 10,
    "created_by": {
      "id": 1,
      "name": "اسم المستخدم"
    },
    "assignees": [
      {
        "id": 1,
        "employee": {
          "id": 1,
          "full_name": "اسم الموظف"
        }
      }
    ],
    "created_at": "2023-07-01T10:00:00.000000Z",
    "updated_at": "2023-07-05T11:30:00.000000Z"
  },
  "message": "تم تحديث المهمة بنجاح"
}
```

#### تحديث حالة المهمة

```
PATCH /api/hrm/tasks/{id}/status
```

**المعلمات**:

- `status` (مطلوب): حالة المهمة (pending, in_progress, completed, cancelled)

**الاستجابة**:

```json
{
  "data": {
    "id": 1,
    "status": "completed",
    "status_label": "مكتملة",
    "updated_at": "2023-07-10T09:15:00.000000Z"
  },
  "message": "تم تحديث حالة المهمة بنجاح"
}
```

#### تحديث نسبة إنجاز المهمة

```
PATCH /api/hrm/tasks/{id}/progress
```

**المعلمات**:

- `progress` (مطلوب): نسبة الإنجاز (0-100)

**الاستجابة**:

```json
{
  "data": {
    "id": 1,
    "progress": 75,
    "updated_at": "2023-07-10T09:30:00.000000Z"
  },
  "message": "تم تحديث نسبة إنجاز المهمة بنجاح"
}
```

#### حذف مهمة

```
DELETE /api/hrm/tasks/{id}
```

**الاستجابة**:

```json
{
  "message": "تم حذف المهمة بنجاح"
}
```

### تعيين المهام

#### إضافة موظف للمهمة

```
POST /api/hrm/tasks/{id}/assignees
```

**المعلمات**:

- `employee_id` (مطلوب): معرف الموظف

**الاستجابة**:

```json
{
  "data": {
    "id": 2,
    "task_id": 1,
    "employee": {
      "id": 2,
      "full_name": "اسم الموظف الجديد"
    },
    "assigned_by": {
      "id": 1,
      "name": "اسم المستخدم"
    },
    "created_at": "2023-07-10T10:00:00.000000Z"
  },
  "message": "تم تعيين الموظف للمهمة بنجاح"
}
```

#### إزالة موظف من المهمة

```
DELETE /api/hrm/tasks/{task_id}/assignees/{assignee_id}
```

**الاستجابة**:

```json
{
  "message": "تم إزالة الموظف من المهمة بنجاح"
}
```

### تعليقات المهام

#### إضافة تعليق جديد

```
POST /api/hrm/tasks/{id}/comments
```

**المعلمات**:

- `comment` (مطلوب): نص التعليق

**الاستجابة**:

```json
{
  "data": {
    "id": 2,
    "task_id": 1,
    "user": {
      "id": 1,
      "name": "اسم المستخدم"
    },
    "comment": "نص التعليق الجديد",
    "created_at": "2023-07-10T11:00:00.000000Z"
  },
  "message": "تم إضافة التعليق بنجاح"
}
```

#### تعديل تعليق

```
PUT /api/hrm/tasks/{task_id}/comments/{comment_id}
```

**المعلمات**:

- `comment` (مطلوب): نص التعليق المعدل

**الاستجابة**:

```json
{
  "data": {
    "id": 2,
    "task_id": 1,
    "user": {
      "id": 1,
      "name": "اسم المستخدم"
    },
    "comment": "نص التعليق المعدل",
    "created_at": "2023-07-10T11:00:00.000000Z",
    "updated_at": "2023-07-10T11:15:00.000000Z"
  },
  "message": "تم تعديل التعليق بنجاح"
}
```

#### حذف تعليق

```
DELETE /api/hrm/tasks/{task_id}/comments/{comment_id}
```

**الاستجابة**:

```json
{
  "message": "تم حذف التعليق بنجاح"
}
```

### مرفقات المهام

#### رفع مرفق جديد

```
POST /api/hrm/tasks/{id}/attachments
```

**المعلمات**:

- `file` (مطلوب): الملف المراد رفعه
- `description` (اختياري): وصف المرفق

**الاستجابة**:

```json
{
  "data": {
    "id": 2,
    "task_id": 1,
    "user": {
      "id": 1,
      "name": "اسم المستخدم"
    },
    "file_name": "اسم الملف.pdf",
    "file_size": 1024,
    "file_type": "application/pdf",
    "description": "وصف المرفق",
    "created_at": "2023-07-10T12:00:00.000000Z"
  },
  "message": "تم رفع المرفق بنجاح"
}
```

#### حذف مرفق

```
DELETE /api/hrm/tasks/{task_id}/attachments/{attachment_id}
```

**الاستجابة**:

```json
{
  "message": "تم حذف المرفق بنجاح"
}
```

#### تنزيل مرفق

```
GET /api/hrm/tasks/{task_id}/attachments/{attachment_id}/download
```

**الاستجابة**:

الملف المطلوب للتنزيل.

### لوحة المعلومات

#### الحصول على إحصائيات المهام

```
GET /api/hrm/tasks/dashboard/stats
```

**الاستجابة**:

```json
{
  "data": {
    "total_tasks": 100,
    "pending_tasks": 30,
    "in_progress_tasks": 40,
    "completed_tasks": 25,
    "cancelled_tasks": 5,
    "overdue_tasks": 10,
    "low_priority_tasks": 20,
    "medium_priority_tasks": 50,
    "high_priority_tasks": 20,
    "urgent_priority_tasks": 10,
    "recent_completed_tasks": [
      {
        "id": 5,
        "title": "عنوان المهمة",
        "completed_at": "2023-07-09T14:30:00.000000Z"
      }
    ],
    "upcoming_tasks": [
      {
        "id": 8,
        "title": "عنوان المهمة",
        "due_date": "2023-07-15",
        "days_remaining": 3
      }
    ],
    "top_employees": [
      {
        "id": 3,
        "full_name": "اسم الموظف",
        "tasks_count": 15
      }
    ]
  }
}
```

## رموز الحالة

- `200 OK`: تم تنفيذ الطلب بنجاح
- `201 Created`: تم إنشاء المورد بنجاح
- `400 Bad Request`: طلب غير صالح
- `401 Unauthorized`: المصادقة مطلوبة
- `403 Forbidden`: ليس لديك صلاحية للوصول إلى هذا المورد
- `404 Not Found`: المورد غير موجود
- `422 Unprocessable Entity`: فشل التحقق من صحة البيانات
- `500 Internal Server Error`: خطأ في الخادم

## أمثلة على الاستخدام

### الحصول على قائمة المهام المتأخرة

```javascript
fetch('http://example.com/api/hrm/tasks?overdue=true', {
  headers: {
    'Authorization': 'Bearer {token}',
    'Accept': 'application/json'
  }
})
.then(response => response.json())
.then(data => console.log(data));
```

### إنشاء مهمة جديدة

```javascript
fetch('http://example.com/api/hrm/tasks', {
  method: 'POST',
  headers: {
    'Authorization': 'Bearer {token}',
    'Content-Type': 'application/json',
    'Accept': 'application/json'
  },
  body: JSON.stringify({
    title: 'عنوان المهمة',
    description: 'وصف المهمة',
    status: 'pending',
    priority: 'medium',
    start_date: '2023-07-15',
    due_date: '2023-07-30',
    assignees: [1, 2]
  })
})
.then(response => response.json())
.then(data => console.log(data));
```

### تحديث حالة المهمة

```javascript
fetch('http://example.com/api/hrm/tasks/1/status', {
  method: 'PATCH',
  headers: {
    'Authorization': 'Bearer {token}',
    'Content-Type': 'application/json',
    'Accept': 'application/json'
  },
  body: JSON.stringify({
    status: 'completed'
  })
})
.then(response => response.json())
.then(data => console.log(data));
```

### رفع مرفق للمهمة

```javascript
const formData = new FormData();
formData.append('file', fileInput.files[0]);
formData.append('description', 'وصف المرفق');

fetch('http://example.com/api/hrm/tasks/1/attachments', {
  method: 'POST',
  headers: {
    'Authorization': 'Bearer {token}',
    'Accept': 'application/json'
  },
  body: formData
})
.then(response => response.json())
.then(data => console.log(data));
```