# توثيق واجهة برمجة التطبيقات (API) لنظام إدارة أقساط الفواتير

## نظرة عامة

توفر واجهة برمجة التطبيقات (API) لنظام إدارة أقساط الفواتير إمكانية التفاعل مع نظام الأقساط من خلال طلبات HTTP، مما يتيح للتطبيقات الخارجية والواجهات المختلفة الوصول إلى وظائف إدارة الأقساط.

## المصادقة

تستخدم جميع نقاط النهاية في واجهة برمجة التطبيقات المصادقة باستخدام Laravel Sanctum. يجب إرسال رمز المصادقة (Bearer Token) في رأس الطلب.

```
Authorization: Bearer {token}
```

## نقاط النهاية (Endpoints)

### 1. الحصول على قائمة الأقساط

```
GET /api/installments
```

#### المعلمات (Query Parameters)

| المعلمة | النوع | الوصف | مثال |
|---------|------|-------|------|
| status | string | تصفية حسب الحالة | pending, paid, overdue, cancelled |
| customer_id | integer | تصفية حسب العميل | 1 |
| due_date_from | date | تصفية حسب تاريخ الاستحقاق (من) | 2023-01-01 |
| due_date_to | date | تصفية حسب تاريخ الاستحقاق (إلى) | 2023-12-31 |
| per_page | integer | عدد العناصر في الصفحة | 15 |
| page | integer | رقم الصفحة | 1 |

#### الاستجابة

```json
{
    "status": "success",
    "data": {
        "current_page": 1,
        "data": [
            {
                "id": 1,
                "invoice_id": 100,
                "amount": 500.00,
                "paid_amount": 0.00,
                "due_date": "2023-06-15",
                "status": "pending",
                "notes": "القسط الأول",
                "created_at": "2023-05-15T10:00:00.000000Z",
                "updated_at": "2023-05-15T10:00:00.000000Z",
                "invoice": {
                    "id": 100,
                    "invoice_number": "INV-2023-100",
                    "customer": {
                        "id": 50,
                        "name": "شركة المصاعد الحديثة"
                    }
                }
            }
        ],
        "first_page_url": "http://example.com/api/installments?page=1",
        "from": 1,
        "last_page": 1,
        "last_page_url": "http://example.com/api/installments?page=1",
        "links": [
            {
                "url": null,
                "label": "&laquo; Previous",
                "active": false
            },
            {
                "url": "http://example.com/api/installments?page=1",
                "label": "1",
                "active": true
            },
            {
                "url": null,
                "label": "Next &raquo;",
                "active": false
            }
        ],
        "next_page_url": null,
        "path": "http://example.com/api/installments",
        "per_page": 15,
        "prev_page_url": null,
        "to": 1,
        "total": 1
    }
}
```

### 2. إنشاء قسط جديد

```
POST /api/installments
```

#### المعلمات (Request Body)

| المعلمة | النوع | الوصف | إلزامي |
|---------|------|-------|--------|
| invoice_id | integer | معرف الفاتورة | نعم |
| amount | decimal | مبلغ القسط | نعم |
| due_date | date | تاريخ استحقاق القسط | نعم |
| notes | string | ملاحظات إضافية | لا |

#### الاستجابة

```json
{
    "status": "success",
    "message": "تم إنشاء القسط بنجاح",
    "data": {
        "id": 1,
        "invoice_id": 100,
        "amount": 500.00,
        "paid_amount": 0.00,
        "due_date": "2023-06-15",
        "status": "pending",
        "notes": "القسط الأول",
        "created_at": "2023-05-15T10:00:00.000000Z",
        "updated_at": "2023-05-15T10:00:00.000000Z",
        "invoice": {
            "id": 100,
            "invoice_number": "INV-2023-100"
        }
    }
}
```

### 3. عرض تفاصيل قسط محدد

```
GET /api/installments/{id}
```

#### المعلمات (Path Parameters)

| المعلمة | النوع | الوصف |
|---------|------|-------|
| id | integer | معرف القسط |

#### الاستجابة

```json
{
    "status": "success",
    "data": {
        "id": 1,
        "invoice_id": 100,
        "amount": 500.00,
        "paid_amount": 0.00,
        "due_date": "2023-06-15",
        "status": "pending",
        "notes": "القسط الأول",
        "created_at": "2023-05-15T10:00:00.000000Z",
        "updated_at": "2023-05-15T10:00:00.000000Z",
        "invoice": {
            "id": 100,
            "invoice_number": "INV-2023-100",
            "customer": {
                "id": 50,
                "name": "شركة المصاعد الحديثة"
            }
        },
        "payments": []
    }
}
```

### 4. تحديث قسط محدد

```
PUT /api/installments/{id}
```

#### المعلمات (Path Parameters)

| المعلمة | النوع | الوصف |
|---------|------|-------|
| id | integer | معرف القسط |

#### المعلمات (Request Body)

| المعلمة | النوع | الوصف | إلزامي |
|---------|------|-------|--------|
| amount | decimal | مبلغ القسط | نعم |
| due_date | date | تاريخ استحقاق القسط | نعم |
| status | string | حالة القسط | نعم |
| notes | string | ملاحظات إضافية | لا |

#### الاستجابة

```json
{
    "status": "success",
    "message": "تم تحديث القسط بنجاح",
    "data": {
        "id": 1,
        "invoice_id": 100,
        "amount": 600.00,
        "paid_amount": 0.00,
        "due_date": "2023-07-15",
        "status": "pending",
        "notes": "القسط الأول (محدث)",
        "created_at": "2023-05-15T10:00:00.000000Z",
        "updated_at": "2023-05-15T11:00:00.000000Z",
        "invoice": {
            "id": 100,
            "invoice_number": "INV-2023-100"
        }
    }
}
```

### 5. حذف قسط محدد

```
DELETE /api/installments/{id}
```

#### المعلمات (Path Parameters)

| المعلمة | النوع | الوصف |
|---------|------|-------|
| id | integer | معرف القسط |

#### الاستجابة

```json
{
    "status": "success",
    "message": "تم حذف القسط بنجاح"
}
```

### 6. تسجيل دفعة لقسط محدد

```
POST /api/installments/{id}/payments
```

#### المعلمات (Path Parameters)

| المعلمة | النوع | الوصف |
|---------|------|-------|
| id | integer | معرف القسط |

#### المعلمات (Request Body)

| المعلمة | النوع | الوصف | إلزامي |
|---------|------|-------|--------|
| amount | decimal | مبلغ الدفعة | نعم |
| payment_date | date | تاريخ الدفع | نعم |
| payment_method_id | integer | معرف طريقة الدفع | نعم |
| reference_number | string | رقم المرجع | لا |
| notes | string | ملاحظات إضافية | لا |

#### الاستجابة

```json
{
    "status": "success",
    "message": "تم تسجيل الدفعة بنجاح",
    "data": {
        "installment": {
            "id": 1,
            "invoice_id": 100,
            "amount": 500.00,
            "paid_amount": 300.00,
            "due_date": "2023-06-15",
            "status": "partially_paid",
            "notes": "القسط الأول",
            "created_at": "2023-05-15T10:00:00.000000Z",
            "updated_at": "2023-05-15T12:00:00.000000Z"
        },
        "payment": {
            "id": 1,
            "company_id": 1,
            "invoice_id": 100,
            "payment_method_id": 1,
            "amount": 300.00,
            "payment_date": "2023-05-15",
            "reference_number": "REF123",
            "notes": "دفعة جزئية",
            "status": "completed",
            "created_by": 1,
            "created_at": "2023-05-15T12:00:00.000000Z",
            "updated_at": "2023-05-15T12:00:00.000000Z"
        }
    }
}
```

### 7. الحصول على الأقساط المستحقة قريباً

```
GET /api/installments/reports/upcoming
```

#### المعلمات (Query Parameters)

| المعلمة | النوع | الوصف | مثال |
|---------|------|-------|------|
| days | integer | عدد الأيام القادمة | 30 |
| limit | integer | الحد الأقصى لعدد النتائج | 100 |

#### الاستجابة

```json
{
    "status": "success",
    "data": [
        {
            "id": 1,
            "invoice_id": 100,
            "amount": 500.00,
            "paid_amount": 0.00,
            "due_date": "2023-06-15",
            "status": "pending",
            "notes": "القسط الأول",
            "created_at": "2023-05-15T10:00:00.000000Z",
            "updated_at": "2023-05-15T10:00:00.000000Z",
            "invoice": {
                "id": 100,
                "invoice_number": "INV-2023-100",
                "customer": {
                    "id": 50,
                    "name": "شركة المصاعد الحديثة"
                }
            }
        }
    ]
}
```

### 8. الحصول على الأقساط المتأخرة

```
GET /api/installments/reports/overdue
```

#### المعلمات (Query Parameters)

| المعلمة | النوع | الوصف | مثال |
|---------|------|-------|------|
| limit | integer | الحد الأقصى لعدد النتائج | 100 |

#### الاستجابة

```json
{
    "status": "success",
    "data": [
        {
            "id": 2,
            "invoice_id": 101,
            "amount": 750.00,
            "paid_amount": 0.00,
            "due_date": "2023-05-10",
            "status": "overdue",
            "notes": "القسط الثاني",
            "created_at": "2023-04-15T10:00:00.000000Z",
            "updated_at": "2023-05-11T10:00:00.000000Z",
            "invoice": {
                "id": 101,
                "invoice_number": "INV-2023-101",
                "customer": {
                    "id": 51,
                    "name": "شركة النور للمصاعد"
                }
            }
        }
    ]
}
```

### 9. الحصول على إحصائيات الأقساط

```
GET /api/installments/stats
```

#### الاستجابة

```json
{
    "status": "success",
    "data": {
        "total": 10,
        "paid": 3,
        "pending": 5,
        "overdue": 2,
        "total_amount": 5000.00,
        "paid_amount": 1500.00,
        "due_amount": 3500.00,
        "overdue_amount": 1200.00
    }
}
```

### 10. إنشاء أقساط تلقائية للفاتورة

```
POST /api/invoices/{invoice_id}/installments/auto-create
```

#### المعلمات (Path Parameters)

| المعلمة | النوع | الوصف |
|---------|------|-------|
| invoice_id | integer | معرف الفاتورة |

#### المعلمات (Request Body)

| المعلمة | النوع | الوصف | إلزامي |
|---------|------|-------|--------|
| number_of_installments | integer | عدد الأقساط | نعم |
| start_date | date | تاريخ بداية الأقساط | نعم |
| interval | string | الفاصل الزمني بين الأقساط (day, week, month) | نعم |
| notes | string | ملاحظات إضافية | لا |

#### الاستجابة

```json
{
    "status": "success",
    "message": "تم إنشاء 3 قسط بنجاح.",
    "data": [
        {
            "id": 1,
            "invoice_id": 100,
            "amount": 333.33,
            "paid_amount": 0.00,
            "due_date": "2023-06-15",
            "status": "pending",
            "notes": "قسط تلقائي (قسط 1/3)",
            "created_at": "2023-05-15T10:00:00.000000Z",
            "updated_at": "2023-05-15T10:00:00.000000Z"
        },
        {
            "id": 2,
            "invoice_id": 100,
            "amount": 333.33,
            "paid_amount": 0.00,
            "due_date": "2023-07-15",
            "status": "pending",
            "notes": "قسط تلقائي (قسط 2/3)",
            "created_at": "2023-05-15T10:00:00.000000Z",
            "updated_at": "2023-05-15T10:00:00.000000Z"
        },
        {
            "id": 3,
            "invoice_id": 100,
            "amount": 333.34,
            "paid_amount": 0.00,
            "due_date": "2023-08-15",
            "status": "pending",
            "notes": "قسط تلقائي (قسط 3/3)",
            "created_at": "2023-05-15T10:00:00.000000Z",
            "updated_at": "2023-05-15T10:00:00.000000Z"
        }
    ]
}
```

## أكواد الاستجابة

| الكود | الوصف |
|------|-------|
| 200 | تم تنفيذ الطلب بنجاح |
| 201 | تم إنشاء المورد بنجاح |
| 400 | طلب غير صالح |
| 401 | غير مصرح |
| 403 | ممنوع |
| 404 | المورد غير موجود |
| 422 | بيانات غير صالحة |
| 500 | خطأ في الخادم |

## أمثلة على الاستخدام

### مثال 1: الحصول على قائمة الأقساط المستحقة

```javascript
// باستخدام fetch API
fetch('https://example.com/api/installments?status=pending', {
    method: 'GET',
    headers: {
        'Authorization': 'Bearer YOUR_TOKEN',
        'Accept': 'application/json'
    }
})
.then(response => response.json())
.then(data => console.log(data))
.catch(error => console.error('Error:', error));
```

### مثال 2: تسجيل دفعة لقسط

```javascript
// باستخدام fetch API
fetch('https://example.com/api/installments/1/payments', {
    method: 'POST',
    headers: {
        'Authorization': 'Bearer YOUR_TOKEN',
        'Content-Type': 'application/json',
        'Accept': 'application/json'
    },
    body: JSON.stringify({
        amount: 300.00,
        payment_date: '2023-05-15',
        payment_method_id: 1,
        reference_number: 'REF123',
        notes: 'دفعة جزئية'
    })
})
.then(response => response.json())
.then(data => console.log(data))
.catch(error => console.error('Error:', error));
```

### مثال 3: إنشاء أقساط تلقائية للفاتورة

```javascript
// باستخدام fetch API
fetch('https://example.com/api/invoices/100/installments/auto-create', {
    method: 'POST',
    headers: {
        'Authorization': 'Bearer YOUR_TOKEN',
        'Content-Type': 'application/json',
        'Accept': 'application/json'
    },
    body: JSON.stringify({
        number_of_installments: 3,
        start_date: '2023-06-15',
        interval: 'month',
        notes: 'قسط تلقائي'
    })
})
.then(response => response.json())
.then(data => console.log(data))
.catch(error => console.error('Error:', error));
```