<?php

require_once __DIR__ . '/vendor/autoload.php';

use App\Models\Bank;
use App\Models\ChartOfAccount;
use App\Services\BankAccountService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

// تهيئة Laravel
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

echo "بدء تشخيص مشكلة إنشاء الحسابات البنكية...\n";

// تحديد الشركة التي نريد اختبارها
$companyId = 3; // يمكن تغييره حسب الحاجة

echo "اختبار إنشاء حساب بنكي للشركة رقم {$companyId}...\n";

// إنشاء كائن خدمة حسابات البنوك
$bankAccountService = new BankAccountService();

// التحقق من وجود حساب الأصول المتداولة
echo "التحقق من حساب الأصول المتداولة...\n";
try {
    $currentAssetsAccount = $bankAccountService->findOrCreateCurrentAssetsAccount($companyId);
    echo "  تم العثور على حساب الأصول المتداولة (ID: {$currentAssetsAccount->id}).\n";
} catch (\Exception $e) {
    echo "  خطأ في العثور على حساب الأصول المتداولة: " . $e->getMessage() . "\n";
    echo "  " . $e->getTraceAsString() . "\n";
    exit;
}

// التحقق من وجود حساب البنوك الرئيسي
echo "التحقق من حساب البنوك الرئيسي...\n";
try {
    $parentBankAccount = $bankAccountService->findOrCreateParentBankAccount($companyId, $currentAssetsAccount);
    echo "  تم العثور على حساب البنوك الرئيسي (ID: {$parentBankAccount->id}).\n";
} catch (\Exception $e) {
    echo "  خطأ في العثور على حساب البنوك الرئيسي: " . $e->getMessage() . "\n";
    echo "  " . $e->getTraceAsString() . "\n";
    exit;
}

// إنشاء بنك اختباري
echo "إنشاء بنك اختباري...\n";
$testBankName = "بنك اختباري " . rand(1000, 9999);

try {
    $bank = new Bank();
    $bank->company_id = $companyId;
    $bank->name = $testBankName;
    $bank->is_active = true;

    // محاولة إنشاء حساب للبنك
    echo "محاولة إنشاء حساب للبنك {$testBankName}...\n";
    $bankAccount = $bankAccountService->createBankAccount($bank);

    if ($bankAccount) {
        echo "  تم إنشاء حساب البنك بنجاح (ID: {$bankAccount->id}).\n";
        echo "  رمز الحساب: {$bankAccount->account_code}\n";
        echo "  الحساب الأب: {$bankAccount->parent_id}\n";
    } else {
        echo "  فشل في إنشاء حساب البنك! تحقق من سجلات الخطأ.\n";
    }
} catch (\Exception $e) {
    echo "  خطأ في إنشاء حساب البنك: " . $e->getMessage() . "\n";
    echo "  " . $e->getTraceAsString() . "\n";
}

// التحقق من سجلات الخطأ الأخيرة
echo "\nآخر سجلات الخطأ:\n";
$logs = DB::table('logs')
    ->where('level', 'error')
    ->orderBy('created_at', 'desc')
    ->limit(5)
    ->get();

if ($logs->count() > 0) {
    foreach ($logs as $log) {
        echo "  {$log->created_at}: {$log->message}\n";
        echo "  {$log->context}\n\n";
    }
} else {
    echo "  لا توجد سجلات خطأ حديثة.\n";
}

echo "تم الانتهاء من التشخيص.\n";
