<?php

/**
 * سكريبت لتشخيص حالة حسابات البنوك في النظام
 */

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';

use App\Models\ChartOfAccount;
use Illuminate\Support\Facades\DB;

// تهيئة التطبيق
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "بدء تشخيص حالة حسابات البنوك...\n\n";

// فحص قيود الفريد في جدول chart_of_accounts
echo "فحص قيود الفريد في جدول chart_of_accounts:\n";
$uniqueConstraints = DB::select("
    SELECT DISTINCT TABLE_NAME, CONSTRAINT_NAME, COLUMN_NAME
    FROM information_schema.KEY_COLUMN_USAGE
    WHERE TABLE_SCHEMA = DATABASE()
    AND TABLE_NAME = 'chart_of_accounts'
    AND CONSTRAINT_NAME LIKE '%unique%'
    ORDER BY CONSTRAINT_NAME, ORDINAL_POSITION
");

foreach ($uniqueConstraints as $constraint) {
    echo "- {$constraint->CONSTRAINT_NAME}: {$constraint->COLUMN_NAME}\n";
}

echo "\n";

// البحث عن حسابات البنك الرئيسية للشركة 3 (بما في ذلك المحذوفة)
echo "حسابات البنك الرئيسية للشركة 3:\n";
$bankAccounts = ChartOfAccount::withTrashed()
    ->where('company_id', 3)
    ->where('account_code', 'BANK')
    ->get();

if ($bankAccounts->count() > 0) {
    foreach ($bankAccounts as $account) {
        echo "- ID: {$account->id}, الاسم: {$account->name}, المستوى: {$account->level}, الحساب الأب: {$account->parent_id}, محذوف: " . ($account->trashed() ? 'نعم' : 'لا') . "\n";
    }
} else {
    echo "لا يوجد حسابات بنك رئيسية للشركة 3.\n";
}

echo "\n";

// البحث عن حسابات البنوك الفردية للشركة 3
echo "حسابات البنوك الفردية للشركة 3:\n";
$individualBankAccounts = ChartOfAccount::where('company_id', 3)
    ->where('is_bank_account', true)
    ->where('account_code', 'like', 'BANK-%')
    ->get();

if ($individualBankAccounts->count() > 0) {
    foreach ($individualBankAccounts as $account) {
        echo "- ID: {$account->id}, الاسم: {$account->name}, الرمز: {$account->account_code}, المستوى: {$account->level}, الحساب الأب: {$account->parent_id}\n";
    }
} else {
    echo "لا يوجد حسابات بنوك فردية للشركة 3.\n";
}

echo "\n";

// البحث عن حساب الأصول المتداولة للشركة 3
echo "حساب الأصول المتداولة للشركة 3:\n";
$currentAssetsAccount = ChartOfAccount::where('company_id', 3)
    ->where('account_code', '1100')
    ->first();

if ($currentAssetsAccount) {
    echo "- ID: {$currentAssetsAccount->id}, الاسم: {$currentAssetsAccount->name}, المستوى: {$currentAssetsAccount->level}, الحساب الأب: {$currentAssetsAccount->parent_id}\n";
} else {
    echo "لا يوجد حساب أصول متداولة للشركة 3.\n";
}

echo "\n";

// البحث عن حسابات متكررة بنفس الرمز للشركة 3
echo "حسابات متكررة بنفس الرمز للشركة 3:\n";
$duplicateAccounts = DB::select("
    SELECT account_code, COUNT(*) as count
    FROM chart_of_accounts
    WHERE company_id = 3
    GROUP BY account_code
    HAVING COUNT(*) > 1
");

if (count($duplicateAccounts) > 0) {
    foreach ($duplicateAccounts as $duplicate) {
        echo "- الرمز: {$duplicate->account_code}, العدد: {$duplicate->count}\n";

        $accounts = ChartOfAccount::withTrashed()
            ->where('company_id', 3)
            ->where('account_code', $duplicate->account_code)
            ->get();

        foreach ($accounts as $account) {
            echo "  * ID: {$account->id}, الاسم: {$account->name}, محذوف: " . ($account->trashed() ? 'نعم' : 'لا') . "\n";
        }
    }
} else {
    echo "لا يوجد حسابات متكررة بنفس الرمز للشركة 3.\n";
}

echo "\nتم الانتهاء من تشخيص حالة حسابات البنوك.\n";
