<?php

// تحميل الإطار
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

// محاكاة middleware
$userId = 3; // ID للمستخدم manager3
$user = App\Models\User::find($userId);
if (!$user) {
    echo "لم يتم العثور على المستخدم بالـ ID: $userId\n";
    exit;
}

echo "محاكاة middleware للمستخدم: " . $user->name . " (ID: " . $user->id . ")\n\n";

// محاكاة دالة userHasPermission في middleware
function userHasPermission($user, $permission)
{
    // إذا كان المستخدم مدير النظام، فلديه جميع الصلاحيات
    if ($user->is_admin) {
        echo "المستخدم مدير النظام، تم منح الصلاحية: $permission\n";
        return true;
    }

    echo "التحقق من الصلاحية: $permission للمستخدم: " . $user->email . " (ID: " . $user->id . ")\n";

    // التحقق من الصلاحية من خلال الأدوار
    foreach ($user->roles as $role) {
        echo "التحقق من الدور: " . $role->name . " (" . $role->slug . ")\n";
        foreach ($role->permissions as $perm) {
            echo "صلاحية الدور: " . $perm->slug . " (مقارنة مع: $permission)\n";
            if ($perm->slug === $permission) {
                echo "تم العثور على الصلاحية في الدور: " . $role->name . "\n";
                return true;
            }
        }
    }

    // التحقق من الصلاحية المباشرة
    if ($user->directPermissions) {
        echo "التحقق من الصلاحيات المباشرة، العدد: " . $user->directPermissions->count() . "\n";
        foreach ($user->directPermissions as $userPerm) {
            if ($userPerm->permission) {
                echo "صلاحية مباشرة: " . $userPerm->permission->slug . " (مقارنة مع: $permission), ممنوحة: " . ($userPerm->granted ? 'نعم' : 'لا') . "\n";
                if ($userPerm->permission->slug === $permission && $userPerm->granted) {
                    // التحقق من عدم انتهاء الصلاحية
                    if (!$userPerm->expires_at || $userPerm->expires_at > now()) {
                        echo "تم منح الصلاحية المباشرة: $permission\n";
                        return true;
                    } else {
                        echo "الصلاحية المباشرة منتهية: $permission, تنتهي في: " . $userPerm->expires_at . "\n";
                    }
                }
            } else {
                echo "سجل صلاحية المستخدم موجود ولكن الصلاحية فارغة للمستخدم: " . $user->id . "\n";
            }
        }
    } else {
        echo "المستخدم ليس لديه صلاحيات مباشرة\n";
    }

    // التحقق من صلاحية view_maintenance_notifications إذا كان المطلوب هو view_notifications
    if ($permission === 'view_notifications') {
        $hasMaintenanceNotifications = userHasPermission($user, 'view_maintenance_notifications');
        if ($hasMaintenanceNotifications) {
            echo "حالة خاصة: تم منح view_notifications عبر view_maintenance_notifications\n";
            return true;
        }
    }

    echo "لم يتم العثور على الصلاحية: $permission\n";
    return false;
}

// اختبار الصلاحيات
$permissionsToCheck = [
    'view_maintenance_notifications',
    'view_notifications'
];

foreach ($permissionsToCheck as $permission) {
    echo "\nاختبار الصلاحية: $permission\n";
    echo "النتيجة: " . (userHasPermission($user, $permission) ? 'تم منح الصلاحية' : 'تم رفض الصلاحية') . "\n";
    echo "-----------------------------------\n";
}

// التحقق من مسار الإشعارات
echo "\nالتحقق من مسار الإشعارات:\n";
$routeName = 'notifications.index';
$routes = app('router')->getRoutes();
$route = $routes->getByName($routeName);

if ($route) {
    echo "المسار: " . $routeName . "\n";
    echo "الـ URI: " . $route->uri() . "\n";
    echo "الـ Middleware: " . implode(', ', $route->middleware()) . "\n";

    // التحقق من الصلاحية المطلوبة
    $permissionMiddleware = null;
    foreach ($route->middleware() as $middleware) {
        if (strpos($middleware, 'permission:') === 0) {
            $permissionMiddleware = $middleware;
            break;
        }
    }

    if ($permissionMiddleware) {
        $requiredPermission = str_replace('permission:', '', $permissionMiddleware);
        echo "الصلاحية المطلوبة: " . $requiredPermission . "\n";
        echo "هل المستخدم لديه الصلاحية: " . (userHasPermission($user, $requiredPermission) ? 'نعم' : 'لا') . "\n";
    } else {
        echo "لا يوجد middleware للصلاحيات على هذا المسار\n";
    }
} else {
    echo "المسار غير موجود\n";
}

echo "\nتم الانتهاء من التحقق\n";
