<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Database\Seeder;

class ZatcaPermissionsSeeder extends Seeder
{
    /**
     * تشغيل عملية البذر.
     *
     * @return void
     */
    public function run()
    {
        // إنشاء مجموعة صلاحيات الفوترة الإلكترونية
        $this->createZatcaPermissions();

        // تعيين الصلاحيات للأدوار
        $this->assignPermissionsToRoles();
    }

    /**
     * إنشاء صلاحيات الفوترة الإلكترونية.
     *
     * @return void
     */
    private function createZatcaPermissions()
    {
        // إنشاء مجموعة صلاحيات الفوترة الإلكترونية
        $zatcaGroup = Permission::create([
            'name' => 'إدارة الفوترة الإلكترونية',
            'slug' => 'manage_zatca',
            'group' => 'zatca',
            'description' => 'إدارة كاملة للفوترة الإلكترونية (الزكاة والدخل)',
            'level' => 0,
            'path' => null,
            'type' => 'group',
            'resource' => 'zatca',
            'order' => 0,
            'is_active' => true,
        ]);

        // تحديث المسار بعد الإنشاء
        $zatcaGroup->path = $zatcaGroup->id;
        $zatcaGroup->save();

        // إنشاء الصلاحيات الفرعية
        $zatcaPermissions = [
            [
                'name' => 'عرض الفواتير الإلكترونية',
                'slug' => 'view_zatca_invoices',
                'description' => 'عرض الفواتير الإلكترونية',
            ],
            [
                'name' => 'إدارة الفواتير الإلكترونية',
                'slug' => 'manage_zatca_invoices',
                'description' => 'إدارة الفواتير الإلكترونية',
            ],
            [
                'name' => 'إرسال الفواتير إلى هيئة الزكاة',
                'slug' => 'report_zatca_invoices',
                'description' => 'إرسال الفواتير إلى هيئة الزكاة والدخل',
            ],
            [
                'name' => 'التحقق من حالة الفواتير',
                'slug' => 'check_zatca_invoice_status',
                'description' => 'التحقق من حالة الفواتير المرسلة إلى هيئة الزكاة والدخل',
            ],
            [
                'name' => 'توليد رموز QR للفواتير',
                'slug' => 'generate_zatca_qr_codes',
                'description' => 'توليد رموز QR للفواتير الإلكترونية',
            ],
            [
                'name' => 'توليد ملفات XML للفواتير',
                'slug' => 'generate_zatca_xml_files',
                'description' => 'توليد ملفات XML للفواتير الإلكترونية',
            ],
        ];

        $order = 1;
        foreach ($zatcaPermissions as $permissionData) {
            $permission = Permission::create([
                'parent_id' => $zatcaGroup->id,
                'name' => $permissionData['name'],
                'slug' => $permissionData['slug'],
                'group' => 'zatca',
                'description' => $permissionData['description'],
                'level' => 1,
                'path' => null,
                'type' => 'action',
                'resource' => 'zatca',
                'order' => $order++,
                'is_active' => true,
            ]);

            // تحديث المسار بعد الإنشاء
            $permission->path = $zatcaGroup->path . '.' . $permission->id;
            $permission->save();
        }
    }

    /**
     * تعيين الصلاحيات للأدوار.
     *
     * @return void
     */
    private function assignPermissionsToRoles()
    {
        // الحصول على الأدوار
        $adminRole = Role::where('slug', 'admin')->first();
        $accountantRole = Role::where('slug', 'accountant')->first();

        // تعيين جميع صلاحيات الفوترة الإلكترونية لدور المدير
        if ($adminRole) {
            $zatcaPermissions = Permission::where('group', 'zatca')->get();
            $adminRole->permissions()->syncWithoutDetaching($zatcaPermissions->pluck('id')->toArray());
        }

        // تعيين صلاحيات محددة لدور المحاسب
        if ($accountantRole) {
            $accountantZatcaPermissions = Permission::whereIn('slug', [
                'view_zatca_invoices',
                'manage_zatca_invoices',
                'report_zatca_invoices',
                'check_zatca_invoice_status',
                'generate_zatca_qr_codes',
                'generate_zatca_xml_files',
            ])->get();
            $accountantRole->permissions()->syncWithoutDetaching($accountantZatcaPermissions->pluck('id')->toArray());
        }
    }
}
