<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;
use App\Models\Role;
use Illuminate\Support\Facades\DB;

class WorkOrderPermissionsSeeder extends Seeder
{
    /**
     * تشغيل بذور قاعدة البيانات.
     *
     * @return void
     */
    public function run()
    {
        // إنشاء صلاحيات أوامر الشغل
        $permissions = [
            'view_work_orders' => [
                'name' => 'عرض أوامر الشغل',
                'description' => 'عرض قائمة أوامر الشغل وتفاصيلها',
                'group' => 'work_orders',
                'type' => 'view'
            ],
            'create_work_orders' => [
                'name' => 'إنشاء أوامر الشغل',
                'description' => 'إنشاء أوامر شغل جديدة',
                'group' => 'work_orders',
                'type' => 'create'
            ],
            'edit_work_orders' => [
                'name' => 'تعديل أوامر الشغل',
                'description' => 'تعديل أوامر الشغل الموجودة',
                'group' => 'work_orders',
                'type' => 'edit'
            ],
            'delete_work_orders' => [
                'name' => 'حذف أوامر الشغل',
                'description' => 'حذف أوامر الشغل',
                'group' => 'work_orders',
                'type' => 'delete'
            ],
            'manage_work_orders' => [
                'name' => 'إدارة أوامر الشغل',
                'description' => 'إدارة كاملة لأوامر الشغل',
                'group' => 'work_orders',
                'type' => 'manage'
            ],
        ];

        foreach ($permissions as $slug => $details) {
            $permission = Permission::where('slug', $slug)->first();

            if (!$permission) {
                $permission = new Permission();
                $permission->slug = $slug;
                $permission->name = $details['name'];
                $permission->description = $details['description'];
                $permission->group = $details['group'];
                $permission->type = $details['type'];
                $permission->level = 0;
                $permission->order = 0;
                $permission->is_active = true;
                $permission->save();

                // تحديث المسار والمستوى
                $permission->updatePath();
                $permission->updateLevel();
            }
        }

        // إضافة الصلاحيات للأدوار
        $adminRole = Role::where('slug', 'admin')->first();
        $managerRole = Role::where('slug', 'manager')->first();
        $technicianRole = Role::where('slug', 'technician')->first();
        $maintenanceTechnicianRole = Role::where('slug', 'maintenance_technician')->first();

        // الصلاحيات للمدير
        if ($adminRole) {
            foreach ($permissions as $slug => $details) {
                $permission = Permission::where('slug', $slug)->first();
                if ($permission) {
                    // التحقق من عدم وجود العلاقة مسبقاً
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permission->id)
                        ->where('role_id', $adminRole->id)
                        ->exists();

                    if (!$exists) {
                        DB::table('permission_role')->insert([
                            'permission_id' => $permission->id,
                            'role_id' => $adminRole->id,
                            'created_at' => now(),
                            'updated_at' => now()
                        ]);
                    }
                }
            }
        }

        // الصلاحيات للمدير
        if ($managerRole) {
            $managerPermissions = [
                'view_work_orders',
                'create_work_orders',
                'edit_work_orders',
                'manage_work_orders'
            ];

            foreach ($managerPermissions as $slug) {
                $permission = Permission::where('slug', $slug)->first();
                if ($permission) {
                    // التحقق من عدم وجود العلاقة مسبقاً
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permission->id)
                        ->where('role_id', $managerRole->id)
                        ->exists();

                    if (!$exists) {
                        DB::table('permission_role')->insert([
                            'permission_id' => $permission->id,
                            'role_id' => $managerRole->id,
                            'created_at' => now(),
                            'updated_at' => now()
                        ]);
                    }
                }
            }
        }

        // الصلاحيات للفني
        if ($technicianRole) {
            $technicianPermissions = [
                'view_work_orders'
            ];

            foreach ($technicianPermissions as $slug) {
                $permission = Permission::where('slug', $slug)->first();
                if ($permission) {
                    // التحقق من عدم وجود العلاقة مسبقاً
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permission->id)
                        ->where('role_id', $technicianRole->id)
                        ->exists();

                    if (!$exists) {
                        DB::table('permission_role')->insert([
                            'permission_id' => $permission->id,
                            'role_id' => $technicianRole->id,
                            'created_at' => now(),
                            'updated_at' => now()
                        ]);
                    }
                }
            }
        }

        // الصلاحيات لفني الصيانة
        if ($maintenanceTechnicianRole) {
            $maintenanceTechnicianPermissions = [
                'view_work_orders'
            ];

            foreach ($maintenanceTechnicianPermissions as $slug) {
                $permission = Permission::where('slug', $slug)->first();
                if ($permission) {
                    // التحقق من عدم وجود العلاقة مسبقاً
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permission->id)
                        ->where('role_id', $maintenanceTechnicianRole->id)
                        ->exists();

                    if (!$exists) {
                        DB::table('permission_role')->insert([
                            'permission_id' => $permission->id,
                            'role_id' => $maintenanceTechnicianRole->id,
                            'created_at' => now(),
                            'updated_at' => now()
                        ]);
                    }
                }
            }
        }
    }
}
