<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class WarehouseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // تعطيل فحص المفاتيح الأجنبية مؤقتًا
        DB::statement('SET FOREIGN_KEY_CHECKS=0');

        // حذف البيانات الموجودة
        DB::table('warehouses')->truncate();

        // إضافة البيانات
        $data = [
            [
                'id' => 1,
                'company_id' => 1,
                'branch_id' => 1,
                'name' => 'مستودع رقم 1',
                'code' => 1,
                'address' => null,
                'manager_name' => null,
                'phone' => null,
                'email' => null,
                'is_active' => 1,
                'notes' => null,
                'created_at' => '2025-09-04 22:38:17',
                'updated_at' => '2025-09-04 22:38:17',
            ],
        ];

        DB::table('warehouses')->insert($data);

        // إعادة تفعيل فحص المفاتيح الأجنبية
        DB::statement('SET FOREIGN_KEY_CHECKS=1');
    }
}
