<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // تعطيل فحص المفاتيح الأجنبية مؤقتًا
        DB::statement('SET FOREIGN_KEY_CHECKS=0');

        // حذف البيانات الموجودة
        DB::table('users')->truncate();

        // إضافة البيانات
        $data = [
            [
                'id' => 1,
                'company_id' => null,
                'branch_id' => null,
                'name' => 'مستخدم تجريبي',
                'email' => 'demo@elevators.com',
                'phone' => null,
                'job_title' => null,
                'email_verified_at' => null,
                'password' => '$2y$10$Jw8OR3YhSXOYASMdLzjlZOkvIBuC/uRV0FVLs1tl8F.qezBp9YNg2',
                'two_factor_secret' => null,
                'two_factor_recovery_codes' => null,
                'two_factor_confirmed_at' => null,
                'two_factor_enabled' => 0,
                'remember_token' => null,
                'is_active' => 1,
                'created_at' => '2025-09-03 08:40:05',
                'updated_at' => '2025-09-03 18:53:53',
                'deleted_at' => null,
                'position' => null,
                'last_login_at' => null,
            ],
            [
                'id' => 2,
                'company_id' => null,
                'branch_id' => null,
                'name' => 'eerr',
                'email' => 'www2@ddd.com',
                'phone' => null,
                'job_title' => 1,
                'email_verified_at' => null,
                'password' => '$2y$10$.qrZglfelb/czJ.ozDf9d.Ce4H4RbnzC6580DpRxCeoLc2GxuOkby',
                'two_factor_secret' => null,
                'two_factor_recovery_codes' => null,
                'two_factor_confirmed_at' => null,
                'two_factor_enabled' => 0,
                'remember_token' => null,
                'is_active' => 0,
                'created_at' => '2025-09-03 17:33:40',
                'updated_at' => '2025-09-03 17:33:40',
                'deleted_at' => null,
                'position' => null,
                'last_login_at' => null,
            ],
            [
                'id' => 3,
                'company_id' => null,
                'branch_id' => null,
                'name' => 'eerr',
                'email' => 'www2q@ddd.com',
                'phone' => null,
                'job_title' => 1,
                'email_verified_at' => null,
                'password' => '$2y$10$Ko7GVtOQWV4fAAJhzvXPPO9UDGIaaO8nnnl6M/l/NAedeMi2jkqbm',
                'two_factor_secret' => null,
                'two_factor_recovery_codes' => null,
                'two_factor_confirmed_at' => null,
                'two_factor_enabled' => 0,
                'remember_token' => null,
                'is_active' => 1,
                'created_at' => '2025-09-03 17:45:47',
                'updated_at' => '2025-09-03 17:45:47',
                'deleted_at' => null,
                'position' => null,
                'last_login_at' => null,
            ],
            [
                'id' => 4,
                'company_id' => 1,
                'branch_id' => 1,
                'name' => 'مدير شركة',
                'email' => 'manager@manager.com',
                'phone' => null,
                'job_title' => null,
                'email_verified_at' => null,
                'password' => '$2y$10$ewvopTNHARhBwxym1Sfey.JBC7oF5lSRS8w/TfG21RW5xn6W02DHq',
                'two_factor_secret' => null,
                'two_factor_recovery_codes' => null,
                'two_factor_confirmed_at' => null,
                'two_factor_enabled' => 0,
                'remember_token' => 'uP4LATyydk1g04eQ4zCeGOW7TI5i8YB47hPEIIwcY0fjD3hDkLfGzds0TisZ',
                'is_active' => 1,
                'created_at' => '2025-09-04 04:45:44',
                'updated_at' => '2025-09-04 04:45:44',
                'deleted_at' => null,
                'position' => null,
                'last_login_at' => null,
            ],
            [
                'id' => 5,
                'company_id' => null,
                'branch_id' => null,
                'name' => 'مدير الشركة الحديث',
                'email' => 'manager2@manager2.com',
                'phone' => null,
                'job_title' => null,
                'email_verified_at' => null,
                'password' => '$2y$10$EdjyaMwRdwznBTu19GsZDelUOU9Wdd/l8q8fBODhpiO7FPzojnlIy',
                'two_factor_secret' => null,
                'two_factor_recovery_codes' => null,
                'two_factor_confirmed_at' => null,
                'two_factor_enabled' => 0,
                'remember_token' => null,
                'is_active' => 1,
                'created_at' => '2025-09-04 15:02:14',
                'updated_at' => '2025-09-04 15:02:14',
                'deleted_at' => null,
                'position' => null,
                'last_login_at' => null,
            ],
            [
                'id' => 6,
                'company_id' => 1,
                'branch_id' => 1,
                'name' => 'manager3',
                'email' => 'manager3@manager3.com',
                'phone' => null,
                'job_title' => null,
                'email_verified_at' => null,
                'password' => '$2y$10$opMzCVdGAYxKWqKch3j4EOn6RHFquc0bSHHCuxvHRcwOSunBoLjga',
                'two_factor_secret' => null,
                'two_factor_recovery_codes' => null,
                'two_factor_confirmed_at' => null,
                'two_factor_enabled' => 0,
                'remember_token' => 'HW5ek3CA1ldeKwSo7fVGRvkCR2STXBgFlZd3IWJHj1L2eCPQlfP5e47qaLbw',
                'is_active' => 1,
                'created_at' => '2025-09-04 15:43:21',
                'updated_at' => '2025-09-04 15:43:21',
                'deleted_at' => null,
                'position' => null,
                'last_login_at' => null,
            ],
        ];

        DB::table('users')->insert($data);

        // إعادة تفعيل فحص المفاتيح الأجنبية
        DB::statement('SET FOREIGN_KEY_CHECKS=1');
    }
}
