<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class UserPermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // تعطيل فحص المفاتيح الأجنبية مؤقتًا
        DB::statement('SET FOREIGN_KEY_CHECKS=0');

        // حذف البيانات الموجودة
        DB::table('user_permission')->truncate();

        // إضافة البيانات
        $data = [
            [
                'id' => 1,
                'user_id' => 1,
                'permission_id' => 76,
                'granted' => 1,
                'source' => 'direct',
                'expires_at' => null,
                'created_at' => '2025-09-03 09:40:49',
                'updated_at' => '2025-09-03 09:40:49',
                'deleted_at' => null,
            ],
            [
                'id' => 2,
                'user_id' => 3,
                'permission_id' => 345,
                'granted' => 1,
                'source' => 'direct',
                'expires_at' => null,
                'created_at' => '2025-09-07 04:58:39',
                'updated_at' => '2025-09-07 04:58:39',
                'deleted_at' => null,
            ],
            [
                'id' => 3,
                'user_id' => 3,
                'permission_id' => 359,
                'granted' => 1,
                'source' => 'direct',
                'expires_at' => null,
                'created_at' => '2025-09-07 04:58:40',
                'updated_at' => '2025-09-07 04:58:40',
                'deleted_at' => null,
            ],
            [
                'id' => 4,
                'user_id' => 3,
                'permission_id' => 347,
                'granted' => 1,
                'source' => 'direct',
                'expires_at' => null,
                'created_at' => '2025-09-07 04:58:41',
                'updated_at' => '2025-09-07 04:58:41',
                'deleted_at' => null,
            ],
            [
                'id' => 5,
                'user_id' => 3,
                'permission_id' => 348,
                'granted' => 1,
                'source' => 'direct',
                'expires_at' => null,
                'created_at' => '2025-09-07 04:58:41',
                'updated_at' => '2025-09-07 04:58:41',
                'deleted_at' => null,
            ],
            [
                'id' => 6,
                'user_id' => 3,
                'permission_id' => 344,
                'granted' => 1,
                'source' => 'direct',
                'expires_at' => null,
                'created_at' => '2025-09-07 04:58:41',
                'updated_at' => '2025-09-07 04:58:41',
                'deleted_at' => null,
            ],
            [
                'id' => 7,
                'user_id' => 3,
                'permission_id' => 385,
                'granted' => 1,
                'source' => 'direct',
                'expires_at' => null,
                'created_at' => '2025-09-07 04:58:41',
                'updated_at' => '2025-09-07 04:58:41',
                'deleted_at' => null,
            ],
            [
                'id' => 8,
                'user_id' => 3,
                'permission_id' => 386,
                'granted' => 1,
                'source' => 'direct',
                'expires_at' => null,
                'created_at' => '2025-09-07 04:58:42',
                'updated_at' => '2025-09-07 04:58:42',
                'deleted_at' => null,
            ],
            [
                'id' => 9,
                'user_id' => 3,
                'permission_id' => 388,
                'granted' => 1,
                'source' => 'direct',
                'expires_at' => null,
                'created_at' => '2025-09-07 04:58:42',
                'updated_at' => '2025-09-07 04:58:42',
                'deleted_at' => null,
            ],
            [
                'id' => 10,
                'user_id' => 3,
                'permission_id' => 387,
                'granted' => 1,
                'source' => 'direct',
                'expires_at' => null,
                'created_at' => '2025-09-07 04:58:42',
                'updated_at' => '2025-09-07 04:58:42',
                'deleted_at' => null,
            ],
            [
                'id' => 11,
                'user_id' => 3,
                'permission_id' => 389,
                'granted' => 1,
                'source' => 'direct',
                'expires_at' => null,
                'created_at' => '2025-09-07 04:58:42',
                'updated_at' => '2025-09-07 04:58:42',
                'deleted_at' => null,
            ],
        ];

        DB::table('user_permission')->insert($data);

        // إعادة تفعيل فحص المفاتيح الأجنبية
        DB::statement('SET FOREIGN_KEY_CHECKS=1');
    }
}
