<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Role;
use App\Models\Permission;
use Illuminate\Support\Facades\DB;

class UpdateRolesWithProjectInventoryPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // الحصول على الأدوار
        $superAdmin = Role::where('name', 'super_admin')->first();
        $admin = Role::where('name', 'admin')->first();
        $projectManager = Role::where('name', 'project_manager')->first();
        $inventoryManager = Role::where('name', 'inventory_manager')->first();
        $projectEngineer = Role::where('name', 'project_engineer')->first();
        $warehouseKeeper = Role::where('name', 'warehouse_keeper')->first();

        // الحصول على صلاحيات طلبات المخزون للمشاريع
        $projectInventoryPermissions = Permission::where('name', 'like', '%project_inventory%')->get();

        // إضافة جميع الصلاحيات للسوبر أدمن
        if ($superAdmin) {
            foreach ($projectInventoryPermissions as $permission) {
                DB::table('role_permission')->updateOrInsert(
                    ['role_id' => $superAdmin->id, 'permission_id' => $permission->id],
                    ['created_at' => now(), 'updated_at' => now()]
                );
            }
        }

        // إضافة جميع الصلاحيات للأدمن
        if ($admin) {
            foreach ($projectInventoryPermissions as $permission) {
                DB::table('role_permission')->updateOrInsert(
                    ['role_id' => $admin->id, 'permission_id' => $permission->id],
                    ['created_at' => now(), 'updated_at' => now()]
                );
            }
        }

        // إضافة صلاحيات لمدير المشروع
        if ($projectManager) {
            $projectManagerPermissions = [
                'view_project_inventory_requests',
                'create_project_inventory_requests',
                'edit_project_inventory_requests',
                'delete_project_inventory_requests',
                'approve_project_inventory_requests',
                'reject_project_inventory_requests',
                'view_project_inventory_reports'
            ];

            foreach ($projectInventoryPermissions as $permission) {
                if (in_array($permission->name, $projectManagerPermissions)) {
                    DB::table('role_permission')->updateOrInsert(
                        ['role_id' => $projectManager->id, 'permission_id' => $permission->id],
                        ['created_at' => now(), 'updated_at' => now()]
                    );
                }
            }
        }

        // إضافة صلاحيات لمدير المخزون
        if ($inventoryManager) {
            $inventoryManagerPermissions = [
                'view_project_inventory_requests',
                'approve_project_inventory_requests',
                'reject_project_inventory_requests',
                'fulfill_project_inventory_requests',
                'view_project_inventory_reports'
            ];

            foreach ($projectInventoryPermissions as $permission) {
                if (in_array($permission->name, $inventoryManagerPermissions)) {
                    DB::table('role_permission')->updateOrInsert(
                        ['role_id' => $inventoryManager->id, 'permission_id' => $permission->id],
                        ['created_at' => now(), 'updated_at' => now()]
                    );
                }
            }
        }

        // إضافة صلاحيات لمهندس المشروع
        if ($projectEngineer) {
            $projectEngineerPermissions = [
                'view_project_inventory_requests',
                'create_project_inventory_requests',
                'edit_project_inventory_requests',
                'view_project_inventory_reports'
            ];

            foreach ($projectInventoryPermissions as $permission) {
                if (in_array($permission->name, $projectEngineerPermissions)) {
                    DB::table('role_permission')->updateOrInsert(
                        ['role_id' => $projectEngineer->id, 'permission_id' => $permission->id],
                        ['created_at' => now(), 'updated_at' => now()]
                    );
                }
            }
        }

        // إضافة صلاحيات لأمين المستودع
        if ($warehouseKeeper) {
            $warehouseKeeperPermissions = [
                'view_project_inventory_requests',
                'fulfill_project_inventory_requests',
                'view_project_inventory_reports'
            ];

            foreach ($projectInventoryPermissions as $permission) {
                if (in_array($permission->name, $warehouseKeeperPermissions)) {
                    DB::table('role_permission')->updateOrInsert(
                        ['role_id' => $warehouseKeeper->id, 'permission_id' => $permission->id],
                        ['created_at' => now(), 'updated_at' => now()]
                    );
                }
            }
        }
    }
}
