<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Database\Seeder;

class UpdateRolesWithInventoryPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // إنشاء الأدوار الجديدة لنظام المخزون
        $this->createInventoryRoles();

        // تحديث الأدوار الموجودة بصلاحيات المخزون
        $this->updateExistingRolesWithInventoryPermissions();
    }

    /**
     * إنشاء الأدوار الجديدة لنظام المخزون.
     *
     * @return void
     */
    private function createInventoryRoles()
    {
        // إنشاء دور مدير المخزون
        $inventoryManagerRole = Role::firstOrCreate(
            ['slug' => 'inventory_manager'],
            [
                'name' => 'مدير المخزون',
                'description' => 'مدير المخزون مع صلاحيات كاملة لإدارة المخزون',
                'is_system_role' => true,
                'level' => 0,
                'path' => '6',
                'order' => 6,
                'is_active' => true,
                'is_default' => false,
            ]
        );

        // إنشاء دور أمين المستودع
        $warehouseKeeperRole = Role::firstOrCreate(
            ['slug' => 'warehouse_keeper'],
            [
                'name' => 'أمين مستودع',
                'description' => 'أمين مستودع مع صلاحيات محددة لإدارة المستودع',
                'is_system_role' => true,
                'level' => 0,
                'path' => '7',
                'order' => 7,
                'is_active' => true,
                'is_default' => false,
            ]
        );

        // إنشاء دور مسؤول المشتريات
        $purchasingOfficerRole = Role::firstOrCreate(
            ['slug' => 'purchasing_officer'],
            [
                'name' => 'مسؤول المشتريات',
                'description' => 'مسؤول المشتريات مع صلاحيات إدارة أوامر الشراء والموردين',
                'is_system_role' => true,
                'level' => 0,
                'path' => '8',
                'order' => 8,
                'is_active' => true,
                'is_default' => false,
            ]
        );

        // تعيين صلاحيات المخزون لدور مدير المخزون
        if ($inventoryManagerRole) {
            $inventoryPermissions = Permission::where('group', 'المخزون')->get();
            $inventoryManagerRole->permissions()->sync($inventoryPermissions->pluck('id')->toArray());
        }

        // تعيين صلاحيات محددة لدور أمين المستودع
        if ($warehouseKeeperRole) {
            $warehouseKeeperPermissions = Permission::whereIn('name', [
                'عرض المستودعات',
                'عرض عناصر المخزون',
                'عرض تصنيفات المخزون',
                'عرض الموردين',
                'عرض المخزون',
                'تعديل المخزون',
                'نقل المخزون',
                'عرض أوامر الشراء',
                'استلام أمر شراء',
                'عرض حركات المخزون',
                'عرض دفعات المخزون',
                'عرض أرقام تسلسلية',
                'عرض تقارير المخزون',
            ])->get();
            $warehouseKeeperRole->permissions()->sync($warehouseKeeperPermissions->pluck('id')->toArray());
        }

        // تعيين صلاحيات محددة لدور مسؤول المشتريات
        if ($purchasingOfficerRole) {
            $purchasingOfficerPermissions = Permission::whereIn('name', [
                'عرض المستودعات',
                'عرض عناصر المخزون',
                'عرض تصنيفات المخزون',
                'عرض الموردين',
                'إنشاء مورد',
                'تعديل مورد',
                'عرض تقييمات الموردين',
                'إنشاء تقييم مورد',
                'تعديل تقييم مورد',
                'عرض المخزون',
                'عرض أوامر الشراء',
                'إنشاء أمر شراء',
                'تعديل أمر شراء',
                'إلغاء أمر شراء',
                'عرض حركات المخزون',
                'عرض تقارير المخزون',
            ])->get();
            $purchasingOfficerRole->permissions()->sync($purchasingOfficerPermissions->pluck('id')->toArray());
        }
    }

    /**
     * تحديث الأدوار الموجودة بصلاحيات المخزون.
     *
     * @return void
     */
    private function updateExistingRolesWithInventoryPermissions()
    {
        // الحصول على الأدوار
        $adminRole = Role::where('slug', 'admin')->first();
        $branchManagerRole = Role::where('slug', 'branch_manager')->first();
        $accountantRole = Role::where('slug', 'accountant')->first();

        // تعيين جميع صلاحيات المخزون لدور المدير
        if ($adminRole) {
            $inventoryPermissions = Permission::where('group', 'المخزون')->get();
            $adminRole->permissions()->syncWithoutDetaching($inventoryPermissions->pluck('id')->toArray());
        }

        // تعيين صلاحيات محددة لدور مدير الفرع
        if ($branchManagerRole) {
            $branchManagerPermissions = Permission::whereIn('name', [
                'عرض المستودعات',
                'عرض عناصر المخزون',
                'عرض تصنيفات المخزون',
                'عرض الموردين',
                'عرض المخزون',
                'عرض أوامر الشراء',
                'اعتماد أمر شراء',
                'عرض حركات المخزون',
                'عرض تقارير المخزون',
            ])->get();
            $branchManagerRole->permissions()->syncWithoutDetaching($branchManagerPermissions->pluck('id')->toArray());
        }

        // تعيين صلاحيات محددة لدور المحاسب
        if ($accountantRole) {
            $accountantPermissions = Permission::whereIn('name', [
                'عرض المستودعات',
                'عرض عناصر المخزون',
                'عرض تصنيفات المخزون',
                'عرض الموردين',
                'عرض المخزون',
                'عرض أوامر الشراء',
                'عرض حركات المخزون',
                'عرض تقارير المخزون',
            ])->get();
            $accountantRole->permissions()->syncWithoutDetaching($accountantPermissions->pluck('id')->toArray());
        }
    }
}
