<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Database\Seeder;

class UpdateRolesWithHrmPermissionsSeeder extends Seeder
{
    /**
     * تنفيذ عملية البذر.
     *
     * @return void
     */
    public function run()
    {
        // إنشاء دور مدير الموارد البشرية
        $hrmManagerRole = Role::firstOrCreate(
            ['slug' => 'hrm_manager'],
            [
                'name' => 'مدير الموارد البشرية',
                'description' => 'لديه كافة صلاحيات إدارة الموارد البشرية',
                'is_active' => true,
                'is_system_role' => true,
                'is_default' => false,
                'order' => 4,
            ]
        );

        // إنشاء دور موظف الموارد البشرية
        $hrmStaffRole = Role::firstOrCreate(
            ['slug' => 'hrm_staff'],
            [
                'name' => 'موظف الموارد البشرية',
                'description' => 'لديه صلاحيات محددة في إدارة الموارد البشرية',
                'is_active' => true,
                'is_system_role' => true,
                'is_default' => false,
                'order' => 5,
            ]
        );

        // إنشاء دور محاسب الرواتب
        $payrollAccountantRole = Role::firstOrCreate(
            ['slug' => 'payroll_accountant'],
            [
                'name' => 'محاسب الرواتب',
                'description' => 'مسؤول عن إدارة كشوف الرواتب والمدفوعات',
                'is_active' => true,
                'is_system_role' => true,
                'is_default' => false,
                'order' => 6,
            ]
        );

        // الحصول على صلاحيات الموارد البشرية
        $hrmPermissions = Permission::where(function ($query) {
            $query->where('slug', 'like', '%employee%')
                ->orWhere('slug', 'like', '%department%')
                ->orWhere('slug', 'like', '%attendance%')
                ->orWhere('slug', 'like', '%leave%')
                ->orWhere('slug', 'like', '%salary%')
                ->orWhere('slug', 'like', '%payroll%')
                ->orWhere('slug', 'like', '%bonus%')
                ->orWhere('slug', 'like', '%loan%');
        })->get();

        // منح جميع صلاحيات الموارد البشرية لمدير الموارد البشرية
        $hrmManagerPermissionIds = $hrmPermissions->pluck('id')->filter()->toArray();
        $hrmManagerRole->syncPermissions($hrmManagerPermissionIds);

        // صلاحيات موظف الموارد البشرية (بدون صلاحيات الحذف والإدارة)
        $hrmStaffPermissions = Permission::where(function ($query) {
            $query->where('slug', 'like', 'view_%')
                ->orWhere('slug', 'like', 'create_%')
                ->orWhere('slug', 'like', 'edit_%');
        })->where(function ($query) {
            $query->where('slug', 'like', '%employee%')
                ->orWhere('slug', 'like', '%department%')
                ->orWhere('slug', 'like', '%attendance%')
                ->orWhere('slug', 'like', '%leave%');
        })->get();

        $hrmStaffPermissionIds = $hrmStaffPermissions->pluck('id')->filter()->toArray();
        $hrmStaffRole->syncPermissions($hrmStaffPermissionIds);

        // صلاحيات محاسب الرواتب
        $payrollPermissions = Permission::where(function ($query) {
            $query->where('slug', 'like', '%payroll%')
                ->orWhere('slug', 'like', '%salary%')
                ->orWhere('slug', 'like', '%bonus%')
                ->orWhere('slug', 'like', '%loan%');
        })->get();

        $payrollPermissionIds = $payrollPermissions->pluck('id')->filter()->toArray();
        $payrollAccountantRole->syncPermissions($payrollPermissionIds);
    }
}
