<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Database\Seeder;

class UpdateRolesWithCrmPermissionsSeeder extends Seeder
{
    /**
     * تنفيذ عملية البذر.
     *
     * @return void
     */
    public function run()
    {
        // الحصول على الأدوار
        $superAdminRole = Role::where('slug', 'super_admin')->first();
        $adminRole = Role::where('slug', 'admin')->first();
        $userRole = Role::where('slug', 'user')->first();

        if (!$superAdminRole || !$adminRole) {
            $this->command->info('الأدوار غير موجودة. يرجى تشغيل RoleSeeder أولاً.');
            return;
        }

        // الحصول على جميع الصلاحيات
        $allPermissions = Permission::all();
        $permissionIds = $allPermissions->pluck('id')->filter()->toArray();

        // منح جميع الصلاحيات للسوبر أدمن
        $superAdminRole->syncPermissions($permissionIds);

        // منح صلاحيات CRM للمدير
        $crmPermissions = Permission::where(function ($query) {
            $query->where('group', 'customer_interaction')
                ->orWhere('group', 'opportunity')
                ->orWhere('group', 'loyalty_point')
                ->orWhere('group', 'customer_reward')
                ->orWhere('group', 'reward_redemption');
        })->get();

        // الحصول على الصلاحيات الحالية للمدير
        $currentAdminPermissions = $adminRole->permissions()->pluck('permissions.id')->toArray();

        // إضافة صلاحيات CRM إلى صلاحيات المدير الحالية
        $newAdminPermissions = array_merge(
            $currentAdminPermissions,
            $crmPermissions->pluck('id')->filter()->toArray()
        );

        // تحديث صلاحيات المدير
        $adminRole->syncPermissions($newAdminPermissions);

        // منح بعض صلاحيات CRM للمستخدم العادي (فقط العرض)
        if ($userRole) {
            $userCrmPermissions = Permission::where(function ($query) {
                $query->where('slug', 'view_customer_interaction')
                    ->orWhere('slug', 'view_opportunity')
                    ->orWhere('slug', 'view_loyalty_point')
                    ->orWhere('slug', 'view_customer_reward')
                    ->orWhere('slug', 'view_reward_redemption');
            })->get();

            // الحصول على الصلاحيات الحالية للمستخدم
            $currentUserPermissions = $userRole->permissions()->pluck('permissions.id')->toArray();

            // إضافة صلاحيات CRM إلى صلاحيات المستخدم الحالية
            $newUserPermissions = array_merge(
                $currentUserPermissions,
                $userCrmPermissions->pluck('id')->filter()->toArray()
            );

            // تحديث صلاحيات المستخدم
            $userRole->syncPermissions($newUserPermissions);
        }

        $this->command->info('تم تحديث الأدوار بصلاحيات CRM بنجاح.');
    }
}
