<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class UpdatePurchaseInvoicesCompanyIdSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // تحديث فواتير المشتريات بناءً على company_id للمورد المرتبط
        \DB::statement('
            UPDATE purchase_invoices pi
            JOIN suppliers s ON pi.supplier_id = s.id
            SET pi.company_id = s.company_id
            WHERE pi.company_id IS NULL
        ');

        // تحديث فواتير المشتريات بناءً على company_id لأمر الشراء المرتبط (إذا كان المورد غير موجود)
        \DB::statement('
            UPDATE purchase_invoices pi
            JOIN purchase_orders po ON pi.purchase_order_id = po.id
            SET pi.company_id = po.company_id
            WHERE pi.company_id IS NULL AND pi.purchase_order_id IS NOT NULL
        ');

        // تحديث فواتير المشتريات بناءً على company_id للمستودع المرتبط (إذا كان المورد وأمر الشراء غير موجودين)
        \DB::statement('
            UPDATE purchase_invoices pi
            JOIN warehouses w ON pi.warehouse_id = w.id
            SET pi.company_id = w.company_id
            WHERE pi.company_id IS NULL
        ');

        // تعيين company_id = 1 لأي فواتير متبقية بدون company_id
        \DB::statement('
            UPDATE purchase_invoices
            SET company_id = 1
            WHERE company_id IS NULL
        ');
    }
}
