<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;

class UpdateInstallationProjectPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // تحديث مجموعة صلاحيات المشاريع
        $projectPermissions = [
            'view_installation_projects',
            'create_installation_project',
            'edit_installation_project',
            'delete_installation_project',
            'manage_installation_projects',
            'view_project_elevators',
            'add_project_elevator',
            'edit_project_elevator',
            'delete_project_elevator',
            'view_project_phases',
            'add_project_phase',
            'edit_project_phase',
            'delete_project_phase',
            'view_project_tasks',
            'add_project_task',
            'edit_project_task',
            'delete_project_task',
            'assign_project_task',
            'view_project_team',
            'add_project_team_member',
            'edit_project_team_member',
            'delete_project_team_member',
            'view_project_documents',
            'add_project_document',
            'edit_project_document',
            'delete_project_document',
            'view_project_expenses',
            'add_project_expense',
            'edit_project_expense',
            'delete_project_expense',
            'approve_project_expense',
            'view_project_payments',
            'add_project_payment',
            'edit_project_payment',
            'delete_project_payment',
            'view_project_issues',
            'add_project_issue',
            'edit_project_issue',
            'delete_project_issue',
            'resolve_project_issue',
            'view_project_milestones',
            'add_project_milestone',
            'edit_project_milestone',
            'delete_project_milestone',
            'complete_project_milestone',
            'view_project_checklists',
            'add_project_checklist',
            'edit_project_checklist',
            'delete_project_checklist',
            'complete_project_checklist',
        ];

        foreach ($projectPermissions as $permName) {
            $permission = Permission::where('name', $permName)->first();
            if ($permission) {
                $permission->group = 'installation_projects';
                $permission->save();
                $this->command->info("تم تحديث مجموعة الصلاحية: {$permName}");
            } else {
                $this->command->warn("لم يتم العثور على الصلاحية: {$permName}");
            }
        }

        $this->command->info('تم تحديث مجموعات صلاحيات المشاريع بنجاح');
    }
}
