<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\ChartOfAccount;

class UpdateChartOfAccountsIsParentSeeder extends Seeder
{
    /**
     * تحديث حقل is_parent في جدول الحسابات
     *
     * @return void
     */
    public function run()
    {
        // تحديث جميع الحسابات لتكون غير أب بشكل افتراضي
        DB::table('chart_of_accounts')
            ->update(['is_parent' => false]);

        // تحديث الحسابات التي لديها حسابات فرعية لتكون حسابات أب
        $parentAccounts = DB::table('chart_of_accounts as parent')
            ->join('chart_of_accounts as child', 'parent.id', '=', 'child.parent_id')
            ->select('parent.id')
            ->distinct()
            ->get();

        foreach ($parentAccounts as $account) {
            DB::table('chart_of_accounts')
                ->where('id', $account->id)
                ->update(['is_parent' => true]);
        }

        // طباعة معلومات عن عدد الحسابات التي تم تحديثها
        $parentCount = DB::table('chart_of_accounts')->where('is_parent', true)->count();
        $childCount = DB::table('chart_of_accounts')->where('is_parent', false)->count();

        $this->command->info('تم تحديث حقل is_parent في جدول الحسابات بنجاح.');
        $this->command->info("عدد الحسابات الأب: {$parentCount}");
        $this->command->info("عدد الحسابات الفرعية: {$childCount}");
    }
}
