<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class TaxSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // تعطيل فحص المفاتيح الأجنبية مؤقتًا
        DB::statement('SET FOREIGN_KEY_CHECKS=0');

        // حذف البيانات الموجودة
        DB::table('tax_settings')->truncate();

        // إضافة البيانات
        $data = [
            [
                'id' => 1,
                'company_id' => 1,
                'name' => 'ضريبة القيمة المضافة',
                'rate' => 15.00,
                'is_default' => 1,
                'is_active' => 1,
                'description' => 'ضريبة القيمة المضافة بنسبة 15%',
                'created_at' => '2025-09-04 16:04:00',
                'updated_at' => '2025-09-04 16:04:00',
            ],
            [
                'id' => 2,
                'company_id' => 1,
                'name' => 'معفى من الضريبة',
                'rate' => 0.00,
                'is_default' => 0,
                'is_active' => 1,
                'description' => 'معفى من الضريبة',
                'created_at' => '2025-09-04 16:04:00',
                'updated_at' => '2025-09-04 16:04:00',
            ],
        ];

        DB::table('tax_settings')->insert($data);

        // إعادة تفعيل فحص المفاتيح الأجنبية
        DB::statement('SET FOREIGN_KEY_CHECKS=1');
    }
}
