<?php

namespace Database\Seeders;

use App\Models\Role;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class SuperAdminSeeder extends Seeder
{
    /**
     * تنفيذ عملية البذر.
     *
     * @return void
     */
    public function run()
    {
        // الحصول على دور السوبر أدمن
        $superAdminRole = Role::where('slug', 'super_admin')->first();

        if (!$superAdminRole) {
            $this->command->error('دور السوبر أدمن غير موجود. يرجى تنفيذ بذر الأدوار أولاً.');
            return;
        }

        // إنشاء مستخدم السوبر أدمن
        $superAdmin = User::firstOrCreate(
            ['email' => 'admin@example.com'],
            [
                'name' => 'مدير النظام',
                'password' => Hash::make('password'),
                'email_verified_at' => now(),
                'is_active' => true,
            ]
        );

        // تعيين دور السوبر أدمن للمستخدم
        if ($superAdminRole && $superAdminRole->id) {
            $superAdmin->roles()->sync([$superAdminRole->id]);
        }

        $this->command->info('تم إنشاء مستخدم السوبر أدمن بنجاح.');
    }
}
