<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;
use App\Models\Role;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class SmartRecommendationsPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $permissions = [
            // Smart Recommendations
            ['name' => 'view_smart_recommendations', 'description' => 'عرض التوصيات الذكية للشراء التلقائي', 'group' => 'المخزون'],
            ['name' => 'apply_smart_recommendations', 'description' => 'تطبيق التوصيات الذكية على قواعد الشراء التلقائي', 'group' => 'المخزون'],
            ['name' => 'apply_seasonal_adjustments', 'description' => 'تطبيق التعديلات الموسمية على قواعد الشراء التلقائي', 'group' => 'المخزون'],
            ['name' => 'create_recommended_rules', 'description' => 'إنشاء قواعد شراء تلقائي جديدة من التوصيات', 'group' => 'المخزون'],
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(
                ['name' => $permission['name']],
                [
                    'slug' => str_replace('_', '-', $permission['name']),
                    'description' => $permission['description'],
                    'group' => $permission['group'],
                    'is_active' => true
                ]
            );
        }

        // إضافة الصلاحيات للأدوار
        $roles = ['super_admin', 'admin', 'inventory_manager'];

        foreach ($roles as $roleName) {
            $role = Role::where('name', $roleName)->first();
            if ($role) {
                foreach ($permissions as $permission) {
                    $permissionModel = Permission::where('name', $permission['name'])->first();
                    if ($permissionModel) {
                        // تحقق من وجود العلاقة قبل إضافتها
                        if (!$role->permissions()->where('permissions.id', $permissionModel->id)->exists()) {
                            $role->permissions()->attach($permissionModel->id);
                        }
                    }
                }
            }
        }
    }
}
