<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // تعطيل فحص المفاتيح الأجنبية مؤقتًا
        DB::statement('SET FOREIGN_KEY_CHECKS=0');

        // حذف البيانات الموجودة
        DB::table('roles')->truncate();

        // إضافة البيانات
        $data = [
            [
                'id' => 1,
                'company_id' => null,
                'name' => 'مدير النظام',
                'slug' => 'admin',
                'description' => 'مدير النظام مع كامل الصلاحيات',
                'level' => 0,
                'path' => 1,
                'is_active' => 1,
                'is_system_role' => 1,
                'is_default' => 0,
                'order' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:24',
                'updated_at' => '2025-09-03 08:39:24',
                'deleted_at' => null,
            ],
            [
                'id' => 2,
                'company_id' => null,
                'name' => 'مستخدم',
                'slug' => 'user',
                'description' => 'مستخدم عادي مع صلاحيات محدودة',
                'level' => 0,
                'path' => 2,
                'is_active' => 1,
                'is_system_role' => 1,
                'is_default' => 1,
                'order' => 2,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:24',
                'updated_at' => '2025-09-03 08:39:24',
                'deleted_at' => null,
            ],
            [
                'id' => 3,
                'company_id' => null,
                'name' => 'مدير فرع',
                'slug' => 'branch_manager',
                'description' => 'مدير فرع مع صلاحيات إدارة الفرع',
                'level' => 0,
                'path' => 3,
                'is_active' => 1,
                'is_system_role' => 1,
                'is_default' => 0,
                'order' => 3,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:24',
                'updated_at' => '2025-09-03 08:39:24',
                'deleted_at' => null,
            ],
            [
                'id' => 4,
                'company_id' => null,
                'name' => 'فني',
                'slug' => 'technician',
                'description' => 'فني مع صلاحيات محددة للصيانة',
                'level' => 0,
                'path' => 4,
                'is_active' => 1,
                'is_system_role' => 1,
                'is_default' => 0,
                'order' => 4,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:25',
                'updated_at' => '2025-09-03 08:39:25',
                'deleted_at' => null,
            ],
            [
                'id' => 5,
                'company_id' => null,
                'name' => 'محاسب',
                'slug' => 'accountant',
                'description' => 'محاسب مع صلاحيات مالية',
                'level' => 0,
                'path' => 5,
                'is_active' => 1,
                'is_system_role' => 1,
                'is_default' => 0,
                'order' => 5,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:25',
                'updated_at' => '2025-09-03 08:39:25',
                'deleted_at' => null,
            ],
            [
                'id' => 6,
                'company_id' => null,
                'name' => 'مدير النظام',
                'slug' => 'super_admin',
                'description' => 'لديه كافة الصلاحيات في النظام',
                'level' => 0,
                'path' => null,
                'is_active' => 1,
                'is_system_role' => 1,
                'is_default' => 0,
                'order' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:49',
                'updated_at' => '2025-09-03 08:39:49',
                'deleted_at' => null,
            ],
            [
                'id' => 8,
                'company_id' => null,
                'name' => 'مدير الصيانة',
                'slug' => 'مدير الصيانة',
                'description' => null,
                'level' => 0,
                'path' => 8,
                'is_active' => 1,
                'is_system_role' => 0,
                'is_default' => 0,
                'order' => 0,
                'parent_id' => null,
                'created_at' => '2025-09-04 03:09:51',
                'updated_at' => '2025-09-04 03:09:51',
                'deleted_at' => null,
            ],
            [
                'id' => 9,
                'company_id' => null,
                'name' => 'مدير الشركة',
                'slug' => 'company_manager',
                'description' => null,
                'level' => 0,
                'path' => 9,
                'is_active' => 1,
                'is_system_role' => 0,
                'is_default' => 0,
                'order' => 0,
                'parent_id' => null,
                'created_at' => '2025-09-04 05:19:30',
                'updated_at' => '2025-09-04 05:19:30',
                'deleted_at' => null,
            ],
            [
                'id' => 10,
                'company_id' => null,
                'name' => 'مدير الشركة الحديث',
                'slug' => '2company_manager',
                'description' => 'المستخدم الذي نجر به صلاحيات كل شيء',
                'level' => 0,
                'path' => 10,
                'is_active' => 1,
                'is_system_role' => 0,
                'is_default' => 0,
                'order' => 0,
                'parent_id' => null,
                'created_at' => '2025-09-04 15:00:16',
                'updated_at' => '2025-09-06 04:41:59',
                'deleted_at' => null,
            ],
            [
                'id' => 11,
                'company_id' => null,
                'name' => 'مدير المخزون',
                'slug' => 'inventory_manager',
                'description' => 'مدير المخزون مع صلاحيات كاملة لإدارة المخزون',
                'level' => 0,
                'path' => 6,
                'is_active' => 1,
                'is_system_role' => 1,
                'is_default' => 0,
                'order' => 6,
                'parent_id' => null,
                'created_at' => '2025-09-04 20:20:07',
                'updated_at' => '2025-09-04 20:20:07',
                'deleted_at' => null,
            ],
            [
                'id' => 12,
                'company_id' => null,
                'name' => 'أمين مستودع',
                'slug' => 'warehouse_keeper',
                'description' => 'أمين مستودع مع صلاحيات محددة لإدارة المستودع',
                'level' => 0,
                'path' => 7,
                'is_active' => 1,
                'is_system_role' => 1,
                'is_default' => 0,
                'order' => 7,
                'parent_id' => null,
                'created_at' => '2025-09-04 20:20:07',
                'updated_at' => '2025-09-04 20:20:07',
                'deleted_at' => null,
            ],
            [
                'id' => 13,
                'company_id' => null,
                'name' => 'مسؤول المشتريات',
                'slug' => 'purchasing_officer',
                'description' => 'مسؤول المشتريات مع صلاحيات إدارة أوامر الشراء والموردين',
                'level' => 0,
                'path' => 8,
                'is_active' => 1,
                'is_system_role' => 1,
                'is_default' => 0,
                'order' => 8,
                'parent_id' => null,
                'created_at' => '2025-09-04 20:20:07',
                'updated_at' => '2025-09-04 20:20:07',
                'deleted_at' => null,
            ],
            [
                'id' => 14,
                'company_id' => null,
                'name' => 'مسؤول الموارد البشرية',
                'slug' => 'hr',
                'description' => 'مسؤول الموارد البشرية مع صلاحيات إدارة الموظفين والرواتب',
                'level' => 0,
                'path' => 6,
                'is_active' => 1,
                'is_system_role' => 1,
                'is_default' => 0,
                'order' => 6,
                'parent_id' => null,
                'created_at' => '2025-09-05 21:14:45',
                'updated_at' => '2025-09-05 21:14:45',
                'deleted_at' => null,
            ],
            [
                'id' => 15,
                'company_id' => null,
                'name' => 'مدير الموارد البشرية',
                'slug' => 'hrm_manager',
                'description' => 'لديه كافة صلاحيات إدارة الموارد البشرية',
                'level' => 0,
                'path' => null,
                'is_active' => 1,
                'is_system_role' => 1,
                'is_default' => 0,
                'order' => 4,
                'parent_id' => null,
                'created_at' => '2025-09-06 18:57:11',
                'updated_at' => '2025-09-06 18:57:11',
                'deleted_at' => null,
            ],
            [
                'id' => 16,
                'company_id' => null,
                'name' => 'موظف الموارد البشرية',
                'slug' => 'hrm_staff',
                'description' => 'لديه صلاحيات محددة في إدارة الموارد البشرية',
                'level' => 0,
                'path' => null,
                'is_active' => 1,
                'is_system_role' => 1,
                'is_default' => 0,
                'order' => 5,
                'parent_id' => null,
                'created_at' => '2025-09-06 18:57:11',
                'updated_at' => '2025-09-06 18:57:11',
                'deleted_at' => null,
            ],
            [
                'id' => 17,
                'company_id' => null,
                'name' => 'محاسب الرواتب',
                'slug' => 'payroll_accountant',
                'description' => 'مسؤول عن إدارة كشوف الرواتب والمدفوعات',
                'level' => 0,
                'path' => null,
                'is_active' => 1,
                'is_system_role' => 1,
                'is_default' => 0,
                'order' => 6,
                'parent_id' => null,
                'created_at' => '2025-09-06 18:57:11',
                'updated_at' => '2025-09-06 18:57:11',
                'deleted_at' => null,
            ],
            [
                'id' => 18,
                'company_id' => null,
                'name' => 'مدير المشروعات',
                'slug' => 'project_manager',
                'description' => 'مدير المشروعات',
                'level' => 0,
                'path' => 18,
                'is_active' => 1,
                'is_system_role' => 0,
                'is_default' => 0,
                'order' => 0,
                'parent_id' => null,
                'created_at' => '2025-09-07 08:05:03',
                'updated_at' => '2025-09-07 08:05:03',
                'deleted_at' => null,
            ],
        ];

        DB::table('roles')->insert($data);

        // إعادة تفعيل فحص المفاتيح الأجنبية
        DB::statement('SET FOREIGN_KEY_CHECKS=1');
    }
}
