<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;
use Illuminate\Support\Facades\DB;

class ProjectInventoryPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $permissions = [
            // طلبات المخزون للمشاريع
            ['name' => 'view_project_inventory_requests', 'slug' => 'view_project_inventory_requests', 'description' => 'عرض طلبات المخزون للمشاريع', 'group' => 'المشاريع'],
            ['name' => 'create_project_inventory_requests', 'slug' => 'create_project_inventory_requests', 'description' => 'إنشاء طلب مخزون للمشروع', 'group' => 'المشاريع'],
            ['name' => 'edit_project_inventory_requests', 'slug' => 'edit_project_inventory_requests', 'description' => 'تعديل طلب مخزون للمشروع', 'group' => 'المشاريع'],
            ['name' => 'delete_project_inventory_requests', 'slug' => 'delete_project_inventory_requests', 'description' => 'حذف طلب مخزون للمشروع', 'group' => 'المشاريع'],
            ['name' => 'approve_project_inventory_requests', 'slug' => 'approve_project_inventory_requests', 'description' => 'اعتماد طلب مخزون للمشروع', 'group' => 'المشاريع'],
            ['name' => 'reject_project_inventory_requests', 'slug' => 'reject_project_inventory_requests', 'description' => 'رفض طلب مخزون للمشروع', 'group' => 'المشاريع'],
            ['name' => 'fulfill_project_inventory_requests', 'slug' => 'fulfill_project_inventory_requests', 'description' => 'تنفيذ طلب مخزون للمشروع', 'group' => 'المشاريع'],
            ['name' => 'view_project_inventory_reports', 'slug' => 'view_project_inventory_reports', 'description' => 'عرض تقارير مخزون المشاريع', 'group' => 'المشاريع'],
        ];

        foreach ($permissions as $permission) {
            // البحث عن الصلاحية إما بالاسم أو بالسلاج
            $existingPermission = Permission::where('name', $permission['name'])
                ->orWhere('slug', $permission['slug'])
                ->first();

            if ($existingPermission) {
                // تحديث الصلاحية الموجودة
                $existingPermission->update([
                    'name' => $permission['name'],
                    'description' => $permission['description'],
                    'group' => $permission['group']
                ]);
            } else {
                // إنشاء صلاحية جديدة
                Permission::create([
                    'name' => $permission['name'],
                    'slug' => $permission['slug'],
                    'description' => $permission['description'],
                    'group' => $permission['group']
                ]);
            }
        }
    }
}
