<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\Permission;
use App\Models\Role;
use Illuminate\Support\Facades\Log;

class ProjectDocumentsExpensesPaymentsPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // تعريف الصلاحيات الجديدة
        $permissions = [
            // صلاحيات المستندات
            'view_project_documents' => 'عرض مستندات المشروع',
            'upload_project_document' => 'رفع مستند للمشروع',
            'edit_project_document' => 'تعديل مستند المشروع',
            'delete_project_document' => 'حذف مستند المشروع',
            'download_project_document' => 'تنزيل مستند المشروع',

            // صلاحيات المصروفات
            'view_project_expenses' => 'عرض مصروفات المشروع',
            'add_project_expense' => 'إضافة مصروف للمشروع',
            'edit_project_expense' => 'تعديل مصروف المشروع',
            'delete_project_expense' => 'حذف مصروف المشروع',
            'approve_expenses' => 'اعتماد مصروفات المشروع',

            // صلاحيات المدفوعات
            'view_project_payments' => 'عرض مدفوعات المشروع',
            'add_project_payment' => 'إضافة دفعة للمشروع',
            'edit_project_payment' => 'تعديل دفعة المشروع',
            'delete_project_payment' => 'حذف دفعة المشروع',
            'approve_payments' => 'اعتماد مدفوعات المشروع',
        ];

        // إضافة الصلاحيات إلى قاعدة البيانات
        $permissionGroup = 'installation_projects';
        $createdCount = 0;
        $existingCount = 0;

        foreach ($permissions as $name => $display_name) {
            $existingPermission = Permission::where('name', $name)->first();

            if ($existingPermission) {
                // تحديث الصلاحية الموجودة
                $existingPermission->update([
                    'group' => $permissionGroup
                ]);
                $existingCount++;
            } else {
                // إنشاء صلاحية جديدة
                Permission::create([
                    'name' => $name,
                    'slug' => $name,
                    'description' => $display_name,
                    'group' => $permissionGroup
                ]);
                $createdCount++;
            }
        }

        Log::info("تم إنشاء {$createdCount} صلاحية جديدة وتحديث {$existingCount} صلاحية موجودة");

        // إضافة الصلاحيات للأدوار المناسبة
        $this->assignPermissionsToRoles();
    }

    /**
     * إسناد الصلاحيات للأدوار المناسبة
     */
    private function assignPermissionsToRoles()
    {
        // الصلاحيات للمدير
        $adminPermissions = [
            'view_project_documents',
            'upload_project_document',
            'edit_project_document',
            'delete_project_document',
            'download_project_document',
            'view_project_expenses',
            'add_project_expense',
            'edit_project_expense',
            'delete_project_expense',
            'approve_expenses',
            'view_project_payments',
            'add_project_payment',
            'edit_project_payment',
            'delete_project_payment',
            'approve_payments',
        ];

        // الصلاحيات لمدير المشروع
        $projectManagerPermissions = [
            'view_project_documents',
            'upload_project_document',
            'edit_project_document',
            'delete_project_document',
            'download_project_document',
            'view_project_expenses',
            'add_project_expense',
            'edit_project_expense',
            'delete_project_expense',
            'view_project_payments',
            'add_project_payment',
            'edit_project_payment',
        ];

        // الصلاحيات للمحاسب
        $accountantPermissions = [
            'view_project_documents',
            'download_project_document',
            'view_project_expenses',
            'add_project_expense',
            'edit_project_expense',
            'approve_expenses',
            'view_project_payments',
            'add_project_payment',
            'edit_project_payment',
            'approve_payments',
        ];

        // الصلاحيات لمهندس المشروع
        $projectEngineerPermissions = [
            'view_project_documents',
            'upload_project_document',
            'download_project_document',
            'view_project_expenses',
            'add_project_expense',
            'view_project_payments',
        ];

        // الصلاحيات لمشرف المشروع
        $projectSupervisorPermissions = [
            'view_project_documents',
            'upload_project_document',
            'download_project_document',
            'view_project_expenses',
            'add_project_expense',
        ];

        // إسناد الصلاحيات للمدير
        $adminRole = Role::where('slug', 'admin')->first();
        if ($adminRole) {
            $this->syncRolePermissions($adminRole, $adminPermissions);
        }

        // إسناد الصلاحيات لمدير المشروع
        $projectManagerRole = Role::where('slug', 'project_manager')->first();
        if ($projectManagerRole) {
            $this->syncRolePermissions($projectManagerRole, $projectManagerPermissions);
        }

        // إسناد الصلاحيات للمحاسب
        $accountantRole = Role::where('slug', 'accountant')->first();
        if ($accountantRole) {
            $this->syncRolePermissions($accountantRole, $accountantPermissions);
        }

        // إسناد الصلاحيات لمهندس المشروع
        $projectEngineerRole = Role::where('slug', 'project_engineer')->first();
        if ($projectEngineerRole) {
            $this->syncRolePermissions($projectEngineerRole, $projectEngineerPermissions);
        }

        // إسناد الصلاحيات لمشرف المشروع
        $projectSupervisorRole = Role::where('slug', 'project_supervisor')->first();
        if ($projectSupervisorRole) {
            $this->syncRolePermissions($projectSupervisorRole, $projectSupervisorPermissions);
        }
    }

    /**
     * إسناد الصلاحيات للدور بدون إزالة الصلاحيات الموجودة
     */
    private function syncRolePermissions($role, $permissionNames)
    {
        $permissions = Permission::whereIn('name', $permissionNames)->get();
        $permissionIds = $permissions->pluck('id')->toArray();

        if (count($permissionIds) > 0) {
            $role->permissions()->syncWithoutDetaching($permissionIds);
            Log::info("تم إسناد " . count($permissionIds) . " صلاحية للدور: " . $role->name);
        }
    }
}
