<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // تعطيل فحص المفاتيح الأجنبية مؤقتًا
        DB::statement('SET FOREIGN_KEY_CHECKS=0');

        // حذف البيانات الموجودة
        DB::table('permissions')->truncate();

        // إضافة البيانات
        $data = [
            [
                'id' => 1,
                'name' => 'إدارة المستخدمين',
                'slug' => 'manage_users',
                'description' => 'إدارة كاملة لـ إدارة المستخدمين',
                'group' => 'users',
                'level' => 0,
                'path' => 1,
                'type' => 'group',
                'resource' => 'users',
                'order' => 1,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:14',
                'updated_at' => '2025-09-05 21:36:58',
                'deleted_at' => null,
            ],
            [
                'id' => 2,
                'name' => 'عرض إدارة المستخدمين',
                'slug' => 'view_user',
                'description' => 'عرض إدارة المستخدمين',
                'group' => 'users',
                'level' => 1,
                'path' => 1.2,
                'type' => 'action',
                'resource' => 'users',
                'order' => 1,
                'is_active' => 1,
                'parent_id' => 1,
                'created_at' => '2025-09-03 08:39:14',
                'updated_at' => '2025-09-03 08:39:14',
                'deleted_at' => null,
            ],
            [
                'id' => 3,
                'name' => 'إنشاء إدارة المستخدمين',
                'slug' => 'create_user',
                'description' => 'إنشاء إدارة المستخدمين',
                'group' => 'users',
                'level' => 1,
                'path' => 1.3,
                'type' => 'action',
                'resource' => 'users',
                'order' => 2,
                'is_active' => 1,
                'parent_id' => 1,
                'created_at' => '2025-09-03 08:39:14',
                'updated_at' => '2025-09-03 08:39:14',
                'deleted_at' => null,
            ],
            [
                'id' => 4,
                'name' => 'تعديل إدارة المستخدمين',
                'slug' => 'edit_user',
                'description' => 'تعديل إدارة المستخدمين',
                'group' => 'users',
                'level' => 1,
                'path' => 1.4,
                'type' => 'action',
                'resource' => 'users',
                'order' => 3,
                'is_active' => 1,
                'parent_id' => 1,
                'created_at' => '2025-09-03 08:39:14',
                'updated_at' => '2025-09-03 08:39:14',
                'deleted_at' => null,
            ],
            [
                'id' => 5,
                'name' => 'حذف إدارة المستخدمين',
                'slug' => 'delete_user',
                'description' => 'حذف إدارة المستخدمين',
                'group' => 'users',
                'level' => 1,
                'path' => 1.5,
                'type' => 'action',
                'resource' => 'users',
                'order' => 4,
                'is_active' => 1,
                'parent_id' => 1,
                'created_at' => '2025-09-03 08:39:14',
                'updated_at' => '2025-09-03 08:39:14',
                'deleted_at' => null,
            ],
            [
                'id' => 6,
                'name' => 'إدارة الأدوار',
                'slug' => 'manage_roles',
                'description' => 'إدارة كاملة لـ إدارة الأدوار',
                'group' => 'roles',
                'level' => 0,
                'path' => 6,
                'type' => 'group',
                'resource' => 'roles',
                'order' => 2,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:14',
                'updated_at' => '2025-09-05 21:36:58',
                'deleted_at' => null,
            ],
            [
                'id' => 7,
                'name' => 'عرض إدارة الأدوار',
                'slug' => 'view_role',
                'description' => 'عرض إدارة الأدوار',
                'group' => 'roles',
                'level' => 1,
                'path' => 6.7,
                'type' => 'action',
                'resource' => 'roles',
                'order' => 1,
                'is_active' => 1,
                'parent_id' => 6,
                'created_at' => '2025-09-03 08:39:14',
                'updated_at' => '2025-09-03 08:39:14',
                'deleted_at' => null,
            ],
            [
                'id' => 8,
                'name' => 'إنشاء إدارة الأدوار',
                'slug' => 'create_role',
                'description' => 'إنشاء إدارة الأدوار',
                'group' => 'roles',
                'level' => 1,
                'path' => 6.8,
                'type' => 'action',
                'resource' => 'roles',
                'order' => 2,
                'is_active' => 1,
                'parent_id' => 6,
                'created_at' => '2025-09-03 08:39:14',
                'updated_at' => '2025-09-03 08:39:14',
                'deleted_at' => null,
            ],
            [
                'id' => 9,
                'name' => 'تعديل إدارة الأدوار',
                'slug' => 'edit_role',
                'description' => 'تعديل إدارة الأدوار',
                'group' => 'roles',
                'level' => 1,
                'path' => 6.9,
                'type' => 'action',
                'resource' => 'roles',
                'order' => 3,
                'is_active' => 1,
                'parent_id' => 6,
                'created_at' => '2025-09-03 08:39:14',
                'updated_at' => '2025-09-03 08:39:14',
                'deleted_at' => null,
            ],
            [
                'id' => 10,
                'name' => 'حذف إدارة الأدوار',
                'slug' => 'delete_role',
                'description' => 'حذف إدارة الأدوار',
                'group' => 'roles',
                'level' => 1,
                'path' => 6.10,
                'type' => 'action',
                'resource' => 'roles',
                'order' => 4,
                'is_active' => 1,
                'parent_id' => 6,
                'created_at' => '2025-09-03 08:39:15',
                'updated_at' => '2025-09-03 08:39:15',
                'deleted_at' => null,
            ],
            [
                'id' => 11,
                'name' => 'إدارة الصلاحيات',
                'slug' => 'manage_permissions',
                'description' => 'إدارة كاملة لـ إدارة الصلاحيات',
                'group' => 'permissions',
                'level' => 0,
                'path' => 11,
                'type' => 'group',
                'resource' => 'permissions',
                'order' => 3,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:15',
                'updated_at' => '2025-09-05 21:36:58',
                'deleted_at' => null,
            ],
            [
                'id' => 12,
                'name' => 'عرض إدارة الصلاحيات',
                'slug' => 'view_permission',
                'description' => 'عرض إدارة الصلاحيات',
                'group' => 'permissions',
                'level' => 1,
                'path' => 11.12,
                'type' => 'action',
                'resource' => 'permissions',
                'order' => 1,
                'is_active' => 1,
                'parent_id' => 11,
                'created_at' => '2025-09-03 08:39:15',
                'updated_at' => '2025-09-03 08:39:15',
                'deleted_at' => null,
            ],
            [
                'id' => 13,
                'name' => 'إنشاء إدارة الصلاحيات',
                'slug' => 'create_permission',
                'description' => 'إنشاء إدارة الصلاحيات',
                'group' => 'permissions',
                'level' => 1,
                'path' => 11.13,
                'type' => 'action',
                'resource' => 'permissions',
                'order' => 2,
                'is_active' => 1,
                'parent_id' => 11,
                'created_at' => '2025-09-03 08:39:15',
                'updated_at' => '2025-09-03 08:39:15',
                'deleted_at' => null,
            ],
            [
                'id' => 14,
                'name' => 'تعديل إدارة الصلاحيات',
                'slug' => 'edit_permission',
                'description' => 'تعديل إدارة الصلاحيات',
                'group' => 'permissions',
                'level' => 1,
                'path' => 11.14,
                'type' => 'action',
                'resource' => 'permissions',
                'order' => 3,
                'is_active' => 1,
                'parent_id' => 11,
                'created_at' => '2025-09-03 08:39:15',
                'updated_at' => '2025-09-03 08:39:15',
                'deleted_at' => null,
            ],
            [
                'id' => 15,
                'name' => 'حذف إدارة الصلاحيات',
                'slug' => 'delete_permission',
                'description' => 'حذف إدارة الصلاحيات',
                'group' => 'permissions',
                'level' => 1,
                'path' => 11.15,
                'type' => 'action',
                'resource' => 'permissions',
                'order' => 4,
                'is_active' => 1,
                'parent_id' => 11,
                'created_at' => '2025-09-03 08:39:15',
                'updated_at' => '2025-09-03 08:39:15',
                'deleted_at' => null,
            ],
            [
                'id' => 16,
                'name' => 'إدارة الشركات',
                'slug' => 'manage_companies',
                'description' => 'إدارة كاملة لـ إدارة الشركات',
                'group' => 'companies',
                'level' => 0,
                'path' => 16,
                'type' => 'group',
                'resource' => 'companies',
                'order' => 4,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:15',
                'updated_at' => '2025-09-05 21:36:58',
                'deleted_at' => null,
            ],
            [
                'id' => 17,
                'name' => 'عرض إدارة الشركات',
                'slug' => 'view_companie',
                'description' => 'عرض إدارة الشركات',
                'group' => 'companies',
                'level' => 1,
                'path' => 16.17,
                'type' => 'action',
                'resource' => 'companies',
                'order' => 1,
                'is_active' => 1,
                'parent_id' => 16,
                'created_at' => '2025-09-03 08:39:15',
                'updated_at' => '2025-09-03 08:39:15',
                'deleted_at' => null,
            ],
            [
                'id' => 18,
                'name' => 'إنشاء إدارة الشركات',
                'slug' => 'create_companie',
                'description' => 'إنشاء إدارة الشركات',
                'group' => 'companies',
                'level' => 1,
                'path' => 16.18,
                'type' => 'action',
                'resource' => 'companies',
                'order' => 2,
                'is_active' => 1,
                'parent_id' => 16,
                'created_at' => '2025-09-03 08:39:15',
                'updated_at' => '2025-09-03 08:39:15',
                'deleted_at' => null,
            ],
            [
                'id' => 19,
                'name' => 'تعديل إدارة الشركات',
                'slug' => 'edit_companie',
                'description' => 'تعديل إدارة الشركات',
                'group' => 'companies',
                'level' => 1,
                'path' => 16.19,
                'type' => 'action',
                'resource' => 'companies',
                'order' => 3,
                'is_active' => 1,
                'parent_id' => 16,
                'created_at' => '2025-09-03 08:39:15',
                'updated_at' => '2025-09-03 08:39:15',
                'deleted_at' => null,
            ],
            [
                'id' => 20,
                'name' => 'حذف إدارة الشركات',
                'slug' => 'delete_companie',
                'description' => 'حذف إدارة الشركات',
                'group' => 'companies',
                'level' => 1,
                'path' => 16.20,
                'type' => 'action',
                'resource' => 'companies',
                'order' => 4,
                'is_active' => 1,
                'parent_id' => 16,
                'created_at' => '2025-09-03 08:39:15',
                'updated_at' => '2025-09-03 08:39:16',
                'deleted_at' => null,
            ],
            [
                'id' => 21,
                'name' => 'إدارة الفروع',
                'slug' => 'manage_branches',
                'description' => 'إدارة كاملة لـ إدارة الفروع',
                'group' => 'branches',
                'level' => 0,
                'path' => 21,
                'type' => 'group',
                'resource' => 'branches',
                'order' => 5,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:16',
                'updated_at' => '2025-09-05 21:36:58',
                'deleted_at' => null,
            ],
            [
                'id' => 22,
                'name' => 'عرض إدارة الفروع',
                'slug' => 'view_branche',
                'description' => 'عرض إدارة الفروع',
                'group' => 'branches',
                'level' => 1,
                'path' => 21.22,
                'type' => 'action',
                'resource' => 'branches',
                'order' => 1,
                'is_active' => 1,
                'parent_id' => 21,
                'created_at' => '2025-09-03 08:39:16',
                'updated_at' => '2025-09-03 08:39:16',
                'deleted_at' => null,
            ],
            [
                'id' => 23,
                'name' => 'إنشاء إدارة الفروع',
                'slug' => 'create_branche',
                'description' => 'إنشاء إدارة الفروع',
                'group' => 'branches',
                'level' => 1,
                'path' => 21.23,
                'type' => 'action',
                'resource' => 'branches',
                'order' => 2,
                'is_active' => 1,
                'parent_id' => 21,
                'created_at' => '2025-09-03 08:39:16',
                'updated_at' => '2025-09-03 08:39:16',
                'deleted_at' => null,
            ],
            [
                'id' => 24,
                'name' => 'تعديل إدارة الفروع',
                'slug' => 'edit_branche',
                'description' => 'تعديل إدارة الفروع',
                'group' => 'branches',
                'level' => 1,
                'path' => 21.24,
                'type' => 'action',
                'resource' => 'branches',
                'order' => 3,
                'is_active' => 1,
                'parent_id' => 21,
                'created_at' => '2025-09-03 08:39:16',
                'updated_at' => '2025-09-03 08:39:16',
                'deleted_at' => null,
            ],
            [
                'id' => 25,
                'name' => 'حذف إدارة الفروع',
                'slug' => 'delete_branche',
                'description' => 'حذف إدارة الفروع',
                'group' => 'branches',
                'level' => 1,
                'path' => 21.25,
                'type' => 'action',
                'resource' => 'branches',
                'order' => 4,
                'is_active' => 1,
                'parent_id' => 21,
                'created_at' => '2025-09-03 08:39:16',
                'updated_at' => '2025-09-03 08:39:16',
                'deleted_at' => null,
            ],
            [
                'id' => 26,
                'name' => 'إدارة المصاعد',
                'slug' => 'manage_elevators',
                'description' => 'إدارة كاملة لـ إدارة المصاعد',
                'group' => 'elevators',
                'level' => 0,
                'path' => 26,
                'type' => 'group',
                'resource' => 'elevators',
                'order' => 6,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:16',
                'updated_at' => '2025-09-05 21:36:58',
                'deleted_at' => null,
            ],
            [
                'id' => 27,
                'name' => 'عرض إدارة المصاعد',
                'slug' => 'view_elevator',
                'description' => 'عرض إدارة المصاعد',
                'group' => 'elevators',
                'level' => 1,
                'path' => 26.27,
                'type' => 'action',
                'resource' => 'elevators',
                'order' => 1,
                'is_active' => 1,
                'parent_id' => 26,
                'created_at' => '2025-09-03 08:39:16',
                'updated_at' => '2025-09-03 08:39:16',
                'deleted_at' => null,
            ],
            [
                'id' => 28,
                'name' => 'إنشاء إدارة المصاعد',
                'slug' => 'create_elevator',
                'description' => 'إنشاء إدارة المصاعد',
                'group' => 'elevators',
                'level' => 1,
                'path' => 26.28,
                'type' => 'action',
                'resource' => 'elevators',
                'order' => 2,
                'is_active' => 1,
                'parent_id' => 26,
                'created_at' => '2025-09-03 08:39:16',
                'updated_at' => '2025-09-03 08:39:16',
                'deleted_at' => null,
            ],
            [
                'id' => 29,
                'name' => 'تعديل إدارة المصاعد',
                'slug' => 'edit_elevator',
                'description' => 'تعديل إدارة المصاعد',
                'group' => 'elevators',
                'level' => 1,
                'path' => 26.29,
                'type' => 'action',
                'resource' => 'elevators',
                'order' => 3,
                'is_active' => 1,
                'parent_id' => 26,
                'created_at' => '2025-09-03 08:39:16',
                'updated_at' => '2025-09-03 08:39:16',
                'deleted_at' => null,
            ],
            [
                'id' => 30,
                'name' => 'حذف إدارة المصاعد',
                'slug' => 'delete_elevator',
                'description' => 'حذف إدارة المصاعد',
                'group' => 'elevators',
                'level' => 1,
                'path' => 26.30,
                'type' => 'action',
                'resource' => 'elevators',
                'order' => 4,
                'is_active' => 1,
                'parent_id' => 26,
                'created_at' => '2025-09-03 08:39:16',
                'updated_at' => '2025-09-03 08:39:17',
                'deleted_at' => null,
            ],
            [
                'id' => 31,
                'name' => 'إدارة العملاء',
                'slug' => 'manage_customers',
                'description' => 'إدارة كاملة لـ إدارة العملاء',
                'group' => 'customers',
                'level' => 0,
                'path' => 31,
                'type' => 'group',
                'resource' => 'customers',
                'order' => 7,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:17',
                'updated_at' => '2025-09-05 21:36:58',
                'deleted_at' => null,
            ],
            [
                'id' => 32,
                'name' => 'عرض إدارة العملاء',
                'slug' => 'view_customer',
                'description' => 'عرض إدارة العملاء',
                'group' => 'customers',
                'level' => 1,
                'path' => 31.32,
                'type' => 'action',
                'resource' => 'customers',
                'order' => 1,
                'is_active' => 1,
                'parent_id' => 31,
                'created_at' => '2025-09-03 08:39:17',
                'updated_at' => '2025-09-03 08:39:17',
                'deleted_at' => null,
            ],
            [
                'id' => 33,
                'name' => 'إنشاء إدارة العملاء',
                'slug' => 'create_customer',
                'description' => 'إنشاء إدارة العملاء',
                'group' => 'customers',
                'level' => 1,
                'path' => 31.33,
                'type' => 'action',
                'resource' => 'customers',
                'order' => 2,
                'is_active' => 1,
                'parent_id' => 31,
                'created_at' => '2025-09-03 08:39:17',
                'updated_at' => '2025-09-03 08:39:17',
                'deleted_at' => null,
            ],
            [
                'id' => 34,
                'name' => 'تعديل إدارة العملاء',
                'slug' => 'edit_customer',
                'description' => 'تعديل إدارة العملاء',
                'group' => 'customers',
                'level' => 1,
                'path' => 31.34,
                'type' => 'action',
                'resource' => 'customers',
                'order' => 3,
                'is_active' => 1,
                'parent_id' => 31,
                'created_at' => '2025-09-03 08:39:17',
                'updated_at' => '2025-09-03 08:39:17',
                'deleted_at' => null,
            ],
            [
                'id' => 35,
                'name' => 'حذف إدارة العملاء',
                'slug' => 'delete_customer',
                'description' => 'حذف إدارة العملاء',
                'group' => 'customers',
                'level' => 1,
                'path' => 31.35,
                'type' => 'action',
                'resource' => 'customers',
                'order' => 4,
                'is_active' => 1,
                'parent_id' => 31,
                'created_at' => '2025-09-03 08:39:17',
                'updated_at' => '2025-09-03 08:39:17',
                'deleted_at' => null,
            ],
            [
                'id' => 36,
                'name' => 'إدارة المواقع',
                'slug' => 'manage_locations',
                'description' => 'إدارة كاملة لـ إدارة المواقع',
                'group' => 'locations',
                'level' => 0,
                'path' => 36,
                'type' => 'group',
                'resource' => 'locations',
                'order' => 8,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:17',
                'updated_at' => '2025-09-05 21:36:58',
                'deleted_at' => null,
            ],
            [
                'id' => 37,
                'name' => 'عرض إدارة المواقع',
                'slug' => 'view_location',
                'description' => 'عرض إدارة المواقع',
                'group' => 'locations',
                'level' => 1,
                'path' => 36.37,
                'type' => 'action',
                'resource' => 'locations',
                'order' => 1,
                'is_active' => 1,
                'parent_id' => 36,
                'created_at' => '2025-09-03 08:39:17',
                'updated_at' => '2025-09-03 08:39:17',
                'deleted_at' => null,
            ],
            [
                'id' => 38,
                'name' => 'إنشاء إدارة المواقع',
                'slug' => 'create_location',
                'description' => 'إنشاء إدارة المواقع',
                'group' => 'locations',
                'level' => 1,
                'path' => 36.38,
                'type' => 'action',
                'resource' => 'locations',
                'order' => 2,
                'is_active' => 1,
                'parent_id' => 36,
                'created_at' => '2025-09-03 08:39:17',
                'updated_at' => '2025-09-03 08:39:17',
                'deleted_at' => null,
            ],
            [
                'id' => 39,
                'name' => 'تعديل إدارة المواقع',
                'slug' => 'edit_location',
                'description' => 'تعديل إدارة المواقع',
                'group' => 'locations',
                'level' => 1,
                'path' => 36.39,
                'type' => 'action',
                'resource' => 'locations',
                'order' => 3,
                'is_active' => 1,
                'parent_id' => 36,
                'created_at' => '2025-09-03 08:39:17',
                'updated_at' => '2025-09-03 08:39:17',
                'deleted_at' => null,
            ],
            [
                'id' => 40,
                'name' => 'حذف إدارة المواقع',
                'slug' => 'delete_location',
                'description' => 'حذف إدارة المواقع',
                'group' => 'locations',
                'level' => 1,
                'path' => 36.40,
                'type' => 'action',
                'resource' => 'locations',
                'order' => 4,
                'is_active' => 1,
                'parent_id' => 36,
                'created_at' => '2025-09-03 08:39:18',
                'updated_at' => '2025-09-03 08:39:18',
                'deleted_at' => null,
            ],
            [
                'id' => 41,
                'name' => 'إدارة العقود',
                'slug' => 'manage_contracts',
                'description' => 'إدارة كاملة لـ إدارة العقود',
                'group' => 'contracts',
                'level' => 0,
                'path' => 41,
                'type' => 'group',
                'resource' => 'contracts',
                'order' => 9,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:18',
                'updated_at' => '2025-09-05 21:36:58',
                'deleted_at' => null,
            ],
            [
                'id' => 42,
                'name' => 'عرض إدارة العقود',
                'slug' => 'view_contract',
                'description' => 'عرض إدارة العقود',
                'group' => 'contracts',
                'level' => 1,
                'path' => 41.42,
                'type' => 'action',
                'resource' => 'contracts',
                'order' => 1,
                'is_active' => 1,
                'parent_id' => 41,
                'created_at' => '2025-09-03 08:39:18',
                'updated_at' => '2025-09-03 08:39:18',
                'deleted_at' => null,
            ],
            [
                'id' => 43,
                'name' => 'إنشاء إدارة العقود',
                'slug' => 'create_contract',
                'description' => 'إنشاء إدارة العقود',
                'group' => 'contracts',
                'level' => 1,
                'path' => 41.43,
                'type' => 'action',
                'resource' => 'contracts',
                'order' => 2,
                'is_active' => 1,
                'parent_id' => 41,
                'created_at' => '2025-09-03 08:39:18',
                'updated_at' => '2025-09-03 08:39:18',
                'deleted_at' => null,
            ],
            [
                'id' => 44,
                'name' => 'تعديل إدارة العقود',
                'slug' => 'edit_contract',
                'description' => 'تعديل إدارة العقود',
                'group' => 'contracts',
                'level' => 1,
                'path' => 41.44,
                'type' => 'action',
                'resource' => 'contracts',
                'order' => 3,
                'is_active' => 1,
                'parent_id' => 41,
                'created_at' => '2025-09-03 08:39:18',
                'updated_at' => '2025-09-03 08:39:18',
                'deleted_at' => null,
            ],
            [
                'id' => 45,
                'name' => 'حذف إدارة العقود',
                'slug' => 'delete_contract',
                'description' => 'حذف إدارة العقود',
                'group' => 'contracts',
                'level' => 1,
                'path' => 41.45,
                'type' => 'action',
                'resource' => 'contracts',
                'order' => 4,
                'is_active' => 1,
                'parent_id' => 41,
                'created_at' => '2025-09-03 08:39:18',
                'updated_at' => '2025-09-03 08:39:18',
                'deleted_at' => null,
            ],
            [
                'id' => 46,
                'name' => 'إدارة الفواتير',
                'slug' => 'manage_invoices',
                'description' => 'إدارة كاملة لـ إدارة الفواتير',
                'group' => 'invoices',
                'level' => 0,
                'path' => 46,
                'type' => 'group',
                'resource' => 'invoices',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:18',
                'updated_at' => '2025-09-05 21:36:58',
                'deleted_at' => null,
            ],
            [
                'id' => 47,
                'name' => 'عرض إدارة الفواتير',
                'slug' => 'view_invoice',
                'description' => 'عرض إدارة الفواتير',
                'group' => 'invoices',
                'level' => 1,
                'path' => 46.47,
                'type' => 'action',
                'resource' => 'invoices',
                'order' => 1,
                'is_active' => 1,
                'parent_id' => 46,
                'created_at' => '2025-09-03 08:39:18',
                'updated_at' => '2025-09-03 08:39:18',
                'deleted_at' => null,
            ],
            [
                'id' => 48,
                'name' => 'إنشاء إدارة الفواتير',
                'slug' => 'create_invoice',
                'description' => 'إنشاء إدارة الفواتير',
                'group' => 'invoices',
                'level' => 1,
                'path' => 46.48,
                'type' => 'action',
                'resource' => 'invoices',
                'order' => 2,
                'is_active' => 1,
                'parent_id' => 46,
                'created_at' => '2025-09-03 08:39:19',
                'updated_at' => '2025-09-03 08:39:19',
                'deleted_at' => null,
            ],
            [
                'id' => 49,
                'name' => 'تعديل إدارة الفواتير',
                'slug' => 'edit_invoice',
                'description' => 'تعديل إدارة الفواتير',
                'group' => 'invoices',
                'level' => 1,
                'path' => 46.49,
                'type' => 'action',
                'resource' => 'invoices',
                'order' => 3,
                'is_active' => 1,
                'parent_id' => 46,
                'created_at' => '2025-09-03 08:39:19',
                'updated_at' => '2025-09-03 08:39:19',
                'deleted_at' => null,
            ],
            [
                'id' => 50,
                'name' => 'حذف إدارة الفواتير',
                'slug' => 'delete_invoice',
                'description' => 'حذف إدارة الفواتير',
                'group' => 'invoices',
                'level' => 1,
                'path' => 46.50,
                'type' => 'action',
                'resource' => 'invoices',
                'order' => 4,
                'is_active' => 1,
                'parent_id' => 46,
                'created_at' => '2025-09-03 08:39:19',
                'updated_at' => '2025-09-03 08:39:19',
                'deleted_at' => null,
            ],
            [
                'id' => 51,
                'name' => 'إدارة المدفوعات',
                'slug' => 'manage_payments',
                'description' => 'إدارة كاملة لـ إدارة المدفوعات',
                'group' => 'payments',
                'level' => 0,
                'path' => 51,
                'type' => 'group',
                'resource' => 'payments',
                'order' => 11,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:19',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 52,
                'name' => 'عرض إدارة المدفوعات',
                'slug' => 'view_payment',
                'description' => 'عرض إدارة المدفوعات',
                'group' => 'payments',
                'level' => 1,
                'path' => 51.52,
                'type' => 'action',
                'resource' => 'payments',
                'order' => 1,
                'is_active' => 1,
                'parent_id' => 51,
                'created_at' => '2025-09-03 08:39:19',
                'updated_at' => '2025-09-03 08:39:19',
                'deleted_at' => null,
            ],
            [
                'id' => 53,
                'name' => 'إنشاء إدارة المدفوعات',
                'slug' => 'create_payment',
                'description' => 'إنشاء إدارة المدفوعات',
                'group' => 'payments',
                'level' => 1,
                'path' => 51.53,
                'type' => 'action',
                'resource' => 'payments',
                'order' => 2,
                'is_active' => 1,
                'parent_id' => 51,
                'created_at' => '2025-09-03 08:39:19',
                'updated_at' => '2025-09-03 08:39:19',
                'deleted_at' => null,
            ],
            [
                'id' => 54,
                'name' => 'تعديل إدارة المدفوعات',
                'slug' => 'edit_payment',
                'description' => 'تعديل إدارة المدفوعات',
                'group' => 'payments',
                'level' => 1,
                'path' => 51.54,
                'type' => 'action',
                'resource' => 'payments',
                'order' => 3,
                'is_active' => 1,
                'parent_id' => 51,
                'created_at' => '2025-09-03 08:39:19',
                'updated_at' => '2025-09-03 08:39:19',
                'deleted_at' => null,
            ],
            [
                'id' => 55,
                'name' => 'حذف إدارة المدفوعات',
                'slug' => 'delete_payment',
                'description' => 'حذف إدارة المدفوعات',
                'group' => 'payments',
                'level' => 1,
                'path' => 51.55,
                'type' => 'action',
                'resource' => 'payments',
                'order' => 4,
                'is_active' => 1,
                'parent_id' => 51,
                'created_at' => '2025-09-03 08:39:19',
                'updated_at' => '2025-09-03 08:39:19',
                'deleted_at' => null,
            ],
            [
                'id' => 56,
                'name' => 'إدارة التقارير',
                'slug' => 'manage_reports',
                'description' => 'إدارة كاملة لـ إدارة التقارير',
                'group' => 'reports',
                'level' => 0,
                'path' => 56,
                'type' => 'group',
                'resource' => 'reports',
                'order' => 12,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:19',
                'updated_at' => '2025-09-05 21:37:00',
                'deleted_at' => null,
            ],
            [
                'id' => 57,
                'name' => 'عرض إدارة التقارير',
                'slug' => 'view_report',
                'description' => 'عرض إدارة التقارير',
                'group' => 'reports',
                'level' => 1,
                'path' => 56.57,
                'type' => 'action',
                'resource' => 'reports',
                'order' => 1,
                'is_active' => 1,
                'parent_id' => 56,
                'created_at' => '2025-09-03 08:39:20',
                'updated_at' => '2025-09-03 08:39:20',
                'deleted_at' => null,
            ],
            [
                'id' => 58,
                'name' => 'إنشاء إدارة التقارير',
                'slug' => 'create_report',
                'description' => 'إنشاء إدارة التقارير',
                'group' => 'reports',
                'level' => 1,
                'path' => 56.58,
                'type' => 'action',
                'resource' => 'reports',
                'order' => 2,
                'is_active' => 1,
                'parent_id' => 56,
                'created_at' => '2025-09-03 08:39:20',
                'updated_at' => '2025-09-03 08:39:20',
                'deleted_at' => null,
            ],
            [
                'id' => 59,
                'name' => 'تعديل إدارة التقارير',
                'slug' => 'edit_report',
                'description' => 'تعديل إدارة التقارير',
                'group' => 'reports',
                'level' => 1,
                'path' => 56.59,
                'type' => 'action',
                'resource' => 'reports',
                'order' => 3,
                'is_active' => 1,
                'parent_id' => 56,
                'created_at' => '2025-09-03 08:39:20',
                'updated_at' => '2025-09-03 08:39:20',
                'deleted_at' => null,
            ],
            [
                'id' => 60,
                'name' => 'حذف إدارة التقارير',
                'slug' => 'delete_report',
                'description' => 'حذف إدارة التقارير',
                'group' => 'reports',
                'level' => 1,
                'path' => 56.60,
                'type' => 'action',
                'resource' => 'reports',
                'order' => 4,
                'is_active' => 1,
                'parent_id' => 56,
                'created_at' => '2025-09-03 08:39:20',
                'updated_at' => '2025-09-03 08:39:20',
                'deleted_at' => null,
            ],
            [
                'id' => 61,
                'name' => 'إدارة الإعدادات',
                'slug' => 'manage_settings',
                'description' => 'إدارة كاملة لـ إدارة الإعدادات',
                'group' => 'settings',
                'level' => 0,
                'path' => 61,
                'type' => 'group',
                'resource' => 'settings',
                'order' => 13,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:20',
                'updated_at' => '2025-09-05 21:37:00',
                'deleted_at' => null,
            ],
            [
                'id' => 62,
                'name' => 'عرض إدارة الإعدادات',
                'slug' => 'view_setting',
                'description' => 'عرض إدارة الإعدادات',
                'group' => 'settings',
                'level' => 1,
                'path' => 61.62,
                'type' => 'action',
                'resource' => 'settings',
                'order' => 1,
                'is_active' => 1,
                'parent_id' => 61,
                'created_at' => '2025-09-03 08:39:20',
                'updated_at' => '2025-09-03 08:39:20',
                'deleted_at' => null,
            ],
            [
                'id' => 63,
                'name' => 'إنشاء إدارة الإعدادات',
                'slug' => 'create_setting',
                'description' => 'إنشاء إدارة الإعدادات',
                'group' => 'settings',
                'level' => 1,
                'path' => 61.63,
                'type' => 'action',
                'resource' => 'settings',
                'order' => 2,
                'is_active' => 1,
                'parent_id' => 61,
                'created_at' => '2025-09-03 08:39:20',
                'updated_at' => '2025-09-03 08:39:20',
                'deleted_at' => null,
            ],
            [
                'id' => 64,
                'name' => 'تعديل إدارة الإعدادات',
                'slug' => 'edit_setting',
                'description' => 'تعديل إدارة الإعدادات',
                'group' => 'settings',
                'level' => 1,
                'path' => 61.64,
                'type' => 'action',
                'resource' => 'settings',
                'order' => 3,
                'is_active' => 1,
                'parent_id' => 61,
                'created_at' => '2025-09-03 08:39:20',
                'updated_at' => '2025-09-03 08:39:21',
                'deleted_at' => null,
            ],
            [
                'id' => 65,
                'name' => 'حذف إدارة الإعدادات',
                'slug' => 'delete_setting',
                'description' => 'حذف إدارة الإعدادات',
                'group' => 'settings',
                'level' => 1,
                'path' => 61.65,
                'type' => 'action',
                'resource' => 'settings',
                'order' => 4,
                'is_active' => 1,
                'parent_id' => 61,
                'created_at' => '2025-09-03 08:39:21',
                'updated_at' => '2025-09-03 08:39:21',
                'deleted_at' => null,
            ],
            [
                'id' => 66,
                'name' => 'إدارة الأمان',
                'slug' => 'manage_security',
                'description' => 'إدارة كاملة لـ إدارة الأمان',
                'group' => 'security',
                'level' => 0,
                'path' => 66,
                'type' => 'group',
                'resource' => 'security',
                'order' => 14,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 08:39:21',
                'updated_at' => '2025-09-05 21:37:00',
                'deleted_at' => null,
            ],
            [
                'id' => 67,
                'name' => 'عرض إدارة الأمان',
                'slug' => 'view_security',
                'description' => 'عرض إدارة الأمان',
                'group' => 'security',
                'level' => 1,
                'path' => 66.67,
                'type' => 'action',
                'resource' => 'security',
                'order' => 1,
                'is_active' => 1,
                'parent_id' => 66,
                'created_at' => '2025-09-03 08:39:21',
                'updated_at' => '2025-09-03 08:39:21',
                'deleted_at' => null,
            ],
            [
                'id' => 68,
                'name' => 'إنشاء إدارة الأمان',
                'slug' => 'create_security',
                'description' => 'إنشاء إدارة الأمان',
                'group' => 'security',
                'level' => 1,
                'path' => 66.68,
                'type' => 'action',
                'resource' => 'security',
                'order' => 2,
                'is_active' => 1,
                'parent_id' => 66,
                'created_at' => '2025-09-03 08:39:21',
                'updated_at' => '2025-09-03 08:39:21',
                'deleted_at' => null,
            ],
            [
                'id' => 69,
                'name' => 'تعديل إدارة الأمان',
                'slug' => 'edit_security',
                'description' => 'تعديل إدارة الأمان',
                'group' => 'security',
                'level' => 1,
                'path' => 66.69,
                'type' => 'action',
                'resource' => 'security',
                'order' => 3,
                'is_active' => 1,
                'parent_id' => 66,
                'created_at' => '2025-09-03 08:39:21',
                'updated_at' => '2025-09-03 08:39:21',
                'deleted_at' => null,
            ],
            [
                'id' => 70,
                'name' => 'حذف إدارة الأمان',
                'slug' => 'delete_security',
                'description' => 'حذف إدارة الأمان',
                'group' => 'security',
                'level' => 1,
                'path' => 66.70,
                'type' => 'action',
                'resource' => 'security',
                'order' => 4,
                'is_active' => 1,
                'parent_id' => 66,
                'created_at' => '2025-09-03 08:39:21',
                'updated_at' => '2025-09-03 08:39:21',
                'deleted_at' => null,
            ],
            [
                'id' => 71,
                'name' => 'عرض سجل النشاطات',
                'slug' => 'view_activity_logs',
                'description' => 'عرض سجل النشاطات في النظام',
                'group' => 'security',
                'level' => 1,
                'path' => 66.71,
                'type' => 'action',
                'resource' => 'activity_logs',
                'order' => 5,
                'is_active' => 1,
                'parent_id' => 66,
                'created_at' => '2025-09-03 08:39:21',
                'updated_at' => '2025-09-05 21:37:01',
                'deleted_at' => null,
            ],
            [
                'id' => 72,
                'name' => 'عرض سجل تسجيل الدخول',
                'slug' => 'view_login_history',
                'description' => 'عرض سجل تسجيل الدخول في النظام',
                'group' => 'security',
                'level' => 1,
                'path' => 66.72,
                'type' => 'action',
                'resource' => 'login_history',
                'order' => 6,
                'is_active' => 1,
                'parent_id' => 66,
                'created_at' => '2025-09-03 08:39:21',
                'updated_at' => '2025-09-05 21:37:01',
                'deleted_at' => null,
            ],
            [
                'id' => 73,
                'name' => 'إدارة المصادقة الثنائية',
                'slug' => 'manage_two_factor',
                'description' => 'إدارة إعدادات المصادقة الثنائية',
                'group' => 'security',
                'level' => 1,
                'path' => 66.73,
                'type' => 'action',
                'resource' => 'two_factor',
                'order' => 7,
                'is_active' => 1,
                'parent_id' => 66,
                'created_at' => '2025-09-03 08:39:21',
                'updated_at' => '2025-09-05 21:37:01',
                'deleted_at' => null,
            ],
            [
                'id' => 74,
                'name' => 'إدارة النسخ الاحتياطية',
                'slug' => 'manage_backups',
                'description' => 'إدارة النسخ الاحتياطية للنظام',
                'group' => 'settings',
                'level' => 1,
                'path' => 61.74,
                'type' => 'action',
                'resource' => 'backups',
                'order' => 5,
                'is_active' => 1,
                'parent_id' => 61,
                'created_at' => '2025-09-03 08:39:21',
                'updated_at' => '2025-09-05 21:37:00',
                'deleted_at' => null,
            ],
            [
                'id' => 75,
                'name' => 'إدارة إعدادات النظام',
                'slug' => 'manage_system_settings',
                'description' => 'إدارة إعدادات النظام العامة',
                'group' => 'settings',
                'level' => 1,
                'path' => 61.75,
                'type' => 'action',
                'resource' => 'system_settings',
                'order' => 6,
                'is_active' => 1,
                'parent_id' => 61,
                'created_at' => '2025-09-03 08:39:22',
                'updated_at' => '2025-09-05 21:37:00',
                'deleted_at' => null,
            ],
            [
                'id' => 76,
                'name' => 'إضافة مستخدمين',
                'slug' => 'create_users',
                'description' => 'إضافة مستخدمين جدد',
                'group' => 'users',
                'level' => 1,
                'path' => 1.76,
                'type' => 'action',
                'resource' => 'users',
                'order' => 5,
                'is_active' => 1,
                'parent_id' => 1,
                'created_at' => '2025-09-03 09:34:35',
                'updated_at' => '2025-09-05 21:36:58',
                'deleted_at' => null,
            ],
            [
                'id' => 77,
                'name' => 'إدارة جداول الصيانة',
                'slug' => 'manage-maintenance-schedule',
                'description' => 'إدارة جداول الصيانة الدورية',
                'group' => 'maintenance_schedule',
                'level' => 0,
                'path' => null,
                'type' => 'crud',
                'resource' => null,
                'order' => 1,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 20:32:15',
                'updated_at' => '2025-09-05 21:37:01',
                'deleted_at' => null,
            ],
            [
                'id' => 78,
                'name' => 'عرض جداول الصيانة',
                'slug' => 'view-maintenance-schedule',
                'description' => 'عرض قائمة جداول الصيانة',
                'group' => 'maintenance_schedule',
                'level' => 0,
                'path' => null,
                'type' => 'view',
                'resource' => null,
                'order' => 2,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 20:32:15',
                'updated_at' => '2025-09-05 21:37:01',
                'deleted_at' => null,
            ],
            [
                'id' => 79,
                'name' => 'إضافة جدول صيانة',
                'slug' => 'create-maintenance-schedule',
                'description' => 'إضافة جدول صيانة جديد',
                'group' => 'maintenance_schedule',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 3,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 20:32:15',
                'updated_at' => '2025-09-05 21:37:01',
                'deleted_at' => null,
            ],
            [
                'id' => 80,
                'name' => 'تعديل جدول صيانة',
                'slug' => 'edit-maintenance-schedule',
                'description' => 'تعديل بيانات جدول الصيانة',
                'group' => 'maintenance_schedule',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 4,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 20:32:15',
                'updated_at' => '2025-09-05 21:37:01',
                'deleted_at' => null,
            ],
            [
                'id' => 81,
                'name' => 'حذف جدول صيانة',
                'slug' => 'delete-maintenance-schedule',
                'description' => 'حذف جدول صيانة',
                'group' => 'maintenance_schedule',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 5,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 20:32:15',
                'updated_at' => '2025-09-05 21:37:01',
                'deleted_at' => null,
            ],
            [
                'id' => 82,
                'name' => 'توليد جداول الصيانة',
                'slug' => 'generate-maintenance-schedule',
                'description' => 'توليد جداول صيانة تلقائية',
                'group' => 'maintenance_schedule',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 6,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 20:32:16',
                'updated_at' => '2025-09-05 21:37:01',
                'deleted_at' => null,
            ],
            [
                'id' => 83,
                'name' => 'إدارة سجلات الصيانة',
                'slug' => 'manage-maintenance-log',
                'description' => 'إدارة سجلات الصيانة الدورية',
                'group' => 'maintenance_log',
                'level' => 0,
                'path' => null,
                'type' => 'crud',
                'resource' => null,
                'order' => 1,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 20:32:16',
                'updated_at' => '2025-09-05 21:37:01',
                'deleted_at' => null,
            ],
            [
                'id' => 84,
                'name' => 'عرض سجلات الصيانة',
                'slug' => 'view-maintenance-log',
                'description' => 'عرض قائمة سجلات الصيانة',
                'group' => 'maintenance_log',
                'level' => 0,
                'path' => null,
                'type' => 'view',
                'resource' => null,
                'order' => 2,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 20:32:16',
                'updated_at' => '2025-09-05 21:37:01',
                'deleted_at' => null,
            ],
            [
                'id' => 85,
                'name' => 'إضافة سجل صيانة',
                'slug' => 'create-maintenance-log',
                'description' => 'إضافة سجل صيانة جديد',
                'group' => 'maintenance_log',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 3,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 20:32:16',
                'updated_at' => '2025-09-05 21:37:01',
                'deleted_at' => null,
            ],
            [
                'id' => 86,
                'name' => 'تعديل سجل صيانة',
                'slug' => 'edit-maintenance-log',
                'description' => 'تعديل بيانات سجل الصيانة',
                'group' => 'maintenance_log',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 4,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 20:32:16',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 87,
                'name' => 'حذف سجل صيانة',
                'slug' => 'delete-maintenance-log',
                'description' => 'حذف سجل صيانة',
                'group' => 'maintenance_log',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 5,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 20:32:16',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 88,
                'name' => 'تصدير سجلات الصيانة',
                'slug' => 'export-maintenance-log',
                'description' => 'تصدير سجلات الصيانة',
                'group' => 'maintenance_log',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 6,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 20:32:16',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 89,
                'name' => 'طباعة سجلات الصيانة',
                'slug' => 'print-maintenance-log',
                'description' => 'طباعة سجلات الصيانة',
                'group' => 'maintenance_log',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 7,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 20:32:16',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 90,
                'name' => 'جداول الصيانة',
                'slug' => 'group_maintenance_schedule',
                'description' => 'مجموعة صلاحيات جداول الصيانة',
                'group' => 'maintenance_schedule',
                'level' => 0,
                'path' => 90,
                'type' => 'group',
                'resource' => null,
                'order' => 15,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 21:26:23',
                'updated_at' => '2025-09-05 21:37:01',
                'deleted_at' => null,
            ],
            [
                'id' => 91,
                'name' => 'سجلات الصيانة',
                'slug' => 'group_maintenance_log',
                'description' => 'مجموعة صلاحيات سجلات الصيانة',
                'group' => 'maintenance_log',
                'level' => 0,
                'path' => 91,
                'type' => 'group',
                'resource' => null,
                'order' => 16,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-03 21:26:24',
                'updated_at' => '2025-09-05 21:37:01',
                'deleted_at' => null,
            ],
            [
                'id' => 92,
                'name' => 'إدارة تفاعلات العملاء',
                'slug' => 'manage_customer_interactions',
                'description' => 'إدارة كاملة لتفاعلات العملاء',
                'group' => 'customer_interaction',
                'level' => 0,
                'path' => null,
                'type' => 'crud',
                'resource' => null,
                'order' => 1,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:45',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 93,
                'name' => 'عرض تفاعلات العملاء',
                'slug' => 'view_customer_interaction',
                'description' => 'عرض تفاعلات العملاء',
                'group' => 'customer_interaction',
                'level' => 0,
                'path' => null,
                'type' => 'view',
                'resource' => null,
                'order' => 2,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:45',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 94,
                'name' => 'إضافة تفاعل عميل',
                'slug' => 'create_customer_interaction',
                'description' => 'إضافة تفاعل عميل جديد',
                'group' => 'customer_interaction',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 3,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:45',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 95,
                'name' => 'تعديل تفاعل عميل',
                'slug' => 'edit_customer_interaction',
                'description' => 'تعديل تفاعل عميل',
                'group' => 'customer_interaction',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 4,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:45',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 96,
                'name' => 'حذف تفاعل عميل',
                'slug' => 'delete_customer_interaction',
                'description' => 'حذف تفاعل عميل',
                'group' => 'customer_interaction',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 5,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:46',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 97,
                'name' => 'إدارة الفرص التجارية',
                'slug' => 'manage_opportunities',
                'description' => 'إدارة كاملة للفرص التجارية',
                'group' => 'opportunity',
                'level' => 0,
                'path' => null,
                'type' => 'crud',
                'resource' => null,
                'order' => 1,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:46',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 98,
                'name' => 'عرض الفرص التجارية',
                'slug' => 'view_opportunity',
                'description' => 'عرض الفرص التجارية',
                'group' => 'opportunity',
                'level' => 0,
                'path' => null,
                'type' => 'view',
                'resource' => null,
                'order' => 2,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:46',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 99,
                'name' => 'إضافة فرصة تجارية',
                'slug' => 'create_opportunity',
                'description' => 'إضافة فرصة تجارية جديدة',
                'group' => 'opportunity',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 3,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:46',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 100,
                'name' => 'تعديل فرصة تجارية',
                'slug' => 'edit_opportunity',
                'description' => 'تعديل فرصة تجارية',
                'group' => 'opportunity',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 4,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:46',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 101,
                'name' => 'حذف فرصة تجارية',
                'slug' => 'delete_opportunity',
                'description' => 'حذف فرصة تجارية',
                'group' => 'opportunity',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 5,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:46',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 102,
                'name' => 'إدارة نقاط الولاء',
                'slug' => 'manage_loyalty_points',
                'description' => 'إدارة كاملة لنقاط الولاء',
                'group' => 'loyalty_point',
                'level' => 0,
                'path' => null,
                'type' => 'crud',
                'resource' => null,
                'order' => 1,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:46',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 103,
                'name' => 'عرض نقاط الولاء',
                'slug' => 'view_loyalty_point',
                'description' => 'عرض نقاط الولاء',
                'group' => 'loyalty_point',
                'level' => 0,
                'path' => null,
                'type' => 'view',
                'resource' => null,
                'order' => 2,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:46',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 104,
                'name' => 'إضافة نقاط ولاء',
                'slug' => 'create_loyalty_point',
                'description' => 'إضافة نقاط ولاء جديدة',
                'group' => 'loyalty_point',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 3,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:46',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 105,
                'name' => 'تعديل نقاط ولاء',
                'slug' => 'edit_loyalty_point',
                'description' => 'تعديل نقاط ولاء',
                'group' => 'loyalty_point',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 4,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:46',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 106,
                'name' => 'حذف نقاط ولاء',
                'slug' => 'delete_loyalty_point',
                'description' => 'حذف نقاط ولاء',
                'group' => 'loyalty_point',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 5,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:46',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 107,
                'name' => 'إدارة مكافآت العملاء',
                'slug' => 'manage_customer_rewards',
                'description' => 'إدارة كاملة لمكافآت العملاء',
                'group' => 'customer_reward',
                'level' => 0,
                'path' => null,
                'type' => 'crud',
                'resource' => null,
                'order' => 1,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:47',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 108,
                'name' => 'عرض مكافآت العملاء',
                'slug' => 'view_customer_reward',
                'description' => 'عرض مكافآت العملاء',
                'group' => 'customer_reward',
                'level' => 0,
                'path' => null,
                'type' => 'view',
                'resource' => null,
                'order' => 2,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:47',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 109,
                'name' => 'إضافة مكافأة عميل',
                'slug' => 'create_customer_reward',
                'description' => 'إضافة مكافأة عميل جديدة',
                'group' => 'customer_reward',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 3,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:47',
                'updated_at' => '2025-09-05 21:37:02',
                'deleted_at' => null,
            ],
            [
                'id' => 110,
                'name' => 'تعديل مكافأة عميل',
                'slug' => 'edit_customer_reward',
                'description' => 'تعديل مكافأة عميل',
                'group' => 'customer_reward',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 4,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:47',
                'updated_at' => '2025-09-05 21:37:03',
                'deleted_at' => null,
            ],
            [
                'id' => 111,
                'name' => 'حذف مكافأة عميل',
                'slug' => 'delete_customer_reward',
                'description' => 'حذف مكافأة عميل',
                'group' => 'customer_reward',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 5,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:47',
                'updated_at' => '2025-09-05 21:37:03',
                'deleted_at' => null,
            ],
            [
                'id' => 112,
                'name' => 'إدارة استخدام المكافآت',
                'slug' => 'manage_reward_redemptions',
                'description' => 'إدارة كاملة لاستخدام المكافآت',
                'group' => 'reward_redemption',
                'level' => 0,
                'path' => null,
                'type' => 'crud',
                'resource' => null,
                'order' => 1,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:47',
                'updated_at' => '2025-09-05 21:37:03',
                'deleted_at' => null,
            ],
            [
                'id' => 113,
                'name' => 'عرض استخدام المكافآت',
                'slug' => 'view_reward_redemption',
                'description' => 'عرض استخدام المكافآت',
                'group' => 'reward_redemption',
                'level' => 0,
                'path' => null,
                'type' => 'view',
                'resource' => null,
                'order' => 2,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:47',
                'updated_at' => '2025-09-05 21:37:03',
                'deleted_at' => null,
            ],
            [
                'id' => 114,
                'name' => 'إضافة استخدام مكافأة',
                'slug' => 'create_reward_redemption',
                'description' => 'إضافة استخدام مكافأة جديد',
                'group' => 'reward_redemption',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 3,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:47',
                'updated_at' => '2025-09-05 21:37:03',
                'deleted_at' => null,
            ],
            [
                'id' => 115,
                'name' => 'تعديل استخدام مكافأة',
                'slug' => 'edit_reward_redemption',
                'description' => 'تعديل استخدام مكافأة',
                'group' => 'reward_redemption',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 4,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:47',
                'updated_at' => '2025-09-05 21:37:03',
                'deleted_at' => null,
            ],
            [
                'id' => 116,
                'name' => 'حذف استخدام مكافأة',
                'slug' => 'delete_reward_redemption',
                'description' => 'حذف استخدام مكافأة',
                'group' => 'reward_redemption',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 5,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 07:28:47',
                'updated_at' => '2025-09-05 21:37:03',
                'deleted_at' => null,
            ],
            [
                'id' => 117,
                'name' => 'invoices.view',
                'slug' => 'invoices.view',
                'description' => 'صلاحية invoices.view',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 5,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:40',
                'updated_at' => '2025-09-05 21:36:58',
                'deleted_at' => null,
            ],
            [
                'id' => 118,
                'name' => 'invoices.create',
                'slug' => 'invoices.create',
                'description' => 'صلاحية invoices.create',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 6,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:40',
                'updated_at' => '2025-09-05 21:36:58',
                'deleted_at' => null,
            ],
            [
                'id' => 119,
                'name' => 'invoices.edit',
                'slug' => 'invoices.edit',
                'description' => 'صلاحية invoices.edit',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 7,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:40',
                'updated_at' => '2025-09-05 21:36:58',
                'deleted_at' => null,
            ],
            [
                'id' => 120,
                'name' => 'invoices.delete',
                'slug' => 'invoices.delete',
                'description' => 'صلاحية invoices.delete',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 8,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:40',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 121,
                'name' => 'invoices.export',
                'slug' => 'invoices.export',
                'description' => 'صلاحية invoices.export',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 9,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:40',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 122,
                'name' => 'invoices.generate_recurring',
                'slug' => 'invoices.generate_recurring',
                'description' => 'صلاحية invoices.generate_recurring',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 10,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:40',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 123,
                'name' => 'invoices.create_installments',
                'slug' => 'invoices.create_installments',
                'description' => 'صلاحية invoices.create_installments',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 11,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:41',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 124,
                'name' => 'invoice_templates.view',
                'slug' => 'invoice_templates.view',
                'description' => 'صلاحية invoice_templates.view',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 12,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:41',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 125,
                'name' => 'invoice_templates.create',
                'slug' => 'invoice_templates.create',
                'description' => 'صلاحية invoice_templates.create',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 13,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:41',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 126,
                'name' => 'invoice_templates.edit',
                'slug' => 'invoice_templates.edit',
                'description' => 'صلاحية invoice_templates.edit',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 14,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:41',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 127,
                'name' => 'invoice_templates.delete',
                'slug' => 'invoice_templates.delete',
                'description' => 'صلاحية invoice_templates.delete',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 15,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:41',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 128,
                'name' => 'invoice_installments.view',
                'slug' => 'invoice_installments.view',
                'description' => 'صلاحية invoice_installments.view',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 16,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:41',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 129,
                'name' => 'invoice_installments.create',
                'slug' => 'invoice_installments.create',
                'description' => 'صلاحية invoice_installments.create',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 17,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:41',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 130,
                'name' => 'invoice_installments.edit',
                'slug' => 'invoice_installments.edit',
                'description' => 'صلاحية invoice_installments.edit',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 18,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:41',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 131,
                'name' => 'invoice_installments.delete',
                'slug' => 'invoice_installments.delete',
                'description' => 'صلاحية invoice_installments.delete',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 19,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:41',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 132,
                'name' => 'tax_reports.view',
                'slug' => 'tax_reports.view',
                'description' => 'صلاحية tax_reports.view',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 20,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:42',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 133,
                'name' => 'tax_reports.create',
                'slug' => 'tax_reports.create',
                'description' => 'صلاحية tax_reports.create',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 21,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:42',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 134,
                'name' => 'tax_reports.edit',
                'slug' => 'tax_reports.edit',
                'description' => 'صلاحية tax_reports.edit',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 22,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:42',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 135,
                'name' => 'tax_reports.delete',
                'slug' => 'tax_reports.delete',
                'description' => 'صلاحية tax_reports.delete',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 23,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:42',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 136,
                'name' => 'tax_reports.export',
                'slug' => 'tax_reports.export',
                'description' => 'صلاحية tax_reports.export',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 24,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:42',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 137,
                'name' => 'financial_reports.view',
                'slug' => 'financial_reports.view',
                'description' => 'صلاحية financial_reports.view',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 25,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:42',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 138,
                'name' => 'financial_reports.export',
                'slug' => 'financial_reports.export',
                'description' => 'صلاحية financial_reports.export',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 26,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:42',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 139,
                'name' => 'customer_statements.view',
                'slug' => 'customer_statements.view',
                'description' => 'صلاحية customer_statements.view',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 27,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:42',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 140,
                'name' => 'customer_statements.export',
                'slug' => 'customer_statements.export',
                'description' => 'صلاحية customer_statements.export',
                'group' => 'invoices',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 28,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 14:40:42',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 141,
                'name' => 'تغيير حالة الدفعة',
                'slug' => 'change_payment_status',
                'description' => 'تغيير حالة الدفعة (مكتمل، قيد الانتظار، فشل، مسترجع)',
                'group' => 'payments',
                'level' => 1,
                'path' => 51.141,
                'type' => 'action',
                'resource' => 'payments',
                'order' => 5,
                'is_active' => 1,
                'parent_id' => 51,
                'created_at' => '2025-09-04 15:37:50',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 142,
                'name' => 'طباعة إيصال الدفع',
                'slug' => 'print_payment_receipt',
                'description' => 'طباعة إيصال الدفع',
                'group' => 'payments',
                'level' => 1,
                'path' => 51.142,
                'type' => 'action',
                'resource' => 'payments',
                'order' => 6,
                'is_active' => 1,
                'parent_id' => 51,
                'created_at' => '2025-09-04 15:37:50',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 143,
                'name' => 'إدارة إعدادات الضرائب',
                'slug' => 'manage_tax_settings',
                'description' => 'إدارة كاملة لإعدادات الضرائب',
                'group' => 'settings',
                'level' => 1,
                'path' => 61.143,
                'type' => 'group',
                'resource' => 'tax_settings',
                'order' => 7,
                'is_active' => 1,
                'parent_id' => 61,
                'created_at' => '2025-09-04 15:37:51',
                'updated_at' => '2025-09-05 21:37:00',
                'deleted_at' => null,
            ],
            [
                'id' => 144,
                'name' => 'عرض إعدادات الضرائب',
                'slug' => 'tax_settings.view',
                'description' => 'عرض إعدادات الضرائب',
                'group' => 'settings',
                'level' => 2,
                'path' => '61.143.144',
                'type' => 'action',
                'resource' => 'tax_settings',
                'order' => 8,
                'is_active' => 1,
                'parent_id' => 143,
                'created_at' => '2025-09-04 15:37:51',
                'updated_at' => '2025-09-05 21:37:00',
                'deleted_at' => null,
            ],
            [
                'id' => 145,
                'name' => 'إنشاء إعدادات الضرائب',
                'slug' => 'tax_settings.create',
                'description' => 'إنشاء إعدادات الضرائب',
                'group' => 'settings',
                'level' => 2,
                'path' => '61.143.145',
                'type' => 'action',
                'resource' => 'tax_settings',
                'order' => 9,
                'is_active' => 1,
                'parent_id' => 143,
                'created_at' => '2025-09-04 15:37:51',
                'updated_at' => '2025-09-05 21:37:00',
                'deleted_at' => null,
            ],
            [
                'id' => 146,
                'name' => 'تعديل إعدادات الضرائب',
                'slug' => 'tax_settings.edit',
                'description' => 'تعديل إعدادات الضرائب',
                'group' => 'settings',
                'level' => 2,
                'path' => '61.143.146',
                'type' => 'action',
                'resource' => 'tax_settings',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 143,
                'created_at' => '2025-09-04 15:37:51',
                'updated_at' => '2025-09-04 15:37:51',
                'deleted_at' => null,
            ],
            [
                'id' => 147,
                'name' => 'حذف إعدادات الضرائب',
                'slug' => 'tax_settings.delete',
                'description' => 'حذف إعدادات الضرائب',
                'group' => 'settings',
                'level' => 2,
                'path' => '61.143.147',
                'type' => 'action',
                'resource' => 'tax_settings',
                'order' => 11,
                'is_active' => 1,
                'parent_id' => 143,
                'created_at' => '2025-09-04 15:37:51',
                'updated_at' => '2025-09-05 21:37:00',
                'deleted_at' => null,
            ],
            [
                'id' => 148,
                'name' => 'إدارة المستودعات',
                'slug' => 'manage_warehouses',
                'description' => 'إدارة كاملة للمستودعات',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 1,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:01:59',
                'updated_at' => '2025-09-05 21:37:03',
                'deleted_at' => null,
            ],
            [
                'id' => 149,
                'name' => 'view_warehouses',
                'slug' => 'view_warehouses',
                'description' => 'عرض قائمة المستودعات',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 1,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 150,
                'name' => 'إنشاء مستودع',
                'slug' => 'create_warehouse',
                'description' => 'إنشاء مستودع جديد',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 2,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:03',
                'deleted_at' => null,
            ],
            [
                'id' => 151,
                'name' => 'تعديل مستودع',
                'slug' => 'edit_warehouse',
                'description' => 'تعديل مستودع',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 3,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:03',
                'deleted_at' => null,
            ],
            [
                'id' => 152,
                'name' => 'حذف مستودع',
                'slug' => 'delete_warehouse',
                'description' => 'حذف مستودع',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 4,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:03',
                'deleted_at' => null,
            ],
            [
                'id' => 153,
                'name' => 'إدارة الموردين',
                'slug' => 'manage_suppliers',
                'description' => 'إدارة كاملة للموردين',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 5,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:03',
                'deleted_at' => null,
            ],
            [
                'id' => 154,
                'name' => 'view_suppliers',
                'slug' => 'view_suppliers',
                'description' => 'عرض قائمة الموردين',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 2,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 155,
                'name' => 'إنشاء مورد',
                'slug' => 'create_supplier',
                'description' => 'إنشاء مورد جديد',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 6,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:03',
                'deleted_at' => null,
            ],
            [
                'id' => 156,
                'name' => 'تعديل مورد',
                'slug' => 'edit_supplier',
                'description' => 'تعديل مورد',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 7,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:03',
                'deleted_at' => null,
            ],
            [
                'id' => 157,
                'name' => 'حذف مورد',
                'slug' => 'delete_supplier',
                'description' => 'حذف مورد',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 8,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:03',
                'deleted_at' => null,
            ],
            [
                'id' => 158,
                'name' => 'إدارة عناصر المخزون',
                'slug' => 'manage_inventory_items',
                'description' => 'إدارة كاملة لعناصر المخزون',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 9,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:03',
                'deleted_at' => null,
            ],
            [
                'id' => 159,
                'name' => 'view_inventory_items',
                'slug' => 'view_inventory_items',
                'description' => 'عرض عناصر المخزون',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 3,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 160,
                'name' => 'إنشاء عنصر مخزون',
                'slug' => 'create_inventory_item',
                'description' => 'إنشاء عنصر مخزون جديد',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 10,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:03',
                'deleted_at' => null,
            ],
            [
                'id' => 161,
                'name' => 'تعديل عنصر مخزون',
                'slug' => 'edit_inventory_item',
                'description' => 'تعديل عنصر مخزون',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 11,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:03',
                'deleted_at' => null,
            ],
            [
                'id' => 162,
                'name' => 'حذف عنصر مخزون',
                'slug' => 'delete_inventory_item',
                'description' => 'حذف عنصر مخزون',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 12,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:03',
                'deleted_at' => null,
            ],
            [
                'id' => 163,
                'name' => 'إدارة تصنيفات المخزون',
                'slug' => 'manage_inventory_categories',
                'description' => 'إدارة كاملة لتصنيفات المخزون',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 13,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 164,
                'name' => 'view_inventory_categories',
                'slug' => 'view_inventory_categories',
                'description' => 'عرض تصنيفات المخزون',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 4,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 165,
                'name' => 'إنشاء تصنيف مخزون',
                'slug' => 'create_inventory_category',
                'description' => 'إنشاء تصنيف مخزون جديد',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 14,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 166,
                'name' => 'تعديل تصنيف مخزون',
                'slug' => 'edit_inventory_category',
                'description' => 'تعديل تصنيف مخزون',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 15,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 167,
                'name' => 'حذف تصنيف مخزون',
                'slug' => 'delete_inventory_category',
                'description' => 'حذف تصنيف مخزون',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 16,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 168,
                'name' => 'إدارة المخزون',
                'slug' => 'manage_inventory_stock',
                'description' => 'إدارة كاملة للمخزون',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 17,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 169,
                'name' => 'view_inventory_stock',
                'slug' => 'view_inventory_stock',
                'description' => 'عرض المخزون',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 5,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 170,
                'name' => 'adjust_inventory_stock',
                'slug' => 'adjust_inventory_stock',
                'description' => 'تعديل كميات المخزون',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 6,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 171,
                'name' => 'transfer_inventory_stock',
                'slug' => 'transfer_inventory_stock',
                'description' => 'نقل المخزون بين المستودعات',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 7,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 172,
                'name' => 'إدارة أوامر الشراء',
                'slug' => 'manage_purchase_orders',
                'description' => 'إدارة كاملة لأوامر الشراء',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 18,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 173,
                'name' => 'view_purchase_orders',
                'slug' => 'view_purchase_orders',
                'description' => 'عرض أوامر الشراء',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 8,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 174,
                'name' => 'create_purchase_orders',
                'slug' => 'create_purchase_orders',
                'description' => 'إنشاء أمر شراء جديد',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 9,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 175,
                'name' => 'تعديل أمر شراء',
                'slug' => 'edit_purchase_order',
                'description' => 'تعديل أمر شراء',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 19,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 176,
                'name' => 'حذف أمر شراء',
                'slug' => 'delete_purchase_order',
                'description' => 'حذف أمر شراء',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 20,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 177,
                'name' => 'تأكيد أمر شراء',
                'slug' => 'confirm_purchase_order',
                'description' => 'تأكيد أمر شراء',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 21,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 178,
                'name' => 'استلام أمر شراء',
                'slug' => 'receive_purchase_order',
                'description' => 'استلام أمر شراء',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 22,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 179,
                'name' => 'إدارة حركات المخزون',
                'slug' => 'manage_inventory_transactions',
                'description' => 'إدارة كاملة لحركات المخزون',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 23,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 180,
                'name' => 'view_inventory_transactions',
                'slug' => 'view_inventory_transactions',
                'description' => 'عرض حركات المخزون',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 10,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 181,
                'name' => 'إدارة تقارير المخزون',
                'slug' => 'manage_inventory_reports',
                'description' => 'إدارة كاملة لتقارير المخزون',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 24,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 182,
                'name' => 'view_inventory_reports',
                'slug' => 'view_inventory_reports',
                'description' => 'عرض تقارير المخزون',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 11,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 183,
                'name' => 'تصدير تقارير المخزون',
                'slug' => 'export_inventory_reports',
                'description' => 'تصدير تقارير المخزون',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 25,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 21:02:00',
                'updated_at' => '2025-09-05 21:37:04',
                'deleted_at' => null,
            ],
            [
                'id' => 184,
                'name' => 'view_auto_purchase',
                'slug' => 'view-auto-purchase',
                'description' => 'عرض الشراء التلقائي',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 12,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 23:37:03',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 185,
                'name' => 'create_auto_purchase',
                'slug' => 'create-auto-purchase',
                'description' => 'إنشاء قاعدة شراء تلقائي جديدة',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 13,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 23:37:03',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 186,
                'name' => 'edit_auto_purchase',
                'slug' => 'edit-auto-purchase',
                'description' => 'تعديل قاعدة شراء تلقائي',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 14,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 23:37:03',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 187,
                'name' => 'delete_auto_purchase',
                'slug' => 'delete-auto-purchase',
                'description' => 'حذف قاعدة شراء تلقائي',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 15,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 23:37:03',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 188,
                'name' => 'run_auto_purchase_check',
                'slug' => 'run-auto-purchase-check',
                'description' => 'تشغيل فحص المخزون وإنشاء طلبات الشراء التلقائية',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 16,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 23:37:03',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 189,
                'name' => 'view_auto_purchase_history',
                'slug' => 'view-auto-purchase-history',
                'description' => 'عرض سجل طلبات الشراء التلقائية',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 17,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 23:37:03',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 190,
                'name' => 'view_auto_purchase_dashboard',
                'slug' => 'view-auto-purchase-dashboard',
                'description' => 'عرض لوحة معلومات الشراء التلقائي',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 18,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-04 23:37:03',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 193,
                'name' => 'create_warehouses',
                'slug' => 'create_warehouses',
                'description' => 'إنشاء مستودع جديد',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 19,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:15',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 194,
                'name' => 'edit_warehouses',
                'slug' => 'edit_warehouses',
                'description' => 'تعديل بيانات المستودع',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 20,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:15',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 195,
                'name' => 'delete_warehouses',
                'slug' => 'delete_warehouses',
                'description' => 'حذف مستودع',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 21,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:15',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 196,
                'name' => 'create_suppliers',
                'slug' => 'create_suppliers',
                'description' => 'إنشاء مورد جديد',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 22,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:16',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 197,
                'name' => 'edit_suppliers',
                'slug' => 'edit_suppliers',
                'description' => 'تعديل بيانات المورد',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 23,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:16',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 198,
                'name' => 'delete_suppliers',
                'slug' => 'delete_suppliers',
                'description' => 'حذف مورد',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 24,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:16',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 199,
                'name' => 'view_supplier_evaluations',
                'slug' => 'view_supplier_evaluations',
                'description' => 'عرض تقييمات الموردين',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 25,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:16',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 200,
                'name' => 'create_supplier_evaluations',
                'slug' => 'create_supplier_evaluations',
                'description' => 'إنشاء تقييم مورد جديد',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 26,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:16',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 201,
                'name' => 'edit_supplier_evaluations',
                'slug' => 'edit_supplier_evaluations',
                'description' => 'تعديل تقييم مورد',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 27,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:16',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 202,
                'name' => 'delete_supplier_evaluations',
                'slug' => 'delete_supplier_evaluations',
                'description' => 'حذف تقييم مورد',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 28,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:16',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 203,
                'name' => 'create_inventory_categories',
                'slug' => 'create_inventory_categories',
                'description' => 'إنشاء تصنيف مخزون جديد',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 29,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:17',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 204,
                'name' => 'edit_inventory_categories',
                'slug' => 'edit_inventory_categories',
                'description' => 'تعديل تصنيف مخزون',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 30,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:17',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 205,
                'name' => 'delete_inventory_categories',
                'slug' => 'delete_inventory_categories',
                'description' => 'حذف تصنيف مخزون',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 31,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:17',
                'updated_at' => '2025-09-05 21:37:05',
                'deleted_at' => null,
            ],
            [
                'id' => 206,
                'name' => 'create_inventory_items',
                'slug' => 'create_inventory_items',
                'description' => 'إنشاء عنصر مخزون جديد',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 32,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:18',
                'updated_at' => '2025-09-05 21:37:06',
                'deleted_at' => null,
            ],
            [
                'id' => 207,
                'name' => 'edit_inventory_items',
                'slug' => 'edit_inventory_items',
                'description' => 'تعديل عنصر مخزون',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 33,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:18',
                'updated_at' => '2025-09-05 21:37:06',
                'deleted_at' => null,
            ],
            [
                'id' => 208,
                'name' => 'delete_inventory_items',
                'slug' => 'delete_inventory_items',
                'description' => 'حذف عنصر مخزون',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 34,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:18',
                'updated_at' => '2025-09-05 21:37:06',
                'deleted_at' => null,
            ],
            [
                'id' => 209,
                'name' => 'view_inventory_batches',
                'slug' => 'view_inventory_batches',
                'description' => 'عرض دفعات المخزون',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 35,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:18',
                'updated_at' => '2025-09-05 21:37:06',
                'deleted_at' => null,
            ],
            [
                'id' => 210,
                'name' => 'create_inventory_batches',
                'slug' => 'create_inventory_batches',
                'description' => 'إنشاء دفعة مخزون جديدة',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 36,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:18',
                'updated_at' => '2025-09-05 21:37:06',
                'deleted_at' => null,
            ],
            [
                'id' => 211,
                'name' => 'edit_inventory_batches',
                'slug' => 'edit_inventory_batches',
                'description' => 'تعديل دفعة مخزون',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 37,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:18',
                'updated_at' => '2025-09-05 21:37:06',
                'deleted_at' => null,
            ],
            [
                'id' => 212,
                'name' => 'delete_inventory_batches',
                'slug' => 'delete_inventory_batches',
                'description' => 'حذف دفعة مخزون',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 38,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:18',
                'updated_at' => '2025-09-05 21:37:06',
                'deleted_at' => null,
            ],
            [
                'id' => 213,
                'name' => 'view_inventory_serials',
                'slug' => 'view_inventory_serials',
                'description' => 'عرض الأرقام التسلسلية للمخزون',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 39,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:18',
                'updated_at' => '2025-09-05 21:37:06',
                'deleted_at' => null,
            ],
            [
                'id' => 214,
                'name' => 'create_inventory_serials',
                'slug' => 'create_inventory_serials',
                'description' => 'إنشاء رقم تسلسلي جديد',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 40,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:18',
                'updated_at' => '2025-09-05 21:37:06',
                'deleted_at' => null,
            ],
            [
                'id' => 215,
                'name' => 'edit_inventory_serials',
                'slug' => 'edit_inventory_serials',
                'description' => 'تعديل رقم تسلسلي',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 41,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:18',
                'updated_at' => '2025-09-05 21:37:06',
                'deleted_at' => null,
            ],
            [
                'id' => 216,
                'name' => 'delete_inventory_serials',
                'slug' => 'delete_inventory_serials',
                'description' => 'حذف رقم تسلسلي',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 42,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:18',
                'updated_at' => '2025-09-05 21:37:06',
                'deleted_at' => null,
            ],
            [
                'id' => 217,
                'name' => 'edit_purchase_orders',
                'slug' => 'edit_purchase_orders',
                'description' => 'تعديل أمر شراء',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 43,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:19',
                'updated_at' => '2025-09-05 21:37:06',
                'deleted_at' => null,
            ],
            [
                'id' => 218,
                'name' => 'delete_purchase_orders',
                'slug' => 'delete_purchase_orders',
                'description' => 'حذف أمر شراء',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 44,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:19',
                'updated_at' => '2025-09-05 21:37:06',
                'deleted_at' => null,
            ],
            [
                'id' => 219,
                'name' => 'approve_purchase_orders',
                'slug' => 'approve_purchase_orders',
                'description' => 'اعتماد أمر شراء',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 45,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:19',
                'updated_at' => '2025-09-05 21:37:07',
                'deleted_at' => null,
            ],
            [
                'id' => 220,
                'name' => 'receive_purchase_orders',
                'slug' => 'receive_purchase_orders',
                'description' => 'استلام أمر شراء',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 46,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:19',
                'updated_at' => '2025-09-05 21:37:07',
                'deleted_at' => null,
            ],
            [
                'id' => 221,
                'name' => 'cancel_purchase_orders',
                'slug' => 'cancel_purchase_orders',
                'description' => 'إلغاء أمر شراء',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 47,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:19',
                'updated_at' => '2025-09-05 21:37:07',
                'deleted_at' => null,
            ],
            [
                'id' => 222,
                'name' => 'view_inventory_valuation',
                'slug' => 'view_inventory_valuation',
                'description' => 'عرض تقييم المخزون',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 48,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:20',
                'updated_at' => '2025-09-05 21:37:07',
                'deleted_at' => null,
            ],
            [
                'id' => 223,
                'name' => 'create_inventory_valuation',
                'slug' => 'create_inventory_valuation',
                'description' => 'إنشاء تقييم مخزون جديد',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 49,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:20',
                'updated_at' => '2025-09-05 21:37:07',
                'deleted_at' => null,
            ],
            [
                'id' => 224,
                'name' => 'edit_inventory_valuation',
                'slug' => 'edit_inventory_valuation',
                'description' => 'تعديل تقييم مخزون',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 50,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:20',
                'updated_at' => '2025-09-05 21:37:07',
                'deleted_at' => null,
            ],
            [
                'id' => 225,
                'name' => 'delete_inventory_valuation',
                'slug' => 'delete_inventory_valuation',
                'description' => 'حذف تقييم مخزون',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 51,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:20',
                'updated_at' => '2025-09-05 21:37:07',
                'deleted_at' => null,
            ],
            [
                'id' => 226,
                'name' => 'view_inventory_valuation_history',
                'slug' => 'view_inventory_valuation_history',
                'description' => 'عرض سجل تقييم المخزون',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 52,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:20',
                'updated_at' => '2025-09-05 21:37:07',
                'deleted_at' => null,
            ],
            [
                'id' => 227,
                'name' => 'export_inventory_valuation',
                'slug' => 'export_inventory_valuation',
                'description' => 'تصدير تقييم المخزون',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 53,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:20',
                'updated_at' => '2025-09-05 21:37:07',
                'deleted_at' => null,
            ],
            [
                'id' => 228,
                'name' => 'view_inventory_barcodes',
                'slug' => 'view_inventory_barcodes',
                'description' => 'عرض الباركود',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 54,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:20',
                'updated_at' => '2025-09-05 21:37:07',
                'deleted_at' => null,
            ],
            [
                'id' => 229,
                'name' => 'generate_inventory_barcode',
                'slug' => 'generate_inventory_barcode',
                'description' => 'إنشاء باركود جديد',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 55,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:20',
                'updated_at' => '2025-09-05 21:37:07',
                'deleted_at' => null,
            ],
            [
                'id' => 230,
                'name' => 'print_inventory_barcode',
                'slug' => 'print_inventory_barcode',
                'description' => 'طباعة باركود',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 56,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:20',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 231,
                'name' => 'scan_inventory_barcode',
                'slug' => 'scan_inventory_barcode',
                'description' => 'مسح باركود',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 57,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:20',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 232,
                'name' => 'create_transaction_from_barcode',
                'slug' => 'create_transaction_from_barcode',
                'description' => 'إنشاء معاملة من الباركود',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 58,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:20',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 233,
                'name' => 'view_auto_purchase_analytics',
                'slug' => 'view_auto_purchase_analytics',
                'description' => 'عرض تحليلات الشراء التلقائي',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 59,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:20',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 234,
                'name' => 'view_auto_purchase_forecast',
                'slug' => 'view_auto_purchase_forecast',
                'description' => 'عرض توقعات الشراء',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 60,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:20',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 235,
                'name' => 'view_auto_purchase_performance',
                'slug' => 'view_auto_purchase_performance',
                'description' => 'عرض أداء قواعد الشراء',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 61,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:20',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 236,
                'name' => 'view_auto_purchase_recommendations',
                'slug' => 'view_auto_purchase_recommendations',
                'description' => 'عرض توصيات الشراء',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 62,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:20',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 237,
                'name' => 'apply_auto_purchase_recommendations',
                'slug' => 'apply_auto_purchase_recommendations',
                'description' => 'تطبيق توصيات الشراء',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 63,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:20',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 238,
                'name' => 'create_auto_purchase_rule',
                'slug' => 'create_auto_purchase_rule',
                'description' => 'إنشاء قاعدة شراء تلقائي',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 64,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 15:30:20',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 239,
                'name' => 'view_smart_recommendations',
                'slug' => 'view-smart-recommendations',
                'description' => 'عرض التوصيات الذكية للشراء التلقائي',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 65,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 17:28:19',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 240,
                'name' => 'apply_smart_recommendations',
                'slug' => 'apply-smart-recommendations',
                'description' => 'تطبيق التوصيات الذكية على قواعد الشراء التلقائي',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 66,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 17:28:20',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 241,
                'name' => 'apply_seasonal_adjustments',
                'slug' => 'apply-seasonal-adjustments',
                'description' => 'تطبيق التعديلات الموسمية على قواعد الشراء التلقائي',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 67,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 17:28:20',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 242,
                'name' => 'create_recommended_rules',
                'slug' => 'create-recommended-rules',
                'description' => 'إنشاء قواعد شراء تلقائي جديدة من التوصيات',
                'group' => 'المخزون',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 68,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 17:28:20',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 243,
                'name' => 'view_installation_projects',
                'slug' => 'view-installation-projects',
                'description' => 'عرض مشاريع التركيب',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:18',
                'updated_at' => '2025-09-06 20:33:38',
                'deleted_at' => null,
            ],
            [
                'id' => 244,
                'name' => 'create_installation_project',
                'slug' => 'create-installation-project',
                'description' => 'إنشاء مشروع تركيب جديد',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:18',
                'updated_at' => '2025-09-06 20:33:38',
                'deleted_at' => null,
            ],
            [
                'id' => 245,
                'name' => 'edit_installation_project',
                'slug' => 'edit-installation-project',
                'description' => 'تعديل مشروع تركيب',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:18',
                'updated_at' => '2025-09-06 20:33:38',
                'deleted_at' => null,
            ],
            [
                'id' => 246,
                'name' => 'delete_installation_project',
                'slug' => 'delete-installation-project',
                'description' => 'حذف مشروع تركيب',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:18',
                'updated_at' => '2025-09-06 20:33:38',
                'deleted_at' => null,
            ],
            [
                'id' => 247,
                'name' => 'manage_installation_projects',
                'slug' => 'manage-installation-projects',
                'description' => 'إدارة مشاريع التركيب',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:18',
                'updated_at' => '2025-09-06 20:33:38',
                'deleted_at' => null,
            ],
            [
                'id' => 248,
                'name' => 'view_project_elevators',
                'slug' => 'view-project-elevators',
                'description' => 'عرض مصاعد المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:18',
                'updated_at' => '2025-09-06 20:33:38',
                'deleted_at' => null,
            ],
            [
                'id' => 249,
                'name' => 'add_project_elevator',
                'slug' => 'add-project-elevator',
                'description' => 'إضافة مصعد للمشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:18',
                'updated_at' => '2025-09-06 20:33:38',
                'deleted_at' => null,
            ],
            [
                'id' => 250,
                'name' => 'edit_project_elevator',
                'slug' => 'edit-project-elevator',
                'description' => 'تعديل مصعد المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:18',
                'updated_at' => '2025-09-06 20:33:38',
                'deleted_at' => null,
            ],
            [
                'id' => 251,
                'name' => 'delete_project_elevator',
                'slug' => 'delete-project-elevator',
                'description' => 'حذف مصعد المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:18',
                'updated_at' => '2025-09-06 20:33:38',
                'deleted_at' => null,
            ],
            [
                'id' => 252,
                'name' => 'view_project_phases',
                'slug' => 'view-project-phases',
                'description' => 'عرض مراحل المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:18',
                'updated_at' => '2025-09-06 20:33:38',
                'deleted_at' => null,
            ],
            [
                'id' => 253,
                'name' => 'add_project_phase',
                'slug' => 'add-project-phase',
                'description' => 'إضافة مرحلة للمشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:18',
                'updated_at' => '2025-09-06 20:33:38',
                'deleted_at' => null,
            ],
            [
                'id' => 254,
                'name' => 'edit_project_phase',
                'slug' => 'edit-project-phase',
                'description' => 'تعديل مرحلة المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:18',
                'updated_at' => '2025-09-06 20:33:38',
                'deleted_at' => null,
            ],
            [
                'id' => 255,
                'name' => 'delete_project_phase',
                'slug' => 'delete-project-phase',
                'description' => 'حذف مرحلة المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:18',
                'updated_at' => '2025-09-06 20:33:38',
                'deleted_at' => null,
            ],
            [
                'id' => 256,
                'name' => 'view_project_tasks',
                'slug' => 'view-project-tasks',
                'description' => 'عرض مهام المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:18',
                'updated_at' => '2025-09-06 20:33:39',
                'deleted_at' => null,
            ],
            [
                'id' => 257,
                'name' => 'add_project_task',
                'slug' => 'add-project-task',
                'description' => 'إضافة مهمة للمشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:18',
                'updated_at' => '2025-09-06 20:33:39',
                'deleted_at' => null,
            ],
            [
                'id' => 258,
                'name' => 'edit_project_task',
                'slug' => 'edit-project-task',
                'description' => 'تعديل مهمة المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:19',
                'updated_at' => '2025-09-06 20:33:39',
                'deleted_at' => null,
            ],
            [
                'id' => 259,
                'name' => 'delete_project_task',
                'slug' => 'delete-project-task',
                'description' => 'حذف مهمة المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:19',
                'updated_at' => '2025-09-06 20:33:39',
                'deleted_at' => null,
            ],
            [
                'id' => 260,
                'name' => 'assign_project_task',
                'slug' => 'assign-project-task',
                'description' => 'تعيين مهمة المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:19',
                'updated_at' => '2025-09-06 20:33:39',
                'deleted_at' => null,
            ],
            [
                'id' => 261,
                'name' => 'view_project_team',
                'slug' => 'view-project-team',
                'description' => 'عرض فريق المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:19',
                'updated_at' => '2025-09-06 20:33:39',
                'deleted_at' => null,
            ],
            [
                'id' => 262,
                'name' => 'add_project_team_member',
                'slug' => 'add-project-team-member',
                'description' => 'إضافة عضو لفريق المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:19',
                'updated_at' => '2025-09-06 20:33:39',
                'deleted_at' => null,
            ],
            [
                'id' => 263,
                'name' => 'edit_project_team_member',
                'slug' => 'edit-project-team-member',
                'description' => 'تعديل عضو فريق المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:19',
                'updated_at' => '2025-09-06 20:33:39',
                'deleted_at' => null,
            ],
            [
                'id' => 264,
                'name' => 'delete_project_team_member',
                'slug' => 'delete-project-team-member',
                'description' => 'حذف عضو فريق المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:19',
                'updated_at' => '2025-09-06 20:33:39',
                'deleted_at' => null,
            ],
            [
                'id' => 265,
                'name' => 'view_project_documents',
                'slug' => 'view-project-documents',
                'description' => 'عرض مستندات المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:19',
                'updated_at' => '2025-09-06 20:33:39',
                'deleted_at' => null,
            ],
            [
                'id' => 266,
                'name' => 'add_project_document',
                'slug' => 'add-project-document',
                'description' => 'إضافة مستند للمشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:19',
                'updated_at' => '2025-09-06 20:33:39',
                'deleted_at' => null,
            ],
            [
                'id' => 267,
                'name' => 'edit_project_document',
                'slug' => 'edit-project-document',
                'description' => 'تعديل مستند المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:19',
                'updated_at' => '2025-09-06 20:33:39',
                'deleted_at' => null,
            ],
            [
                'id' => 268,
                'name' => 'delete_project_document',
                'slug' => 'delete-project-document',
                'description' => 'حذف مستند المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:19',
                'updated_at' => '2025-09-06 20:33:39',
                'deleted_at' => null,
            ],
            [
                'id' => 269,
                'name' => 'view_project_expenses',
                'slug' => 'view-project-expenses',
                'description' => 'عرض مصاريف المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:19',
                'updated_at' => '2025-09-06 20:33:39',
                'deleted_at' => null,
            ],
            [
                'id' => 270,
                'name' => 'add_project_expense',
                'slug' => 'add-project-expense',
                'description' => 'إضافة مصروف للمشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:19',
                'updated_at' => '2025-09-06 20:33:39',
                'deleted_at' => null,
            ],
            [
                'id' => 271,
                'name' => 'edit_project_expense',
                'slug' => 'edit-project-expense',
                'description' => 'تعديل مصروف المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:20',
                'updated_at' => '2025-09-06 20:33:39',
                'deleted_at' => null,
            ],
            [
                'id' => 272,
                'name' => 'delete_project_expense',
                'slug' => 'delete-project-expense',
                'description' => 'حذف مصروف المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:20',
                'updated_at' => '2025-09-06 20:33:40',
                'deleted_at' => null,
            ],
            [
                'id' => 273,
                'name' => 'approve_project_expense',
                'slug' => 'approve-project-expense',
                'description' => 'اعتماد مصروف المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:20',
                'updated_at' => '2025-09-06 20:33:40',
                'deleted_at' => null,
            ],
            [
                'id' => 274,
                'name' => 'view_project_payments',
                'slug' => 'view-project-payments',
                'description' => 'عرض مدفوعات المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:20',
                'updated_at' => '2025-09-06 20:33:40',
                'deleted_at' => null,
            ],
            [
                'id' => 275,
                'name' => 'add_project_payment',
                'slug' => 'add-project-payment',
                'description' => 'إضافة دفعة للمشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:20',
                'updated_at' => '2025-09-06 20:33:40',
                'deleted_at' => null,
            ],
            [
                'id' => 276,
                'name' => 'edit_project_payment',
                'slug' => 'edit-project-payment',
                'description' => 'تعديل دفعة المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:20',
                'updated_at' => '2025-09-06 20:33:40',
                'deleted_at' => null,
            ],
            [
                'id' => 277,
                'name' => 'delete_project_payment',
                'slug' => 'delete-project-payment',
                'description' => 'حذف دفعة المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:20',
                'updated_at' => '2025-09-06 20:33:40',
                'deleted_at' => null,
            ],
            [
                'id' => 278,
                'name' => 'view_project_issues',
                'slug' => 'view-project-issues',
                'description' => 'عرض مشكلات المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:21',
                'updated_at' => '2025-09-06 20:33:40',
                'deleted_at' => null,
            ],
            [
                'id' => 279,
                'name' => 'add_project_issue',
                'slug' => 'add-project-issue',
                'description' => 'إضافة مشكلة للمشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:21',
                'updated_at' => '2025-09-06 20:33:40',
                'deleted_at' => null,
            ],
            [
                'id' => 280,
                'name' => 'edit_project_issue',
                'slug' => 'edit-project-issue',
                'description' => 'تعديل مشكلة المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:21',
                'updated_at' => '2025-09-06 20:33:40',
                'deleted_at' => null,
            ],
            [
                'id' => 281,
                'name' => 'delete_project_issue',
                'slug' => 'delete-project-issue',
                'description' => 'حذف مشكلة المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:21',
                'updated_at' => '2025-09-06 20:33:40',
                'deleted_at' => null,
            ],
            [
                'id' => 282,
                'name' => 'resolve_project_issue',
                'slug' => 'resolve-project-issue',
                'description' => 'حل مشكلة المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:21',
                'updated_at' => '2025-09-06 20:33:40',
                'deleted_at' => null,
            ],
            [
                'id' => 283,
                'name' => 'view_project_milestones',
                'slug' => 'view-project-milestones',
                'description' => 'عرض معالم المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:21',
                'updated_at' => '2025-09-06 20:33:40',
                'deleted_at' => null,
            ],
            [
                'id' => 284,
                'name' => 'add_project_milestone',
                'slug' => 'add-project-milestone',
                'description' => 'إضافة معلم للمشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:21',
                'updated_at' => '2025-09-06 20:33:40',
                'deleted_at' => null,
            ],
            [
                'id' => 285,
                'name' => 'edit_project_milestone',
                'slug' => 'edit-project-milestone',
                'description' => 'تعديل معلم المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:21',
                'updated_at' => '2025-09-06 20:33:40',
                'deleted_at' => null,
            ],
            [
                'id' => 286,
                'name' => 'delete_project_milestone',
                'slug' => 'delete-project-milestone',
                'description' => 'حذف معلم المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:21',
                'updated_at' => '2025-09-06 20:33:40',
                'deleted_at' => null,
            ],
            [
                'id' => 287,
                'name' => 'complete_project_milestone',
                'slug' => 'complete-project-milestone',
                'description' => 'إكمال معلم المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:21',
                'updated_at' => '2025-09-06 20:33:40',
                'deleted_at' => null,
            ],
            [
                'id' => 288,
                'name' => 'view_project_checklists',
                'slug' => 'view-project-checklists',
                'description' => 'عرض قوائم فحص المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:21',
                'updated_at' => '2025-09-06 20:33:41',
                'deleted_at' => null,
            ],
            [
                'id' => 289,
                'name' => 'add_project_checklist',
                'slug' => 'add-project-checklist',
                'description' => 'إضافة قائمة فحص للمشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:21',
                'updated_at' => '2025-09-06 20:33:41',
                'deleted_at' => null,
            ],
            [
                'id' => 290,
                'name' => 'edit_project_checklist',
                'slug' => 'edit-project-checklist',
                'description' => 'تعديل قائمة فحص المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:21',
                'updated_at' => '2025-09-06 20:33:41',
                'deleted_at' => null,
            ],
            [
                'id' => 291,
                'name' => 'delete_project_checklist',
                'slug' => 'delete-project-checklist',
                'description' => 'حذف قائمة فحص المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:21',
                'updated_at' => '2025-09-06 20:33:41',
                'deleted_at' => null,
            ],
            [
                'id' => 292,
                'name' => 'complete_project_checklist',
                'slug' => 'complete-project-checklist',
                'description' => 'إكمال قائمة فحص المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 18:14:21',
                'updated_at' => '2025-09-06 20:33:41',
                'deleted_at' => null,
            ],
            [
                'id' => 293,
                'name' => 'View employees',
                'slug' => 'view_employees',
                'description' => 'صلاحية View employees',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.293,
                'type' => 'action',
                'resource' => 'employees',
                'order' => 1,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:37',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 294,
                'name' => 'Create employee',
                'slug' => 'create_employee',
                'description' => 'صلاحية Create employee',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.294,
                'type' => 'action',
                'resource' => 'employee',
                'order' => 2,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:37',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 295,
                'name' => 'Edit employee',
                'slug' => 'edit_employee',
                'description' => 'صلاحية Edit employee',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.295,
                'type' => 'action',
                'resource' => 'employee',
                'order' => 3,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:37',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 296,
                'name' => 'Delete employee',
                'slug' => 'delete_employee',
                'description' => 'صلاحية Delete employee',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.296,
                'type' => 'action',
                'resource' => 'employee',
                'order' => 4,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:37',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 297,
                'name' => 'Manage employees',
                'slug' => 'manage_employees',
                'description' => 'صلاحية Manage employees',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.297,
                'type' => 'action',
                'resource' => 'employees',
                'order' => 5,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:37',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 298,
                'name' => 'View departments',
                'slug' => 'view_departments',
                'description' => 'صلاحية View departments',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.298,
                'type' => 'action',
                'resource' => 'departments',
                'order' => 6,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:38',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 299,
                'name' => 'Create department',
                'slug' => 'create_department',
                'description' => 'صلاحية Create department',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.299,
                'type' => 'action',
                'resource' => 'department',
                'order' => 7,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:38',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 300,
                'name' => 'Edit department',
                'slug' => 'edit_department',
                'description' => 'صلاحية Edit department',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.300,
                'type' => 'action',
                'resource' => 'department',
                'order' => 8,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:38',
                'updated_at' => '2025-09-05 21:37:09',
                'deleted_at' => null,
            ],
            [
                'id' => 301,
                'name' => 'Delete department',
                'slug' => 'delete_department',
                'description' => 'صلاحية Delete department',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.301,
                'type' => 'action',
                'resource' => 'department',
                'order' => 9,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:38',
                'updated_at' => '2025-09-05 21:37:09',
                'deleted_at' => null,
            ],
            [
                'id' => 302,
                'name' => 'Manage departments',
                'slug' => 'manage_departments',
                'description' => 'صلاحية Manage departments',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.302,
                'type' => 'action',
                'resource' => 'departments',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:39',
                'updated_at' => '2025-09-05 21:32:32',
                'deleted_at' => null,
            ],
            [
                'id' => 303,
                'name' => 'View attendance',
                'slug' => 'view_attendance',
                'description' => 'صلاحية View attendance',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.303,
                'type' => 'action',
                'resource' => 'attendance',
                'order' => 11,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:39',
                'updated_at' => '2025-09-05 21:37:09',
                'deleted_at' => null,
            ],
            [
                'id' => 304,
                'name' => 'Create attendance',
                'slug' => 'create_attendance',
                'description' => 'صلاحية Create attendance',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.304,
                'type' => 'action',
                'resource' => 'attendance',
                'order' => 12,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:39',
                'updated_at' => '2025-09-05 21:37:09',
                'deleted_at' => null,
            ],
            [
                'id' => 305,
                'name' => 'Edit attendance',
                'slug' => 'edit_attendance',
                'description' => 'صلاحية Edit attendance',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.305,
                'type' => 'action',
                'resource' => 'attendance',
                'order' => 13,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:40',
                'updated_at' => '2025-09-05 21:37:09',
                'deleted_at' => null,
            ],
            [
                'id' => 306,
                'name' => 'Delete attendance',
                'slug' => 'delete_attendance',
                'description' => 'صلاحية Delete attendance',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.306,
                'type' => 'action',
                'resource' => 'attendance',
                'order' => 14,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:40',
                'updated_at' => '2025-09-05 21:37:09',
                'deleted_at' => null,
            ],
            [
                'id' => 307,
                'name' => 'Manage attendance',
                'slug' => 'manage_attendance',
                'description' => 'صلاحية Manage attendance',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.307,
                'type' => 'action',
                'resource' => 'attendance',
                'order' => 15,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:40',
                'updated_at' => '2025-09-05 21:37:09',
                'deleted_at' => null,
            ],
            [
                'id' => 308,
                'name' => 'View leaves',
                'slug' => 'view_leaves',
                'description' => 'صلاحية View leaves',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.308,
                'type' => 'action',
                'resource' => 'leaves',
                'order' => 16,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:40',
                'updated_at' => '2025-09-05 21:37:09',
                'deleted_at' => null,
            ],
            [
                'id' => 309,
                'name' => 'Create leave',
                'slug' => 'create_leave',
                'description' => 'صلاحية Create leave',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.309,
                'type' => 'action',
                'resource' => 'leave',
                'order' => 17,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:40',
                'updated_at' => '2025-09-05 21:37:09',
                'deleted_at' => null,
            ],
            [
                'id' => 310,
                'name' => 'Edit leave',
                'slug' => 'edit_leave',
                'description' => 'صلاحية Edit leave',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.310,
                'type' => 'action',
                'resource' => 'leave',
                'order' => 18,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:40',
                'updated_at' => '2025-09-05 21:37:09',
                'deleted_at' => null,
            ],
            [
                'id' => 311,
                'name' => 'Delete leave',
                'slug' => 'delete_leave',
                'description' => 'صلاحية Delete leave',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.311,
                'type' => 'action',
                'resource' => 'leave',
                'order' => 19,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:40',
                'updated_at' => '2025-09-05 21:37:10',
                'deleted_at' => null,
            ],
            [
                'id' => 312,
                'name' => 'Approve leave',
                'slug' => 'approve_leave',
                'description' => 'صلاحية Approve leave',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.312,
                'type' => 'action',
                'resource' => 'leave',
                'order' => 20,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:41',
                'updated_at' => '2025-09-05 21:37:10',
                'deleted_at' => null,
            ],
            [
                'id' => 313,
                'name' => 'Reject leave',
                'slug' => 'reject_leave',
                'description' => 'صلاحية Reject leave',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.313,
                'type' => 'action',
                'resource' => 'leave',
                'order' => 21,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:41',
                'updated_at' => '2025-09-05 21:37:10',
                'deleted_at' => null,
            ],
            [
                'id' => 314,
                'name' => 'Manage leaves',
                'slug' => 'manage_leaves',
                'description' => 'صلاحية Manage leaves',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.314,
                'type' => 'action',
                'resource' => 'leaves',
                'order' => 22,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:41',
                'updated_at' => '2025-09-05 21:37:10',
                'deleted_at' => null,
            ],
            [
                'id' => 315,
                'name' => 'View leave types',
                'slug' => 'view_leave_types',
                'description' => 'صلاحية View leave types',
                'group' => 'users',
                'level' => 1,
                'path' => 1.315,
                'type' => 'action',
                'resource' => 'leave',
                'order' => 6,
                'is_active' => 1,
                'parent_id' => 1,
                'created_at' => '2025-09-05 21:14:41',
                'updated_at' => '2025-09-05 21:36:58',
                'deleted_at' => null,
            ],
            [
                'id' => 316,
                'name' => 'Create leave type',
                'slug' => 'create_leave_type',
                'description' => 'صلاحية Create leave type',
                'group' => 'users',
                'level' => 1,
                'path' => 1.316,
                'type' => 'action',
                'resource' => 'leave',
                'order' => 7,
                'is_active' => 1,
                'parent_id' => 1,
                'created_at' => '2025-09-05 21:14:41',
                'updated_at' => '2025-09-05 21:36:58',
                'deleted_at' => null,
            ],
            [
                'id' => 317,
                'name' => 'Edit leave type',
                'slug' => 'edit_leave_type',
                'description' => 'صلاحية Edit leave type',
                'group' => 'users',
                'level' => 1,
                'path' => 1.317,
                'type' => 'action',
                'resource' => 'leave',
                'order' => 8,
                'is_active' => 1,
                'parent_id' => 1,
                'created_at' => '2025-09-05 21:14:41',
                'updated_at' => '2025-09-05 21:36:58',
                'deleted_at' => null,
            ],
            [
                'id' => 318,
                'name' => 'Delete leave type',
                'slug' => 'delete_leave_type',
                'description' => 'صلاحية Delete leave type',
                'group' => 'users',
                'level' => 1,
                'path' => 1.318,
                'type' => 'action',
                'resource' => 'leave',
                'order' => 9,
                'is_active' => 1,
                'parent_id' => 1,
                'created_at' => '2025-09-05 21:14:41',
                'updated_at' => '2025-09-05 21:36:58',
                'deleted_at' => null,
            ],
            [
                'id' => 319,
                'name' => 'Manage leave types',
                'slug' => 'manage_leave_types',
                'description' => 'صلاحية Manage leave types',
                'group' => 'users',
                'level' => 1,
                'path' => 1.319,
                'type' => 'action',
                'resource' => 'leave',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 1,
                'created_at' => '2025-09-05 21:14:41',
                'updated_at' => '2025-09-05 21:14:41',
                'deleted_at' => null,
            ],
            [
                'id' => 320,
                'name' => 'View salaries',
                'slug' => 'view_salaries',
                'description' => 'صلاحية View salaries',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.320,
                'type' => 'action',
                'resource' => 'salaries',
                'order' => 23,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:41',
                'updated_at' => '2025-09-05 21:37:10',
                'deleted_at' => null,
            ],
            [
                'id' => 321,
                'name' => 'Create salary',
                'slug' => 'create_salary',
                'description' => 'صلاحية Create salary',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.321,
                'type' => 'action',
                'resource' => 'salary',
                'order' => 24,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:41',
                'updated_at' => '2025-09-05 21:37:10',
                'deleted_at' => null,
            ],
            [
                'id' => 322,
                'name' => 'Edit salary',
                'slug' => 'edit_salary',
                'description' => 'صلاحية Edit salary',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.322,
                'type' => 'action',
                'resource' => 'salary',
                'order' => 25,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:42',
                'updated_at' => '2025-09-05 21:37:10',
                'deleted_at' => null,
            ],
            [
                'id' => 323,
                'name' => 'Delete salary',
                'slug' => 'delete_salary',
                'description' => 'صلاحية Delete salary',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.323,
                'type' => 'action',
                'resource' => 'salary',
                'order' => 26,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:42',
                'updated_at' => '2025-09-05 21:37:10',
                'deleted_at' => null,
            ],
            [
                'id' => 324,
                'name' => 'Manage salaries',
                'slug' => 'manage_salaries',
                'description' => 'صلاحية Manage salaries',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.324,
                'type' => 'action',
                'resource' => 'salaries',
                'order' => 27,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:14:42',
                'updated_at' => '2025-09-05 21:37:10',
                'deleted_at' => null,
            ],
            [
                'id' => 325,
                'name' => 'View salary components',
                'slug' => 'view_salary_components',
                'description' => 'صلاحية View salary components',
                'group' => 'payments',
                'level' => 1,
                'path' => 51.325,
                'type' => 'action',
                'resource' => 'salary',
                'order' => 7,
                'is_active' => 1,
                'parent_id' => 51,
                'created_at' => '2025-09-05 21:14:42',
                'updated_at' => '2025-09-05 21:36:59',
                'deleted_at' => null,
            ],
            [
                'id' => 326,
                'name' => 'Create salary component',
                'slug' => 'create_salary_component',
                'description' => 'صلاحية Create salary component',
                'group' => 'payments',
                'level' => 1,
                'path' => 51.326,
                'type' => 'action',
                'resource' => 'salary',
                'order' => 8,
                'is_active' => 1,
                'parent_id' => 51,
                'created_at' => '2025-09-05 21:14:42',
                'updated_at' => '2025-09-05 21:37:00',
                'deleted_at' => null,
            ],
            [
                'id' => 327,
                'name' => 'Edit salary component',
                'slug' => 'edit_salary_component',
                'description' => 'صلاحية Edit salary component',
                'group' => 'payments',
                'level' => 1,
                'path' => 51.327,
                'type' => 'action',
                'resource' => 'salary',
                'order' => 9,
                'is_active' => 1,
                'parent_id' => 51,
                'created_at' => '2025-09-05 21:14:42',
                'updated_at' => '2025-09-05 21:37:00',
                'deleted_at' => null,
            ],
            [
                'id' => 328,
                'name' => 'Delete salary component',
                'slug' => 'delete_salary_component',
                'description' => 'صلاحية Delete salary component',
                'group' => 'payments',
                'level' => 1,
                'path' => 51.328,
                'type' => 'action',
                'resource' => 'salary',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 51,
                'created_at' => '2025-09-05 21:14:42',
                'updated_at' => '2025-09-05 21:14:42',
                'deleted_at' => null,
            ],
            [
                'id' => 329,
                'name' => 'Manage salary components',
                'slug' => 'manage_salary_components',
                'description' => 'صلاحية Manage salary components',
                'group' => 'payments',
                'level' => 1,
                'path' => 51.329,
                'type' => 'action',
                'resource' => 'salary',
                'order' => 11,
                'is_active' => 1,
                'parent_id' => 51,
                'created_at' => '2025-09-05 21:14:42',
                'updated_at' => '2025-09-05 21:37:00',
                'deleted_at' => null,
            ],
            [
                'id' => 330,
                'name' => 'إدارة الموارد البشرية',
                'slug' => 'manage_hrm',
                'description' => 'إدارة كاملة لنظام الموارد البشرية',
                'group' => 'hrm',
                'level' => 0,
                'path' => 330,
                'type' => 'group',
                'resource' => 'hrm',
                'order' => 24,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-05 21:32:32',
                'updated_at' => '2025-09-05 21:37:08',
                'deleted_at' => null,
            ],
            [
                'id' => 331,
                'name' => 'View payrolls',
                'slug' => 'view_payrolls',
                'description' => 'صلاحية View payrolls',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.331,
                'type' => 'action',
                'resource' => 'payrolls',
                'order' => 28,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:32:33',
                'updated_at' => '2025-09-05 21:37:10',
                'deleted_at' => null,
            ],
            [
                'id' => 332,
                'name' => 'Create payroll',
                'slug' => 'create_payroll',
                'description' => 'صلاحية Create payroll',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.332,
                'type' => 'action',
                'resource' => 'payroll',
                'order' => 29,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:32:33',
                'updated_at' => '2025-09-05 21:37:10',
                'deleted_at' => null,
            ],
            [
                'id' => 333,
                'name' => 'Edit payroll',
                'slug' => 'edit_payroll',
                'description' => 'صلاحية Edit payroll',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.333,
                'type' => 'action',
                'resource' => 'payroll',
                'order' => 30,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:32:33',
                'updated_at' => '2025-09-05 21:37:10',
                'deleted_at' => null,
            ],
            [
                'id' => 334,
                'name' => 'Delete payroll',
                'slug' => 'delete_payroll',
                'description' => 'صلاحية Delete payroll',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.334,
                'type' => 'action',
                'resource' => 'payroll',
                'order' => 31,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:32:34',
                'updated_at' => '2025-09-05 21:37:10',
                'deleted_at' => null,
            ],
            [
                'id' => 335,
                'name' => 'Manage payrolls',
                'slug' => 'manage_payrolls',
                'description' => 'صلاحية Manage payrolls',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.335,
                'type' => 'action',
                'resource' => 'payrolls',
                'order' => 32,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:32:34',
                'updated_at' => '2025-09-05 21:37:10',
                'deleted_at' => null,
            ],
            [
                'id' => 336,
                'name' => 'Generate payroll',
                'slug' => 'generate_payroll',
                'description' => 'صلاحية Generate payroll',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.336,
                'type' => 'action',
                'resource' => 'payroll',
                'order' => 33,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:32:34',
                'updated_at' => '2025-09-05 21:37:10',
                'deleted_at' => null,
            ],
            [
                'id' => 337,
                'name' => 'Approve payroll',
                'slug' => 'approve_payroll',
                'description' => 'صلاحية Approve payroll',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.337,
                'type' => 'action',
                'resource' => 'payroll',
                'order' => 34,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-05 21:32:34',
                'updated_at' => '2025-09-05 21:37:10',
                'deleted_at' => null,
            ],
            [
                'id' => 338,
                'name' => 'التقارير المالية للصيانة',
                'slug' => 'group_maintenance_financial',
                'description' => 'مجموعة صلاحيات التقارير المالية للصيانة',
                'group' => 'maintenance_financial',
                'level' => 0,
                'path' => 338,
                'type' => 'group',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:33:21',
                'updated_at' => '2025-09-06 04:33:21',
                'deleted_at' => null,
            ],
            [
                'id' => 339,
                'name' => 'إشعارات الصيانة',
                'slug' => 'group_maintenance_notifications',
                'description' => 'مجموعة صلاحيات إشعارات الصيانة',
                'group' => 'maintenance_notifications',
                'level' => 0,
                'path' => 339,
                'type' => 'group',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:33:21',
                'updated_at' => '2025-09-06 04:33:22',
                'deleted_at' => null,
            ],
            [
                'id' => 340,
                'name' => 'عرض التقارير المالية للصيانة',
                'slug' => 'view_financial_reports',
                'description' => 'عرض التقارير المالية للصيانة',
                'group' => 'maintenance_financial',
                'level' => 0,
                'path' => 340,
                'type' => 'view',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:33:22',
                'updated_at' => '2025-09-06 04:33:22',
                'deleted_at' => null,
            ],
            [
                'id' => 341,
                'name' => 'عرض تقارير أداء الفنيين',
                'slug' => 'view_technician_reports',
                'description' => 'عرض تقارير أداء الفنيين',
                'group' => 'maintenance_financial',
                'level' => 0,
                'path' => 341,
                'type' => 'view',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:33:22',
                'updated_at' => '2025-09-06 04:33:22',
                'deleted_at' => null,
            ],
            [
                'id' => 342,
                'name' => 'إنشاء فواتير من الصيانة',
                'slug' => 'create_invoices',
                'description' => 'إنشاء فواتير من سجلات الصيانة',
                'group' => 'maintenance_financial',
                'level' => 0,
                'path' => 342,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:33:22',
                'updated_at' => '2025-09-06 04:33:22',
                'deleted_at' => null,
            ],
            [
                'id' => 343,
                'name' => 'تصدير التقارير المالية',
                'slug' => 'export_financial_reports',
                'description' => 'تصدير التقارير المالية للصيانة',
                'group' => 'maintenance_financial',
                'level' => 0,
                'path' => 343,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:33:22',
                'updated_at' => '2025-09-06 04:33:22',
                'deleted_at' => null,
            ],
            [
                'id' => 344,
                'name' => 'إدارة إشعارات الصيانة',
                'slug' => 'manage_maintenance_notifications',
                'description' => 'إدارة إشعارات الصيانة',
                'group' => 'maintenance_notifications',
                'level' => 0,
                'path' => 344,
                'type' => 'crud',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:33:22',
                'updated_at' => '2025-09-06 04:33:22',
                'deleted_at' => null,
            ],
            [
                'id' => 345,
                'name' => 'عرض إشعارات الصيانة',
                'slug' => 'view_maintenance_notifications',
                'description' => 'عرض إشعارات الصيانة',
                'group' => 'maintenance_notifications',
                'level' => 0,
                'path' => 345,
                'type' => 'view',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:33:23',
                'updated_at' => '2025-09-06 04:33:23',
                'deleted_at' => null,
            ],
            [
                'id' => 346,
                'name' => 'إرسال إشعارات الصيانة',
                'slug' => 'send_maintenance_notifications',
                'description' => 'إرسال إشعارات الصيانة',
                'group' => 'maintenance_notifications',
                'level' => 0,
                'path' => 346,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:33:23',
                'updated_at' => '2025-09-06 04:33:23',
                'deleted_at' => null,
            ],
            [
                'id' => 347,
                'name' => 'تعديل إشعارات الصيانة',
                'slug' => 'edit_maintenance_notifications',
                'description' => 'تعديل إشعارات الصيانة',
                'group' => 'maintenance_notifications',
                'level' => 0,
                'path' => 347,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:33:23',
                'updated_at' => '2025-09-06 04:33:23',
                'deleted_at' => null,
            ],
            [
                'id' => 348,
                'name' => 'حذف إشعارات الصيانة',
                'slug' => 'delete_maintenance_notifications',
                'description' => 'حذف إشعارات الصيانة',
                'group' => 'maintenance_notifications',
                'level' => 0,
                'path' => 348,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:33:23',
                'updated_at' => '2025-09-06 04:33:23',
                'deleted_at' => null,
            ],
            [
                'id' => 349,
                'name' => 'التقارير المالية للصيانة',
                'slug' => 'group_maintenance_financial_reports',
                'description' => 'مجموعة صلاحيات التقارير المالية للصيانة',
                'group' => 'maintenance_financial_reports',
                'level' => 0,
                'path' => 349,
                'type' => 'group',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:51:34',
                'updated_at' => '2025-09-06 04:51:34',
                'deleted_at' => null,
            ],
            [
                'id' => 350,
                'name' => 'فواتير الصيانة',
                'slug' => 'group_maintenance_invoices',
                'description' => 'مجموعة صلاحيات فواتير الصيانة',
                'group' => 'maintenance_invoices',
                'level' => 0,
                'path' => 350,
                'type' => 'group',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:51:34',
                'updated_at' => '2025-09-06 04:51:34',
                'deleted_at' => null,
            ],
            [
                'id' => 351,
                'name' => 'عرض التقارير المالية',
                'slug' => 'view_maintenance_financial_reports',
                'description' => 'عرض التقارير المالية للصيانة',
                'group' => 'maintenance_financial_reports',
                'level' => 0,
                'path' => 351,
                'type' => 'view',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:51:34',
                'updated_at' => '2025-09-06 04:51:35',
                'deleted_at' => null,
            ],
            [
                'id' => 352,
                'name' => 'تصدير التقارير المالية',
                'slug' => 'export_maintenance_financial_reports',
                'description' => 'تصدير التقارير المالية للصيانة',
                'group' => 'maintenance_financial_reports',
                'level' => 0,
                'path' => 352,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:51:35',
                'updated_at' => '2025-09-06 04:51:35',
                'deleted_at' => null,
            ],
            [
                'id' => 353,
                'name' => 'إدارة التقارير المالية',
                'slug' => 'manage_maintenance_financial_reports',
                'description' => 'إدارة التقارير المالية للصيانة',
                'group' => 'maintenance_financial_reports',
                'level' => 0,
                'path' => 353,
                'type' => 'crud',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:51:35',
                'updated_at' => '2025-09-06 04:51:35',
                'deleted_at' => null,
            ],
            [
                'id' => 354,
                'name' => 'عرض فواتير الصيانة',
                'slug' => 'view_maintenance_invoices',
                'description' => 'عرض فواتير الصيانة',
                'group' => 'maintenance_invoices',
                'level' => 0,
                'path' => 354,
                'type' => 'view',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:51:35',
                'updated_at' => '2025-09-06 04:51:35',
                'deleted_at' => null,
            ],
            [
                'id' => 355,
                'name' => 'إنشاء فواتير الصيانة',
                'slug' => 'create_maintenance_invoices',
                'description' => 'إنشاء فواتير من سجلات الصيانة',
                'group' => 'maintenance_invoices',
                'level' => 0,
                'path' => 355,
                'type' => 'create',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:51:35',
                'updated_at' => '2025-09-06 04:51:35',
                'deleted_at' => null,
            ],
            [
                'id' => 356,
                'name' => 'تعديل فواتير الصيانة',
                'slug' => 'edit_maintenance_invoices',
                'description' => 'تعديل فواتير الصيانة',
                'group' => 'maintenance_invoices',
                'level' => 0,
                'path' => 356,
                'type' => 'edit',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:51:35',
                'updated_at' => '2025-09-06 04:51:36',
                'deleted_at' => null,
            ],
            [
                'id' => 357,
                'name' => 'حذف فواتير الصيانة',
                'slug' => 'delete_maintenance_invoices',
                'description' => 'حذف فواتير الصيانة',
                'group' => 'maintenance_invoices',
                'level' => 0,
                'path' => 357,
                'type' => 'delete',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:51:36',
                'updated_at' => '2025-09-06 04:51:36',
                'deleted_at' => null,
            ],
            [
                'id' => 358,
                'name' => 'إدارة فواتير الصيانة',
                'slug' => 'manage_maintenance_invoices',
                'description' => 'إدارة فواتير الصيانة',
                'group' => 'maintenance_invoices',
                'level' => 0,
                'path' => 358,
                'type' => 'crud',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:51:36',
                'updated_at' => '2025-09-06 04:51:36',
                'deleted_at' => null,
            ],
            [
                'id' => 359,
                'name' => 'إنشاء إشعارات الصيانة',
                'slug' => 'create_maintenance_notifications',
                'description' => 'إنشاء إشعارات الصيانة',
                'group' => 'maintenance_notifications',
                'level' => 0,
                'path' => 359,
                'type' => 'create',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-06 04:51:36',
                'updated_at' => '2025-09-06 04:51:36',
                'deleted_at' => null,
            ],
            [
                'id' => 360,
                'name' => 'View bonuses',
                'slug' => 'view_bonuses',
                'description' => 'صلاحية View bonuses',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.360,
                'type' => 'action',
                'resource' => 'bonuses',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:02',
                'updated_at' => '2025-09-06 15:36:03',
                'deleted_at' => null,
            ],
            [
                'id' => 361,
                'name' => 'Create bonus',
                'slug' => 'create_bonus',
                'description' => 'صلاحية Create bonus',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.361,
                'type' => 'action',
                'resource' => 'bonus',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:03',
                'updated_at' => '2025-09-06 15:36:03',
                'deleted_at' => null,
            ],
            [
                'id' => 362,
                'name' => 'Edit bonus',
                'slug' => 'edit_bonus',
                'description' => 'صلاحية Edit bonus',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.362,
                'type' => 'action',
                'resource' => 'bonus',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:03',
                'updated_at' => '2025-09-06 15:36:03',
                'deleted_at' => null,
            ],
            [
                'id' => 363,
                'name' => 'Delete bonus',
                'slug' => 'delete_bonus',
                'description' => 'صلاحية Delete bonus',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.363,
                'type' => 'action',
                'resource' => 'bonus',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:03',
                'updated_at' => '2025-09-06 15:36:03',
                'deleted_at' => null,
            ],
            [
                'id' => 364,
                'name' => 'Approve bonus',
                'slug' => 'approve_bonus',
                'description' => 'صلاحية Approve bonus',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.364,
                'type' => 'action',
                'resource' => 'bonus',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:03',
                'updated_at' => '2025-09-06 15:36:03',
                'deleted_at' => null,
            ],
            [
                'id' => 365,
                'name' => 'Reject bonus',
                'slug' => 'reject_bonus',
                'description' => 'صلاحية Reject bonus',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.365,
                'type' => 'action',
                'resource' => 'bonus',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:03',
                'updated_at' => '2025-09-06 15:36:03',
                'deleted_at' => null,
            ],
            [
                'id' => 366,
                'name' => 'Mark bonus as paid',
                'slug' => 'mark_bonus_as_paid',
                'description' => 'صلاحية Mark bonus as paid',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.366,
                'type' => 'action',
                'resource' => 'bonus',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:03',
                'updated_at' => '2025-09-06 15:36:04',
                'deleted_at' => null,
            ],
            [
                'id' => 367,
                'name' => 'Manage bonuses',
                'slug' => 'manage_bonuses',
                'description' => 'صلاحية Manage bonuses',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.367,
                'type' => 'action',
                'resource' => 'bonuses',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:04',
                'updated_at' => '2025-09-06 15:36:04',
                'deleted_at' => null,
            ],
            [
                'id' => 368,
                'name' => 'View loans',
                'slug' => 'view_loans',
                'description' => 'صلاحية View loans',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.368,
                'type' => 'action',
                'resource' => 'loans',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:04',
                'updated_at' => '2025-09-06 15:36:04',
                'deleted_at' => null,
            ],
            [
                'id' => 369,
                'name' => 'Create loan',
                'slug' => 'create_loan',
                'description' => 'صلاحية Create loan',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.369,
                'type' => 'action',
                'resource' => 'loan',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:04',
                'updated_at' => '2025-09-06 15:36:04',
                'deleted_at' => null,
            ],
            [
                'id' => 370,
                'name' => 'Edit loan',
                'slug' => 'edit_loan',
                'description' => 'صلاحية Edit loan',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.370,
                'type' => 'action',
                'resource' => 'loan',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:04',
                'updated_at' => '2025-09-06 15:36:04',
                'deleted_at' => null,
            ],
            [
                'id' => 371,
                'name' => 'Delete loan',
                'slug' => 'delete_loan',
                'description' => 'صلاحية Delete loan',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.371,
                'type' => 'action',
                'resource' => 'loan',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:04',
                'updated_at' => '2025-09-06 15:36:04',
                'deleted_at' => null,
            ],
            [
                'id' => 372,
                'name' => 'Approve loan',
                'slug' => 'approve_loan',
                'description' => 'صلاحية Approve loan',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.372,
                'type' => 'action',
                'resource' => 'loan',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:04',
                'updated_at' => '2025-09-06 15:36:04',
                'deleted_at' => null,
            ],
            [
                'id' => 373,
                'name' => 'Reject loan',
                'slug' => 'reject_loan',
                'description' => 'صلاحية Reject loan',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.373,
                'type' => 'action',
                'resource' => 'loan',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:04',
                'updated_at' => '2025-09-06 15:36:04',
                'deleted_at' => null,
            ],
            [
                'id' => 374,
                'name' => 'Activate loan',
                'slug' => 'activate_loan',
                'description' => 'صلاحية Activate loan',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.374,
                'type' => 'action',
                'resource' => 'loan',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:04',
                'updated_at' => '2025-09-06 15:36:04',
                'deleted_at' => null,
            ],
            [
                'id' => 375,
                'name' => 'Complete loan',
                'slug' => 'complete_loan',
                'description' => 'صلاحية Complete loan',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.375,
                'type' => 'action',
                'resource' => 'loan',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:04',
                'updated_at' => '2025-09-06 15:36:05',
                'deleted_at' => null,
            ],
            [
                'id' => 376,
                'name' => 'Cancel loan',
                'slug' => 'cancel_loan',
                'description' => 'صلاحية Cancel loan',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.376,
                'type' => 'action',
                'resource' => 'loan',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:05',
                'updated_at' => '2025-09-06 15:36:05',
                'deleted_at' => null,
            ],
            [
                'id' => 377,
                'name' => 'Manage loans',
                'slug' => 'manage_loans',
                'description' => 'صلاحية Manage loans',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.377,
                'type' => 'action',
                'resource' => 'loans',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:05',
                'updated_at' => '2025-09-06 15:36:05',
                'deleted_at' => null,
            ],
            [
                'id' => 378,
                'name' => 'View loan installments',
                'slug' => 'view_loan_installments',
                'description' => 'صلاحية View loan installments',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.378,
                'type' => 'action',
                'resource' => 'loan',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:05',
                'updated_at' => '2025-09-06 15:36:05',
                'deleted_at' => null,
            ],
            [
                'id' => 379,
                'name' => 'Edit loan installment',
                'slug' => 'edit_loan_installment',
                'description' => 'صلاحية Edit loan installment',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.379,
                'type' => 'action',
                'resource' => 'loan',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:05',
                'updated_at' => '2025-09-06 15:36:05',
                'deleted_at' => null,
            ],
            [
                'id' => 380,
                'name' => 'Mark loan installment as paid',
                'slug' => 'mark_loan_installment_as_paid',
                'description' => 'صلاحية Mark loan installment as paid',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.380,
                'type' => 'action',
                'resource' => 'loan',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:05',
                'updated_at' => '2025-09-06 15:36:05',
                'deleted_at' => null,
            ],
            [
                'id' => 381,
                'name' => 'Mark loan installment as overdue',
                'slug' => 'mark_loan_installment_as_overdue',
                'description' => 'صلاحية Mark loan installment as overdue',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.381,
                'type' => 'action',
                'resource' => 'loan',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:05',
                'updated_at' => '2025-09-06 15:36:06',
                'deleted_at' => null,
            ],
            [
                'id' => 382,
                'name' => 'Cancel loan installment',
                'slug' => 'cancel_loan_installment',
                'description' => 'صلاحية Cancel loan installment',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.382,
                'type' => 'action',
                'resource' => 'loan',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:06',
                'updated_at' => '2025-09-06 15:36:06',
                'deleted_at' => null,
            ],
            [
                'id' => 383,
                'name' => 'Manage loan installments',
                'slug' => 'manage_loan_installments',
                'description' => 'صلاحية Manage loan installments',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.383,
                'type' => 'action',
                'resource' => 'loan',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-06 15:36:06',
                'updated_at' => '2025-09-06 15:36:06',
                'deleted_at' => null,
            ],
            [
                'id' => 384,
                'name' => 'إدارة الإشعارات المتقدمة',
                'slug' => 'manage_advanced_notifications',
                'description' => 'إدارة كاملة لنظام الإشعارات المتقدم',
                'group' => 'notifications',
                'level' => 0,
                'path' => 384,
                'type' => 'group',
                'resource' => 'advanced_notifications',
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 04:15:14',
                'updated_at' => '2025-09-07 04:15:14',
                'deleted_at' => null,
            ],
            [
                'id' => 385,
                'name' => 'عرض الإشعارات العاجلة',
                'slug' => 'view_urgent_notifications',
                'description' => 'عرض قائمة الإشعارات العاجلة والحرجة',
                'group' => 'notifications',
                'level' => 1,
                'path' => 384.385,
                'type' => 'action',
                'resource' => 'urgent_notifications',
                'order' => 1,
                'is_active' => 1,
                'parent_id' => 384,
                'created_at' => '2025-09-07 04:15:14',
                'updated_at' => '2025-09-07 04:15:14',
                'deleted_at' => null,
            ],
            [
                'id' => 386,
                'name' => 'إدارة إعدادات الإشعارات',
                'slug' => 'manage_notification_settings',
                'description' => 'تعديل إعدادات الإشعارات وقنوات الإرسال',
                'group' => 'notifications',
                'level' => 1,
                'path' => 384.386,
                'type' => 'action',
                'resource' => 'notification_settings',
                'order' => 2,
                'is_active' => 1,
                'parent_id' => 384,
                'created_at' => '2025-09-07 04:15:14',
                'updated_at' => '2025-09-07 04:15:14',
                'deleted_at' => null,
            ],
            [
                'id' => 387,
                'name' => 'تشغيل إشعارات الصيانة',
                'slug' => 'run_maintenance_notifications',
                'description' => 'تشغيل أوامر التحقق من الصيانة وإرسال الإشعارات',
                'group' => 'notifications',
                'level' => 1,
                'path' => 384.387,
                'type' => 'action',
                'resource' => 'maintenance_notifications',
                'order' => 3,
                'is_active' => 1,
                'parent_id' => 384,
                'created_at' => '2025-09-07 04:15:14',
                'updated_at' => '2025-09-07 04:15:14',
                'deleted_at' => null,
            ],
            [
                'id' => 388,
                'name' => 'عرض سجلات الإشعارات',
                'slug' => 'view_notification_logs',
                'description' => 'عرض سجلات إرسال الإشعارات والأخطاء',
                'group' => 'notifications',
                'level' => 1,
                'path' => 384.388,
                'type' => 'action',
                'resource' => 'notification_logs',
                'order' => 4,
                'is_active' => 1,
                'parent_id' => 384,
                'created_at' => '2025-09-07 04:15:15',
                'updated_at' => '2025-09-07 04:15:15',
                'deleted_at' => null,
            ],
            [
                'id' => 389,
                'name' => 'تصدير الإشعارات',
                'slug' => 'export_notifications',
                'description' => 'تصدير قائمة الإشعارات إلى ملفات خارجية',
                'group' => 'notifications',
                'level' => 1,
                'path' => 384.389,
                'type' => 'action',
                'resource' => 'export_notifications',
                'order' => 5,
                'is_active' => 1,
                'parent_id' => 384,
                'created_at' => '2025-09-07 04:15:15',
                'updated_at' => '2025-09-07 04:15:15',
                'deleted_at' => null,
            ],
            [
                'id' => 390,
                'name' => 'upload_project_document',
                'slug' => 'upload_project_document',
                'description' => 'رفع مستند للمشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 06:39:35',
                'updated_at' => '2025-09-07 06:39:35',
                'deleted_at' => null,
            ],
            [
                'id' => 391,
                'name' => 'download_project_document',
                'slug' => 'download_project_document',
                'description' => 'تنزيل مستند المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 06:39:35',
                'updated_at' => '2025-09-07 06:39:35',
                'deleted_at' => null,
            ],
            [
                'id' => 392,
                'name' => 'approve_expenses',
                'slug' => 'approve_expenses',
                'description' => 'اعتماد مصروفات المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 06:39:35',
                'updated_at' => '2025-09-07 06:39:35',
                'deleted_at' => null,
            ],
            [
                'id' => 393,
                'name' => 'approve_payments',
                'slug' => 'approve_payments',
                'description' => 'اعتماد مدفوعات المشروع',
                'group' => 'installation_projects',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 06:39:35',
                'updated_at' => '2025-09-07 06:39:35',
                'deleted_at' => null,
            ],
            [
                'id' => 394,
                'name' => 'view_inventory_counts',
                'slug' => 'view_inventory_counts',
                'description' => 'Can view inventory count sessions',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 14:59:19',
                'updated_at' => '2025-09-07 14:59:19',
                'deleted_at' => null,
            ],
            [
                'id' => 395,
                'name' => 'create_inventory_counts',
                'slug' => 'create_inventory_counts',
                'description' => 'Can create new inventory count sessions',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 14:59:19',
                'updated_at' => '2025-09-07 14:59:19',
                'deleted_at' => null,
            ],
            [
                'id' => 396,
                'name' => 'update_inventory_counts',
                'slug' => 'update_inventory_counts',
                'description' => 'Can update inventory count items',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 14:59:19',
                'updated_at' => '2025-09-07 14:59:19',
                'deleted_at' => null,
            ],
            [
                'id' => 397,
                'name' => 'complete_inventory_counts',
                'slug' => 'complete_inventory_counts',
                'description' => 'Can mark inventory counts as complete',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 14:59:19',
                'updated_at' => '2025-09-07 14:59:19',
                'deleted_at' => null,
            ],
            [
                'id' => 398,
                'name' => 'approve_inventory_counts',
                'slug' => 'approve_inventory_counts',
                'description' => 'Can approve inventory counts and adjust stock',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 14:59:19',
                'updated_at' => '2025-09-07 14:59:19',
                'deleted_at' => null,
            ],
            [
                'id' => 399,
                'name' => 'cancel_inventory_counts',
                'slug' => 'cancel_inventory_counts',
                'description' => 'Can cancel inventory count sessions',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 14:59:19',
                'updated_at' => '2025-09-07 14:59:19',
                'deleted_at' => null,
            ],
            [
                'id' => 400,
                'name' => 'view_inventory_alerts',
                'slug' => 'view_inventory_alerts',
                'description' => 'Can view inventory alerts',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 14:59:19',
                'updated_at' => '2025-09-07 14:59:19',
                'deleted_at' => null,
            ],
            [
                'id' => 401,
                'name' => 'manage_inventory_alerts',
                'slug' => 'manage_inventory_alerts',
                'description' => 'Can manage inventory alert settings',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 14:59:19',
                'updated_at' => '2025-09-07 14:59:19',
                'deleted_at' => null,
            ],
            [
                'id' => 402,
                'name' => 'send_inventory_alerts',
                'slug' => 'send_inventory_alerts',
                'description' => 'Can send inventory alerts manually',
                'group' => 'inventory',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 14:59:19',
                'updated_at' => '2025-09-07 14:59:19',
                'deleted_at' => null,
            ],
            [
                'id' => 403,
                'name' => 'view_project_inventory_requests',
                'slug' => 'view_project_inventory_requests',
                'description' => 'عرض طلبات المخزون للمشاريع',
                'group' => 'المشاريع',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 20:12:58',
                'updated_at' => '2025-09-07 20:12:58',
                'deleted_at' => null,
            ],
            [
                'id' => 404,
                'name' => 'create_project_inventory_requests',
                'slug' => 'create_project_inventory_requests',
                'description' => 'إنشاء طلب مخزون للمشروع',
                'group' => 'المشاريع',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 20:12:58',
                'updated_at' => '2025-09-07 20:12:58',
                'deleted_at' => null,
            ],
            [
                'id' => 405,
                'name' => 'edit_project_inventory_requests',
                'slug' => 'edit_project_inventory_requests',
                'description' => 'تعديل طلب مخزون للمشروع',
                'group' => 'المشاريع',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 20:12:58',
                'updated_at' => '2025-09-07 20:12:58',
                'deleted_at' => null,
            ],
            [
                'id' => 406,
                'name' => 'delete_project_inventory_requests',
                'slug' => 'delete_project_inventory_requests',
                'description' => 'حذف طلب مخزون للمشروع',
                'group' => 'المشاريع',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 20:12:58',
                'updated_at' => '2025-09-07 20:12:58',
                'deleted_at' => null,
            ],
            [
                'id' => 407,
                'name' => 'approve_project_inventory_requests',
                'slug' => 'approve_project_inventory_requests',
                'description' => 'اعتماد طلب مخزون للمشروع',
                'group' => 'المشاريع',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 20:12:58',
                'updated_at' => '2025-09-07 20:12:58',
                'deleted_at' => null,
            ],
            [
                'id' => 408,
                'name' => 'reject_project_inventory_requests',
                'slug' => 'reject_project_inventory_requests',
                'description' => 'رفض طلب مخزون للمشروع',
                'group' => 'المشاريع',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 20:12:58',
                'updated_at' => '2025-09-07 20:12:58',
                'deleted_at' => null,
            ],
            [
                'id' => 409,
                'name' => 'fulfill_project_inventory_requests',
                'slug' => 'fulfill_project_inventory_requests',
                'description' => 'تنفيذ طلب مخزون للمشروع',
                'group' => 'المشاريع',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 20:12:58',
                'updated_at' => '2025-09-07 20:12:58',
                'deleted_at' => null,
            ],
            [
                'id' => 410,
                'name' => 'view_project_inventory_reports',
                'slug' => 'view_project_inventory_reports',
                'description' => 'عرض تقارير مخزون المشاريع',
                'group' => 'المشاريع',
                'level' => 0,
                'path' => null,
                'type' => 'action',
                'resource' => null,
                'order' => 0,
                'is_active' => 1,
                'parent_id' => null,
                'created_at' => '2025-09-07 20:12:58',
                'updated_at' => '2025-09-07 20:12:58',
                'deleted_at' => null,
            ],
            [
                'id' => 411,
                'name' => 'View employee tasks',
                'slug' => 'view_employee_tasks',
                'description' => 'صلاحية View employee tasks',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.411,
                'type' => 'action',
                'resource' => 'employee',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:06',
                'updated_at' => '2025-09-07 21:46:06',
                'deleted_at' => null,
            ],
            [
                'id' => 412,
                'name' => 'Create employee task',
                'slug' => 'create_employee_task',
                'description' => 'صلاحية Create employee task',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.412,
                'type' => 'action',
                'resource' => 'employee',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:06',
                'updated_at' => '2025-09-07 21:46:06',
                'deleted_at' => null,
            ],
            [
                'id' => 413,
                'name' => 'Edit employee task',
                'slug' => 'edit_employee_task',
                'description' => 'صلاحية Edit employee task',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.413,
                'type' => 'action',
                'resource' => 'employee',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:06',
                'updated_at' => '2025-09-07 21:46:06',
                'deleted_at' => null,
            ],
            [
                'id' => 414,
                'name' => 'Delete employee task',
                'slug' => 'delete_employee_task',
                'description' => 'صلاحية Delete employee task',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.414,
                'type' => 'action',
                'resource' => 'employee',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:07',
                'updated_at' => '2025-09-07 21:46:07',
                'deleted_at' => null,
            ],
            [
                'id' => 415,
                'name' => 'Manage employee tasks',
                'slug' => 'manage_employee_tasks',
                'description' => 'صلاحية Manage employee tasks',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.415,
                'type' => 'action',
                'resource' => 'employee',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:07',
                'updated_at' => '2025-09-07 21:46:07',
                'deleted_at' => null,
            ],
            [
                'id' => 416,
                'name' => 'Update task status',
                'slug' => 'update_task_status',
                'description' => 'صلاحية Update task status',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.416,
                'type' => 'action',
                'resource' => 'task',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:07',
                'updated_at' => '2025-09-07 21:46:07',
                'deleted_at' => null,
            ],
            [
                'id' => 417,
                'name' => 'Update task progress',
                'slug' => 'update_task_progress',
                'description' => 'صلاحية Update task progress',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.417,
                'type' => 'action',
                'resource' => 'task',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:07',
                'updated_at' => '2025-09-07 21:46:07',
                'deleted_at' => null,
            ],
            [
                'id' => 418,
                'name' => 'View task assignments',
                'slug' => 'view_task_assignments',
                'description' => 'صلاحية View task assignments',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.418,
                'type' => 'action',
                'resource' => 'task',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:08',
                'updated_at' => '2025-09-07 21:46:08',
                'deleted_at' => null,
            ],
            [
                'id' => 419,
                'name' => 'Create task assignment',
                'slug' => 'create_task_assignment',
                'description' => 'صلاحية Create task assignment',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.419,
                'type' => 'action',
                'resource' => 'task',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:08',
                'updated_at' => '2025-09-07 21:46:08',
                'deleted_at' => null,
            ],
            [
                'id' => 420,
                'name' => 'Delete task assignment',
                'slug' => 'delete_task_assignment',
                'description' => 'صلاحية Delete task assignment',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.420,
                'type' => 'action',
                'resource' => 'task',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:08',
                'updated_at' => '2025-09-07 21:46:08',
                'deleted_at' => null,
            ],
            [
                'id' => 421,
                'name' => 'Manage task assignments',
                'slug' => 'manage_task_assignments',
                'description' => 'صلاحية Manage task assignments',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.421,
                'type' => 'action',
                'resource' => 'task',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:08',
                'updated_at' => '2025-09-07 21:46:08',
                'deleted_at' => null,
            ],
            [
                'id' => 422,
                'name' => 'View task comments',
                'slug' => 'view_task_comments',
                'description' => 'صلاحية View task comments',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.422,
                'type' => 'action',
                'resource' => 'task',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:09',
                'updated_at' => '2025-09-07 21:46:09',
                'deleted_at' => null,
            ],
            [
                'id' => 423,
                'name' => 'Create task comment',
                'slug' => 'create_task_comment',
                'description' => 'صلاحية Create task comment',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.423,
                'type' => 'action',
                'resource' => 'task',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:09',
                'updated_at' => '2025-09-07 21:46:09',
                'deleted_at' => null,
            ],
            [
                'id' => 424,
                'name' => 'Edit task comment',
                'slug' => 'edit_task_comment',
                'description' => 'صلاحية Edit task comment',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.424,
                'type' => 'action',
                'resource' => 'task',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:09',
                'updated_at' => '2025-09-07 21:46:09',
                'deleted_at' => null,
            ],
            [
                'id' => 425,
                'name' => 'Delete task comment',
                'slug' => 'delete_task_comment',
                'description' => 'صلاحية Delete task comment',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.425,
                'type' => 'action',
                'resource' => 'task',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:10',
                'updated_at' => '2025-09-07 21:46:10',
                'deleted_at' => null,
            ],
            [
                'id' => 426,
                'name' => 'Manage task comments',
                'slug' => 'manage_task_comments',
                'description' => 'صلاحية Manage task comments',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.426,
                'type' => 'action',
                'resource' => 'task',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:10',
                'updated_at' => '2025-09-07 21:46:10',
                'deleted_at' => null,
            ],
            [
                'id' => 427,
                'name' => 'View task attachments',
                'slug' => 'view_task_attachments',
                'description' => 'صلاحية View task attachments',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.427,
                'type' => 'action',
                'resource' => 'task',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:10',
                'updated_at' => '2025-09-07 21:46:10',
                'deleted_at' => null,
            ],
            [
                'id' => 428,
                'name' => 'Upload task attachment',
                'slug' => 'upload_task_attachment',
                'description' => 'صلاحية Upload task attachment',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.428,
                'type' => 'action',
                'resource' => 'task',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:10',
                'updated_at' => '2025-09-07 21:46:10',
                'deleted_at' => null,
            ],
            [
                'id' => 429,
                'name' => 'Delete task attachment',
                'slug' => 'delete_task_attachment',
                'description' => 'صلاحية Delete task attachment',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.429,
                'type' => 'action',
                'resource' => 'task',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:10',
                'updated_at' => '2025-09-07 21:46:10',
                'deleted_at' => null,
            ],
            [
                'id' => 430,
                'name' => 'Manage task attachments',
                'slug' => 'manage_task_attachments',
                'description' => 'صلاحية Manage task attachments',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.430,
                'type' => 'action',
                'resource' => 'task',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:11',
                'updated_at' => '2025-09-07 21:46:11',
                'deleted_at' => null,
            ],
            [
                'id' => 431,
                'name' => 'View task dashboard',
                'slug' => 'view_task_dashboard',
                'description' => 'صلاحية View task dashboard',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.431,
                'type' => 'action',
                'resource' => 'task',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:11',
                'updated_at' => '2025-09-07 21:46:11',
                'deleted_at' => null,
            ],
            [
                'id' => 432,
                'name' => 'View task reports',
                'slug' => 'view_task_reports',
                'description' => 'صلاحية View task reports',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.432,
                'type' => 'action',
                'resource' => 'task',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:11',
                'updated_at' => '2025-09-07 21:46:11',
                'deleted_at' => null,
            ],
            [
                'id' => 433,
                'name' => 'Export task reports',
                'slug' => 'export_task_reports',
                'description' => 'صلاحية Export task reports',
                'group' => 'hrm',
                'level' => 1,
                'path' => 330.433,
                'type' => 'action',
                'resource' => 'task',
                'order' => 10,
                'is_active' => 1,
                'parent_id' => 330,
                'created_at' => '2025-09-07 21:46:11',
                'updated_at' => '2025-09-07 21:46:11',
                'deleted_at' => null,
            ],
        ];

        DB::table('permissions')->insert($data);

        // إعادة تفعيل فحص المفاتيح الأجنبية
        DB::statement('SET FOREIGN_KEY_CHECKS=1');
    }
}
