<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class PaymentMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // تعطيل فحص المفاتيح الأجنبية مؤقتًا
        DB::statement('SET FOREIGN_KEY_CHECKS=0');

        // حذف البيانات الموجودة
        DB::table('payment_methods')->truncate();

        // إضافة البيانات
        $data = [
            [
                'id' => 1,
                'company_id' => 1,
                'name' => 'نقدي',
                'description' => 'الدفع نقداً',
                'is_active' => 1,
                'created_at' => '2025-09-04 16:27:57',
                'updated_at' => '2025-09-04 16:27:57',
            ],
            [
                'id' => 2,
                'company_id' => 1,
                'name' => 'تحويل بنكي',
                'description' => 'الدفع عن طريق تحويل بنكي',
                'is_active' => 1,
                'created_at' => '2025-09-04 16:27:57',
                'updated_at' => '2025-09-04 16:27:57',
            ],
            [
                'id' => 3,
                'company_id' => 1,
                'name' => 'شيك',
                'description' => 'الدفع بشيك',
                'is_active' => 1,
                'created_at' => '2025-09-04 16:27:57',
                'updated_at' => '2025-09-04 16:27:57',
            ],
            [
                'id' => 4,
                'company_id' => 1,
                'name' => 'بطاقة ائتمان',
                'description' => 'الدفع ببطاقة ائتمان',
                'is_active' => 1,
                'created_at' => '2025-09-04 16:27:57',
                'updated_at' => '2025-09-04 16:27:57',
            ],
        ];

        DB::table('payment_methods')->insert($data);

        // إعادة تفعيل فحص المفاتيح الأجنبية
        DB::statement('SET FOREIGN_KEY_CHECKS=1');
    }
}
