<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;
use App\Models\Role;
use Illuminate\Support\Facades\DB;

class NotificationPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Define notification permissions
        $permissions = [
            [
                'name' => 'view_notifications',
                'display_name' => 'عرض الإشعارات',
                'description' => 'عرض قائمة الإشعارات',
                'group' => 'الإشعارات',
            ],
            [
                'name' => 'view_notification',
                'display_name' => 'عرض تفاصيل الإشعار',
                'description' => 'عرض تفاصيل إشعار محدد',
                'group' => 'الإشعارات',
            ],
            [
                'name' => 'mark_notification_read',
                'display_name' => 'تحديد الإشعار كمقروء',
                'description' => 'تحديد إشعار محدد كمقروء',
                'group' => 'الإشعارات',
            ],
            [
                'name' => 'mark_all_notifications_read',
                'display_name' => 'تحديد جميع الإشعارات كمقروءة',
                'description' => 'تحديد جميع الإشعارات كمقروءة',
                'group' => 'الإشعارات',
            ],
            [
                'name' => 'delete_notification',
                'display_name' => 'حذف الإشعار',
                'description' => 'حذف إشعار محدد',
                'group' => 'الإشعارات',
            ],
        ];

        // Insert permissions if they don't exist
        foreach ($permissions as $permission) {
            Permission::firstOrCreate(
                ['name' => $permission['name']],
                [
                    'display_name' => $permission['display_name'],
                    'description' => $permission['description'],
                    'group' => $permission['group'],
                ]
            );
        }

        // Get all roles
        $roles = Role::all();

        // Get all notification permissions
        $notificationPermissions = Permission::where('group', 'الإشعارات')->get();

        // Assign permissions to roles
        foreach ($roles as $role) {
            // Super Admin and Company Admin get all notification permissions
            if ($role->name === 'Super Admin' || $role->name === 'Company Admin') {
                foreach ($notificationPermissions as $permission) {
                    // Check if the role already has the permission
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permission->id)
                        ->where('role_id', $role->id)
                        ->exists();

                    // If not, assign it
                    if (!$exists) {
                        $role->attachPermission($permission);
                    }
                }
            }
            // Other roles get view and mark as read permissions only
            else {
                $viewPermissions = $notificationPermissions->filter(function ($permission) {
                    return in_array($permission->name, ['view_notifications', 'view_notification', 'mark_notification_read']);
                });

                foreach ($viewPermissions as $permission) {
                    // Check if the role already has the permission
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permission->id)
                        ->where('role_id', $role->id)
                        ->exists();

                    // If not, assign it
                    if (!$exists) {
                        $role->attachPermission($permission);
                    }
                }
            }
        }
    }
}
