<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class Manager3ProjectPhasesPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // الحصول على المستخدم manager3
        $manager3 = User::where('email', 'manager3@manager3.com')->first();

        if (!$manager3) {
            $this->command->error('المستخدم manager3 غير موجود!');
            return;
        }

        // الأذونات المطلوبة لمراحل المشاريع
        $permissionSlugs = [
            'view_installation_projects',
            'edit_installation_project',
            'manage_installation_projects',
            'create_installation_project',
            'delete_installation_project'
        ];

        // إضافة الأذونات للمستخدم
        foreach ($permissionSlugs as $slug) {
            $permission = Permission::where('name', $slug)->first();

            if ($permission) {
                // التحقق من عدم وجود الإذن مسبقاً
                $exists = DB::table('user_permission')
                    ->where('user_id', $manager3->id)
                    ->where('permission_id', $permission->id)
                    ->exists();

                if (!$exists) {
                    DB::table('user_permission')->insert([
                        'user_id' => $manager3->id,
                        'permission_id' => $permission->id,
                        'granted' => true,
                        'source' => 'seeder',
                        'created_at' => now(),
                        'updated_at' => now()
                    ]);

                    $this->command->info("تم إضافة الإذن {$permission->name} للمستخدم manager3");
                } else {
                    $this->command->info("الإذن {$permission->name} موجود مسبقاً للمستخدم manager3");
                }
            } else {
                $this->command->error("الإذن {$slug} غير موجود في قاعدة البيانات!");
            }
        }
    }
}
