<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Permission;
use App\Models\UserPermission;

class Manager3CompanyPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // الحصول على المستخدم manager3
        $manager3 = User::where('email', 'manager3@manager3.com')->first();

        if (!$manager3) {
            $this->command->error('المستخدم manager3 غير موجود!');
            return;
        }

        // الحصول على إذن إدارة الشركات
        $permission = Permission::where('slug', 'manage_companies')->first();

        if (!$permission) {
            $this->command->error('إذن إدارة الشركات غير موجود!');
            return;
        }

        // التحقق مما إذا كان المستخدم لديه الإذن بالفعل
        $existingPermission = UserPermission::where('permission_id', $permission->id)
            ->where('user_id', $manager3->id)
            ->first();

        if (!$existingPermission) {
            // إضافة الإذن للمستخدم
            UserPermission::create([
                'user_id' => $manager3->id,
                'permission_id' => $permission->id,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            $this->command->info("تم إضافة إذن إدارة الشركات للمستخدم manager3");
        } else {
            $this->command->info("إذن إدارة الشركات موجود مسبقاً للمستخدم manager3");
        }
    }
}
