<?php

namespace Database\Seeders;

use App\Models\Permission;
use Illuminate\Database\Seeder;

class MaintenancePermissionsSeeder extends Seeder
{
    /**
     * تنفيذ عملية البذر.
     *
     * @return void
     */
    public function run()
    {
        // مجموعات الصلاحيات الجديدة
        $permissionGroups = [
            'maintenance_schedule' => 'جداول الصيانة',
            'maintenance_log' => 'سجلات الصيانة',
        ];

        // إضافة مجموعات الصلاحيات إلى قاعدة البيانات
        foreach ($permissionGroups as $key => $value) {
            try {
                // التحقق من وجود المجموعة في جدول permissions
                $groupExists = Permission::where('slug', 'group_' . $key)
                    ->where('type', 'group')
                    ->exists();

                if (!$groupExists) {
                    $group = new Permission();
                    $group->name = $value;
                    $group->slug = 'group_' . $key;
                    $group->description = 'مجموعة صلاحيات ' . $value;
                    $group->group = $key;
                    $group->type = 'group';
                    $group->is_active = true;
                    $group->save();

                    // تحديث المسار والمستوى
                    $group->updatePath();
                    $group->updateLevel();

                    echo "تم إنشاء مجموعة الصلاحيات: " . $value . " (" . $key . ")\n";
                }
            } catch (\Exception $e) {
                echo "خطأ في إنشاء مجموعة الصلاحيات: " . $value . " - " . $e->getMessage() . "\n";
            }
        }

        // الصلاحيات الخاصة بنظام الصيانة الدورية
        $permissions = [
            // صلاحيات جداول الصيانة
            [
                'name' => 'إدارة جداول الصيانة',
                'slug' => 'manage-maintenance-schedule',
                'description' => 'إدارة جداول الصيانة الدورية',
                'group' => 'maintenance_schedule',
                'type' => 'crud',
            ],
            [
                'name' => 'عرض جداول الصيانة',
                'slug' => 'view-maintenance-schedule',
                'description' => 'عرض قائمة جداول الصيانة',
                'group' => 'maintenance_schedule',
                'type' => 'view',
            ],
            [
                'name' => 'إضافة جدول صيانة',
                'slug' => 'create-maintenance-schedule',
                'description' => 'إضافة جدول صيانة جديد',
                'group' => 'maintenance_schedule',
                'type' => 'action',
            ],
            [
                'name' => 'تعديل جدول صيانة',
                'slug' => 'edit-maintenance-schedule',
                'description' => 'تعديل بيانات جدول الصيانة',
                'group' => 'maintenance_schedule',
                'type' => 'action',
            ],
            [
                'name' => 'حذف جدول صيانة',
                'slug' => 'delete-maintenance-schedule',
                'description' => 'حذف جدول صيانة',
                'group' => 'maintenance_schedule',
                'type' => 'action',
            ],
            [
                'name' => 'توليد جداول الصيانة',
                'slug' => 'generate-maintenance-schedule',
                'description' => 'توليد جداول صيانة تلقائية',
                'group' => 'maintenance_schedule',
                'type' => 'action',
            ],

            // صلاحيات سجلات الصيانة
            [
                'name' => 'إدارة سجلات الصيانة',
                'slug' => 'manage-maintenance-log',
                'description' => 'إدارة سجلات الصيانة الدورية',
                'group' => 'maintenance_log',
                'type' => 'crud',
            ],
            [
                'name' => 'عرض سجلات الصيانة',
                'slug' => 'view-maintenance-log',
                'description' => 'عرض قائمة سجلات الصيانة',
                'group' => 'maintenance_log',
                'type' => 'view',
            ],
            [
                'name' => 'إضافة سجل صيانة',
                'slug' => 'create-maintenance-log',
                'description' => 'إضافة سجل صيانة جديد',
                'group' => 'maintenance_log',
                'type' => 'action',
            ],
            [
                'name' => 'تعديل سجل صيانة',
                'slug' => 'edit-maintenance-log',
                'description' => 'تعديل بيانات سجل الصيانة',
                'group' => 'maintenance_log',
                'type' => 'action',
            ],
            [
                'name' => 'حذف سجل صيانة',
                'slug' => 'delete-maintenance-log',
                'description' => 'حذف سجل صيانة',
                'group' => 'maintenance_log',
                'type' => 'action',
            ],
            [
                'name' => 'تصدير سجلات الصيانة',
                'slug' => 'export-maintenance-log',
                'description' => 'تصدير سجلات الصيانة',
                'group' => 'maintenance_log',
                'type' => 'action',
            ],
            [
                'name' => 'طباعة سجلات الصيانة',
                'slug' => 'print-maintenance-log',
                'description' => 'طباعة سجلات الصيانة',
                'group' => 'maintenance_log',
                'type' => 'action',
            ],
        ];

        // إنشاء الصلاحيات
        foreach ($permissions as $permission) {
            try {
                $perm = Permission::firstOrCreate(
                    ['slug' => $permission['slug']],
                    [
                        'name' => $permission['name'],
                        'description' => $permission['description'],
                        'group' => $permission['group'],
                        'type' => $permission['type'],
                        'is_active' => true,
                    ]
                );

                // تحديث المسار والمستوى
                if ($perm->wasRecentlyCreated) {
                    $perm->updatePath();
                    $perm->updateLevel();
                }

                echo "تم إنشاء الصلاحية: " . $permission['name'] . " (" . $permission['slug'] . ")\n";
            } catch (\Exception $e) {
                echo "خطأ في إنشاء الصلاحية: " . $permission['name'] . " - " . $e->getMessage() . "\n";
            }
        }
    }
}
