<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MaintenanceFinancialPermissionsSeeder extends Seeder
{
    /**
     * تنفيذ عملية البذر.
     *
     * @return void
     */
    public function run()
    {
        // مجموعات الصلاحيات الجديدة
        $permissionGroups = [
            'maintenance_financial' => 'التقارير المالية للصيانة',
            'maintenance_notifications' => 'إشعارات الصيانة',
        ];

        // إضافة مجموعات الصلاحيات إلى قاعدة البيانات
        foreach ($permissionGroups as $key => $value) {
            try {
                // التحقق من وجود المجموعة في جدول permissions
                $groupExists = Permission::where('slug', 'group_' . $key)
                    ->where('type', 'group')
                    ->exists();

                if (!$groupExists) {
                    $group = new Permission();
                    $group->name = $value;
                    $group->slug = 'group_' . $key;
                    $group->description = 'مجموعة صلاحيات ' . $value;
                    $group->group = $key;
                    $group->type = 'group';
                    $group->is_active = true;
                    $group->save();

                    // تحديث المسار والمستوى
                    $group->updatePath();
                    $group->updateLevel();

                    echo "تم إنشاء مجموعة الصلاحيات: " . $value . " (" . $key . ")\n";
                }
            } catch (\Exception $e) {
                echo "خطأ في إنشاء مجموعة الصلاحيات: " . $value . " - " . $e->getMessage() . "\n";
            }
        }

        // الصلاحيات الخاصة بالتقارير المالية للصيانة
        $permissions = [
            // صلاحيات التقارير المالية للصيانة
            [
                'name' => 'عرض التقارير المالية للصيانة',
                'slug' => 'view_financial_reports',
                'description' => 'عرض التقارير المالية للصيانة',
                'group' => 'maintenance_financial',
                'type' => 'view',
            ],
            [
                'name' => 'عرض تقارير أداء الفنيين',
                'slug' => 'view_technician_reports',
                'description' => 'عرض تقارير أداء الفنيين',
                'group' => 'maintenance_financial',
                'type' => 'view',
            ],
            [
                'name' => 'إنشاء فواتير من الصيانة',
                'slug' => 'create_invoices',
                'description' => 'إنشاء فواتير من سجلات الصيانة',
                'group' => 'maintenance_financial',
                'type' => 'action',
            ],
            [
                'name' => 'تصدير التقارير المالية',
                'slug' => 'export_financial_reports',
                'description' => 'تصدير التقارير المالية للصيانة',
                'group' => 'maintenance_financial',
                'type' => 'action',
            ],

            // صلاحيات إشعارات الصيانة
            [
                'name' => 'إدارة إشعارات الصيانة',
                'slug' => 'manage_maintenance_notifications',
                'description' => 'إدارة إشعارات الصيانة',
                'group' => 'maintenance_notifications',
                'type' => 'crud',
            ],
            [
                'name' => 'عرض إشعارات الصيانة',
                'slug' => 'view_maintenance_notifications',
                'description' => 'عرض إشعارات الصيانة',
                'group' => 'maintenance_notifications',
                'type' => 'view',
            ],
            [
                'name' => 'إرسال إشعارات الصيانة',
                'slug' => 'send_maintenance_notifications',
                'description' => 'إرسال إشعارات الصيانة',
                'group' => 'maintenance_notifications',
                'type' => 'action',
            ],
            [
                'name' => 'تعديل إشعارات الصيانة',
                'slug' => 'edit_maintenance_notifications',
                'description' => 'تعديل إشعارات الصيانة',
                'group' => 'maintenance_notifications',
                'type' => 'action',
            ],
            [
                'name' => 'حذف إشعارات الصيانة',
                'slug' => 'delete_maintenance_notifications',
                'description' => 'حذف إشعارات الصيانة',
                'group' => 'maintenance_notifications',
                'type' => 'action',
            ],
        ];

        // إنشاء الصلاحيات
        foreach ($permissions as $permission) {
            try {
                $perm = Permission::firstOrCreate(
                    ['slug' => $permission['slug']],
                    [
                        'name' => $permission['name'],
                        'description' => $permission['description'],
                        'group' => $permission['group'],
                        'type' => $permission['type'],
                        'is_active' => true,
                    ]
                );

                // تحديث المسار والمستوى
                if ($perm->wasRecentlyCreated) {
                    $perm->updatePath();
                    $perm->updateLevel();
                }

                echo "تم إنشاء الصلاحية: " . $permission['name'] . " (" . $permission['slug'] . ")\n";
            } catch (\Exception $e) {
                echo "خطأ في إنشاء الصلاحية: " . $permission['name'] . " - " . $e->getMessage() . "\n";
            }
        }

        // إضافة الصلاحيات للأدوار
        $roles = Role::all();
        $financialPermissions = Permission::where('group', 'maintenance_financial')->get();
        $notificationPermissions = Permission::where('group', 'maintenance_notifications')->get();

        foreach ($roles as $role) {
            // Super Admin و Company Admin يحصلون على جميع الصلاحيات
            if ($role->name === 'Super Admin' || $role->name === 'Company Admin') {
                foreach ($financialPermissions as $permission) {
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permission->id)
                        ->where('role_id', $role->id)
                        ->exists();

                    if (!$exists) {
                        $role->attachPermission($permission);
                    }
                }

                foreach ($notificationPermissions as $permission) {
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permission->id)
                        ->where('role_id', $role->id)
                        ->exists();

                    if (!$exists) {
                        $role->attachPermission($permission);
                    }
                }
            }
            // دور المحاسب يحصل على صلاحيات التقارير المالية
            elseif ($role->name === 'Accountant') {
                foreach ($financialPermissions as $permission) {
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permission->id)
                        ->where('role_id', $role->id)
                        ->exists();

                    if (!$exists) {
                        $role->attachPermission($permission);
                    }
                }
            }
            // دور الفني يحصل على صلاحيات عرض إشعارات الصيانة
            elseif ($role->name === 'Technician') {
                $viewPermissions = $notificationPermissions->filter(function ($permission) {
                    return in_array($permission->slug, ['view_maintenance_notifications']);
                });

                foreach ($viewPermissions as $permission) {
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permission->id)
                        ->where('role_id', $role->id)
                        ->exists();

                    if (!$exists) {
                        $role->attachPermission($permission);
                    }
                }
            }
        }
    }
}
