<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;
use App\Models\Role;

class InvoicePermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // إنشاء صلاحيات الفواتير
        $invoicePermissions = [
            'invoices.view',
            'invoices.create',
            'invoices.edit',
            'invoices.delete',
            'invoices.export',
            'invoices.generate_recurring',
            'invoices.create_installments',

            'invoice_templates.view',
            'invoice_templates.create',
            'invoice_templates.edit',
            'invoice_templates.delete',

            'invoice_installments.view',
            'invoice_installments.create',
            'invoice_installments.edit',
            'invoice_installments.delete',

            'tax_reports.view',
            'tax_reports.create',
            'tax_reports.edit',
            'tax_reports.delete',
            'tax_reports.export',

            'financial_reports.view',
            'financial_reports.export',

            'customer_statements.view',
            'customer_statements.export',
        ];

        foreach ($invoicePermissions as $permission) {
            Permission::firstOrCreate([
                'name' => $permission,
                'slug' => $permission,
                'group' => 'invoices',
                'description' => 'صلاحية ' . $permission
            ]);
        }

        // إضافة الصلاحيات للأدوار
        $roles = [
            'super_admin' => $invoicePermissions,
            'admin' => $invoicePermissions,
            'accountant' => [
                'invoices.view',
                'invoices.create',
                'invoices.edit',
                'invoices.export',
                'invoices.generate_recurring',
                'invoices.create_installments',

                'invoice_templates.view',

                'invoice_installments.view',
                'invoice_installments.create',
                'invoice_installments.edit',

                'tax_reports.view',
                'tax_reports.create',
                'tax_reports.export',

                'financial_reports.view',
                'financial_reports.export',

                'customer_statements.view',
                'customer_statements.export',
            ],
            'manager' => [
                'invoices.view',
                'invoices.export',

                'invoice_templates.view',

                'invoice_installments.view',

                'tax_reports.view',
                'tax_reports.export',

                'financial_reports.view',
                'financial_reports.export',

                'customer_statements.view',
                'customer_statements.export',
            ],
            'sales' => [
                'invoices.view',
                'invoices.create',

                'invoice_installments.view',

                'customer_statements.view',
            ],
        ];

        foreach ($roles as $roleName => $permissions) {
            $role = Role::where('name', $roleName)->first();
            if ($role) {
                // إضافة الصلاحيات الجديدة للدور
                foreach ($permissions as $permission) {
                    $permObj = Permission::where('name', $permission)->first();
                    if ($permObj) {
                        // التحقق مما إذا كان الدور يملك هذه الصلاحية بالفعل
                        if (!$role->permissions()->where('permissions.id', $permObj->id)->exists()) {
                            $role->permissions()->attach($permObj->id);
                        }
                    }
                }
            }
        }
    }
}
