<?php

namespace Database\Seeders;

use App\Models\Company;
use App\Models\InventoryUnit;
use Illuminate\Database\Seeder;

class InventoryUnitsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // الحصول على جميع الشركات
        $companies = Company::all();

        // الوحدات الأساسية
        $baseUnits = [
            [
                'name' => 'قطعة',
                'name_en' => 'Piece',
                'code' => 'PCS',
                'description' => 'وحدة قياس للقطع الفردية',
                'is_base' => true,
            ],
            [
                'name' => 'متر',
                'name_en' => 'Meter',
                'code' => 'M',
                'description' => 'وحدة قياس للطول',
                'is_base' => true,
            ],
            [
                'name' => 'كيلوجرام',
                'name_en' => 'Kilogram',
                'code' => 'KG',
                'description' => 'وحدة قياس للوزن',
                'is_base' => true,
            ],
            [
                'name' => 'لتر',
                'name_en' => 'Liter',
                'code' => 'L',
                'description' => 'وحدة قياس للحجم',
                'is_base' => true,
            ],
        ];

        // الوحدات الفرعية
        $subUnits = [
            [
                'name' => 'صندوق',
                'name_en' => 'Box',
                'code' => 'BOX',
                'description' => 'صندوق يحتوي على عدة قطع',
                'is_base' => false,
            ],
            [
                'name' => 'كرتون',
                'name_en' => 'Carton',
                'code' => 'CTN',
                'description' => 'كرتون يحتوي على عدة صناديق',
                'is_base' => false,
            ],
            [
                'name' => 'سنتيمتر',
                'name_en' => 'Centimeter',
                'code' => 'CM',
                'description' => 'وحدة قياس للطول (1/100 متر)',
                'is_base' => false,
            ],
            [
                'name' => 'جرام',
                'name_en' => 'Gram',
                'code' => 'G',
                'description' => 'وحدة قياس للوزن (1/1000 كيلوجرام)',
                'is_base' => false,
            ],
            [
                'name' => 'مليلتر',
                'name_en' => 'Milliliter',
                'code' => 'ML',
                'description' => 'وحدة قياس للحجم (1/1000 لتر)',
                'is_base' => false,
            ],
            [
                'name' => 'طن',
                'name_en' => 'Ton',
                'code' => 'TON',
                'description' => 'وحدة قياس للوزن (1000 كيلوجرام)',
                'is_base' => false,
            ],
            [
                'name' => 'زوج',
                'name_en' => 'Pair',
                'code' => 'PAIR',
                'description' => 'زوج من القطع',
                'is_base' => false,
            ],
            [
                'name' => 'مجموعة',
                'name_en' => 'Set',
                'code' => 'SET',
                'description' => 'مجموعة من القطع المرتبطة',
                'is_base' => false,
            ],
            [
                'name' => 'لفة',
                'name_en' => 'Roll',
                'code' => 'ROLL',
                'description' => 'لفة من المواد',
                'is_base' => false,
            ],
        ];

        // إضافة الوحدات لكل شركة
        foreach ($companies as $company) {
            // إضافة الوحدات الأساسية
            foreach ($baseUnits as $unit) {
                InventoryUnit::firstOrCreate(
                    [
                        'company_id' => $company->id,
                        'code' => $unit['code']
                    ],
                    [
                        'name' => $unit['name'],
                        'name_en' => $unit['name_en'],
                        'description' => $unit['description'],
                        'is_base' => $unit['is_base'],
                        'is_active' => true
                    ]
                );
            }

            // إضافة الوحدات الفرعية
            foreach ($subUnits as $unit) {
                InventoryUnit::firstOrCreate(
                    [
                        'company_id' => $company->id,
                        'code' => $unit['code']
                    ],
                    [
                        'name' => $unit['name'],
                        'name_en' => $unit['name_en'],
                        'description' => $unit['description'],
                        'is_base' => $unit['is_base'],
                        'is_active' => true
                    ]
                );
            }
        }
    }
}
