<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;
use App\Models\Role;
use App\Models\User;
use Illuminate\Support\Facades\DB;

class InventoryUnitsPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $permissions = [
            // Inventory Units
            ['name' => 'view_inventory_units', 'slug' => 'view_inventory_units', 'description' => 'عرض وحدات المخزون', 'group' => 'المخزون'],
            ['name' => 'create_inventory_units', 'slug' => 'create_inventory_units', 'description' => 'إنشاء وحدة مخزون جديدة', 'group' => 'المخزون'],
            ['name' => 'edit_inventory_units', 'slug' => 'edit_inventory_units', 'description' => 'تعديل وحدة مخزون', 'group' => 'المخزون'],
            ['name' => 'delete_inventory_units', 'slug' => 'delete_inventory_units', 'description' => 'حذف وحدة مخزون', 'group' => 'المخزون'],

            // Inventory Item Units
            ['name' => 'view_inventory_item_units', 'slug' => 'view_inventory_item_units', 'description' => 'عرض وحدات الأصناف', 'group' => 'المخزون'],
            ['name' => 'create_inventory_item_units', 'slug' => 'create_inventory_item_units', 'description' => 'إضافة وحدة لصنف', 'group' => 'المخزون'],
            ['name' => 'edit_inventory_item_units', 'slug' => 'edit_inventory_item_units', 'description' => 'تعديل وحدة صنف', 'group' => 'المخزون'],
            ['name' => 'delete_inventory_item_units', 'slug' => 'delete_inventory_item_units', 'description' => 'حذف وحدة صنف', 'group' => 'المخزون'],
        ];

        foreach ($permissions as $permission) {
            // البحث عن الصلاحية إما بالاسم أو بالسلاج
            $existingPermission = Permission::where('name', $permission['name'])
                ->orWhere('slug', $permission['slug'])
                ->first();

            if ($existingPermission) {
                // تحديث الصلاحية الموجودة
                $existingPermission->update([
                    'name' => $permission['name'],
                    'description' => $permission['description'],
                    'group' => $permission['group']
                ]);
            } else {
                // إنشاء صلاحية جديدة
                Permission::create([
                    'name' => $permission['name'],
                    'slug' => $permission['slug'],
                    'description' => $permission['description'],
                    'group' => $permission['group']
                ]);
            }
        }

        // إضافة الصلاحيات لدور المدير
        $adminRole = Role::where('name', 'admin')->first();
        if ($adminRole) {
            $allPermissions = Permission::whereIn('slug', array_column($permissions, 'slug'))->get();
            foreach ($allPermissions as $permission) {
                if (!$adminRole->hasPermission($permission->slug)) {
                    DB::table('permission_role')->insert([
                        'role_id' => $adminRole->id,
                        'permission_id' => $permission->id
                    ]);
                }
            }
        }

        // إضافة الصلاحيات للمستخدم manager3
        $manager3 = User::where('email', 'manager3@example.com')->first();
        if ($manager3) {
            $allPermissions = Permission::whereIn('slug', array_column($permissions, 'slug'))->get();
            foreach ($allPermissions as $permission) {
                if (!$manager3->hasPermission($permission->slug)) {
                    DB::table('user_permission')->insert([
                        'user_id' => $manager3->id,
                        'permission_id' => $permission->id
                    ]);
                }
            }
        }
    }
}
