<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;
use Illuminate\Support\Facades\DB;

class InventoryPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $permissions = [
            // Warehouses
            ['name' => 'view_warehouses', 'slug' => 'view_warehouses', 'description' => 'عرض قائمة المستودعات', 'group' => 'المخزون'],
            ['name' => 'create_warehouses', 'slug' => 'create_warehouses', 'description' => 'إنشاء مستودع جديد', 'group' => 'المخزون'],
            ['name' => 'edit_warehouses', 'slug' => 'edit_warehouses', 'description' => 'تعديل بيانات المستودع', 'group' => 'المخزون'],
            ['name' => 'delete_warehouses', 'slug' => 'delete_warehouses', 'description' => 'حذف مستودع', 'group' => 'المخزون'],

            // Suppliers
            ['name' => 'view_suppliers', 'slug' => 'view_suppliers', 'description' => 'عرض قائمة الموردين', 'group' => 'المخزون'],
            ['name' => 'create_suppliers', 'slug' => 'create_suppliers', 'description' => 'إنشاء مورد جديد', 'group' => 'المخزون'],
            ['name' => 'edit_suppliers', 'slug' => 'edit_suppliers', 'description' => 'تعديل بيانات المورد', 'group' => 'المخزون'],
            ['name' => 'delete_suppliers', 'slug' => 'delete_suppliers', 'description' => 'حذف مورد', 'group' => 'المخزون'],

            // Supplier Evaluations
            ['name' => 'view_supplier_evaluations', 'slug' => 'view_supplier_evaluations', 'description' => 'عرض تقييمات الموردين', 'group' => 'المخزون'],
            ['name' => 'create_supplier_evaluations', 'slug' => 'create_supplier_evaluations', 'description' => 'إنشاء تقييم مورد جديد', 'group' => 'المخزون'],
            ['name' => 'edit_supplier_evaluations', 'slug' => 'edit_supplier_evaluations', 'description' => 'تعديل تقييم مورد', 'group' => 'المخزون'],
            ['name' => 'delete_supplier_evaluations', 'slug' => 'delete_supplier_evaluations', 'description' => 'حذف تقييم مورد', 'group' => 'المخزون'],

            // Inventory Categories
            ['name' => 'view_inventory_categories', 'slug' => 'view_inventory_categories', 'description' => 'عرض تصنيفات المخزون', 'group' => 'المخزون'],
            ['name' => 'create_inventory_categories', 'slug' => 'create_inventory_categories', 'description' => 'إنشاء تصنيف مخزون جديد', 'group' => 'المخزون'],
            ['name' => 'edit_inventory_categories', 'slug' => 'edit_inventory_categories', 'description' => 'تعديل تصنيف مخزون', 'group' => 'المخزون'],
            ['name' => 'delete_inventory_categories', 'slug' => 'delete_inventory_categories', 'description' => 'حذف تصنيف مخزون', 'group' => 'المخزون'],

            // Inventory Items
            ['name' => 'view_inventory_items', 'slug' => 'view_inventory_items', 'description' => 'عرض عناصر المخزون', 'group' => 'المخزون'],
            ['name' => 'create_inventory_items', 'slug' => 'create_inventory_items', 'description' => 'إنشاء عنصر مخزون جديد', 'group' => 'المخزون'],
            ['name' => 'edit_inventory_items', 'slug' => 'edit_inventory_items', 'description' => 'تعديل عنصر مخزون', 'group' => 'المخزون'],
            ['name' => 'delete_inventory_items', 'slug' => 'delete_inventory_items', 'description' => 'حذف عنصر مخزون', 'group' => 'المخزون'],

            // Inventory Stock
            ['name' => 'view_inventory_stock', 'slug' => 'view_inventory_stock', 'description' => 'عرض المخزون', 'group' => 'المخزون'],
            ['name' => 'adjust_inventory_stock', 'slug' => 'adjust_inventory_stock', 'description' => 'تعديل كميات المخزون', 'group' => 'المخزون'],
            ['name' => 'transfer_inventory_stock', 'slug' => 'transfer_inventory_stock', 'description' => 'نقل المخزون بين المستودعات', 'group' => 'المخزون'],

            // Inventory Batches
            ['name' => 'view_inventory_batches', 'slug' => 'view_inventory_batches', 'description' => 'عرض دفعات المخزون', 'group' => 'المخزون'],
            ['name' => 'create_inventory_batches', 'slug' => 'create_inventory_batches', 'description' => 'إنشاء دفعة مخزون جديدة', 'group' => 'المخزون'],
            ['name' => 'edit_inventory_batches', 'slug' => 'edit_inventory_batches', 'description' => 'تعديل دفعة مخزون', 'group' => 'المخزون'],
            ['name' => 'delete_inventory_batches', 'slug' => 'delete_inventory_batches', 'description' => 'حذف دفعة مخزون', 'group' => 'المخزون'],

            // Inventory Serials
            ['name' => 'view_inventory_serials', 'slug' => 'view_inventory_serials', 'description' => 'عرض الأرقام التسلسلية للمخزون', 'group' => 'المخزون'],
            ['name' => 'create_inventory_serials', 'slug' => 'create_inventory_serials', 'description' => 'إنشاء رقم تسلسلي جديد', 'group' => 'المخزون'],
            ['name' => 'edit_inventory_serials', 'slug' => 'edit_inventory_serials', 'description' => 'تعديل رقم تسلسلي', 'group' => 'المخزون'],
            ['name' => 'delete_inventory_serials', 'slug' => 'delete_inventory_serials', 'description' => 'حذف رقم تسلسلي', 'group' => 'المخزون'],

            // Purchase Orders
            ['name' => 'view_purchase_orders', 'slug' => 'view_purchase_orders', 'description' => 'عرض أوامر الشراء', 'group' => 'المخزون'],
            ['name' => 'create_purchase_orders', 'slug' => 'create_purchase_orders', 'description' => 'إنشاء أمر شراء جديد', 'group' => 'المخزون'],
            ['name' => 'edit_purchase_orders', 'slug' => 'edit_purchase_orders', 'description' => 'تعديل أمر شراء', 'group' => 'المخزون'],
            ['name' => 'delete_purchase_orders', 'slug' => 'delete_purchase_orders', 'description' => 'حذف أمر شراء', 'group' => 'المخزون'],
            ['name' => 'approve_purchase_orders', 'slug' => 'approve_purchase_orders', 'description' => 'اعتماد أمر شراء', 'group' => 'المخزون'],
            ['name' => 'receive_purchase_orders', 'slug' => 'receive_purchase_orders', 'description' => 'استلام أمر شراء', 'group' => 'المخزون'],
            ['name' => 'cancel_purchase_orders', 'slug' => 'cancel_purchase_orders', 'description' => 'إلغاء أمر شراء', 'group' => 'المخزون'],

            // Inventory Transactions
            ['name' => 'view_inventory_transactions', 'slug' => 'view_inventory_transactions', 'description' => 'عرض حركات المخزون', 'group' => 'المخزون'],

            // Inventory Reports
            ['name' => 'view_inventory_reports', 'slug' => 'view_inventory_reports', 'description' => 'عرض تقارير المخزون', 'group' => 'المخزون'],

            // Inventory Valuation
            ['name' => 'view_inventory_valuation', 'slug' => 'view_inventory_valuation', 'description' => 'عرض تقييم المخزون', 'group' => 'المخزون'],
            ['name' => 'create_inventory_valuation', 'slug' => 'create_inventory_valuation', 'description' => 'إنشاء تقييم مخزون جديد', 'group' => 'المخزون'],
            ['name' => 'edit_inventory_valuation', 'slug' => 'edit_inventory_valuation', 'description' => 'تعديل تقييم مخزون', 'group' => 'المخزون'],
            ['name' => 'delete_inventory_valuation', 'slug' => 'delete_inventory_valuation', 'description' => 'حذف تقييم مخزون', 'group' => 'المخزون'],
            ['name' => 'view_inventory_valuation_history', 'slug' => 'view_inventory_valuation_history', 'description' => 'عرض سجل تقييم المخزون', 'group' => 'المخزون'],
            ['name' => 'export_inventory_valuation', 'slug' => 'export_inventory_valuation', 'description' => 'تصدير تقييم المخزون', 'group' => 'المخزون'],

            // Inventory Barcodes
            ['name' => 'view_inventory_barcodes', 'slug' => 'view_inventory_barcodes', 'description' => 'عرض الباركود', 'group' => 'المخزون'],
            ['name' => 'generate_inventory_barcode', 'slug' => 'generate_inventory_barcode', 'description' => 'إنشاء باركود جديد', 'group' => 'المخزون'],
            ['name' => 'print_inventory_barcode', 'slug' => 'print_inventory_barcode', 'description' => 'طباعة باركود', 'group' => 'المخزون'],
            ['name' => 'scan_inventory_barcode', 'slug' => 'scan_inventory_barcode', 'description' => 'مسح باركود', 'group' => 'المخزون'],
            ['name' => 'create_transaction_from_barcode', 'slug' => 'create_transaction_from_barcode', 'description' => 'إنشاء معاملة من الباركود', 'group' => 'المخزون'],

            // Auto Purchase
            ['name' => 'view_auto_purchase', 'slug' => 'view_auto_purchase', 'description' => 'عرض الشراء التلقائي', 'group' => 'المخزون'],
            ['name' => 'view_auto_purchase_analytics', 'slug' => 'view_auto_purchase_analytics', 'description' => 'عرض تحليلات الشراء التلقائي', 'group' => 'المخزون'],
            ['name' => 'view_auto_purchase_forecast', 'slug' => 'view_auto_purchase_forecast', 'description' => 'عرض توقعات الشراء', 'group' => 'المخزون'],
            ['name' => 'view_auto_purchase_performance', 'slug' => 'view_auto_purchase_performance', 'description' => 'عرض أداء قواعد الشراء', 'group' => 'المخزون'],
            ['name' => 'view_auto_purchase_recommendations', 'slug' => 'view_auto_purchase_recommendations', 'description' => 'عرض توصيات الشراء', 'group' => 'المخزون'],
            ['name' => 'apply_auto_purchase_recommendations', 'slug' => 'apply_auto_purchase_recommendations', 'description' => 'تطبيق توصيات الشراء', 'group' => 'المخزون'],
            ['name' => 'create_auto_purchase_rule', 'slug' => 'create_auto_purchase_rule', 'description' => 'إنشاء قاعدة شراء تلقائي', 'group' => 'المخزون'],
        ];

        foreach ($permissions as $permission) {
            // البحث عن الصلاحية إما بالاسم أو بالسلاج
            $existingPermission = Permission::where('name', $permission['name'])
                ->orWhere('slug', $permission['slug'])
                ->first();

            if ($existingPermission) {
                // تحديث الصلاحية الموجودة
                $existingPermission->update([
                    'name' => $permission['name'],
                    'description' => $permission['description'],
                    'group' => $permission['group']
                ]);
            } else {
                // إنشاء صلاحية جديدة
                Permission::create([
                    'name' => $permission['name'],
                    'slug' => $permission['slug'],
                    'description' => $permission['description'],
                    'group' => $permission['group']
                ]);
            }
        }
    }
}
