<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;
use App\Models\Role;

class InventoryIssuePermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // إنشاء صلاحيات إذن صرف المخازن
        $permissions = [
            [
                'name' => 'عرض أذونات صرف المخازن',
                'slug' => 'view_inventory_issues',
                'description' => 'عرض أذونات صرف المخازن',
                'group' => 'inventory',
                'type' => 'action',
                'resource' => 'inventory_issues',
                'order' => 1,
                'is_active' => true
            ],
            [
                'name' => 'إنشاء إذن صرف مخازن',
                'slug' => 'create_inventory_issues',
                'description' => 'إنشاء إذن صرف مخازن',
                'group' => 'inventory',
                'type' => 'action',
                'resource' => 'inventory_issues',
                'order' => 2,
                'is_active' => true
            ],
            [
                'name' => 'تعديل إذن صرف مخازن',
                'slug' => 'edit_inventory_issues',
                'description' => 'تعديل إذن صرف مخازن',
                'group' => 'inventory',
                'type' => 'action',
                'resource' => 'inventory_issues',
                'order' => 3,
                'is_active' => true
            ],
            [
                'name' => 'حذف إذن صرف مخازن',
                'slug' => 'delete_inventory_issues',
                'description' => 'حذف إذن صرف مخازن',
                'group' => 'inventory',
                'type' => 'action',
                'resource' => 'inventory_issues',
                'order' => 4,
                'is_active' => true
            ],
            [
                'name' => 'إكمال إذن صرف مخازن',
                'slug' => 'complete_inventory_issues',
                'description' => 'إكمال إذن صرف مخازن',
                'group' => 'inventory',
                'type' => 'action',
                'resource' => 'inventory_issues',
                'order' => 5,
                'is_active' => true
            ],
        ];

        // البحث عن مجموعة المخزون الرئيسية
        $inventoryGroup = Permission::where('slug', 'manage_inventory')->first();

        // إذا لم تكن موجودة، قم بإنشائها
        if (!$inventoryGroup) {
            $inventoryGroup = Permission::create([
                'name' => 'إدارة المخزون',
                'slug' => 'manage_inventory',
                'description' => 'إدارة كاملة للمخزون',
                'group' => 'inventory',
                'type' => 'group',
                'resource' => 'inventory',
                'level' => 0,
                'order' => 0,
                'is_active' => true
            ]);

            // تحديث المسار بعد الإنشاء
            $inventoryGroup->path = $inventoryGroup->id;
            $inventoryGroup->save();
        }

        foreach ($permissions as $permissionData) {
            // البحث عن الصلاحية إما بالاسم أو بالسلاج
            $existingPermission = Permission::where('slug', $permissionData['slug'])->first();

            if ($existingPermission) {
                // تحديث الصلاحية الموجودة
                $existingPermission->update([
                    'name' => $permissionData['name'],
                    'description' => $permissionData['description'],
                    'group' => $permissionData['group'],
                    'type' => $permissionData['type'],
                    'resource' => $permissionData['resource'],
                    'order' => $permissionData['order'],
                    'is_active' => $permissionData['is_active']
                ]);
            } else {
                // إنشاء صلاحية جديدة
                $permission = Permission::create([
                    'parent_id' => $inventoryGroup->id,
                    'name' => $permissionData['name'],
                    'slug' => $permissionData['slug'],
                    'description' => $permissionData['description'],
                    'group' => $permissionData['group'],
                    'type' => $permissionData['type'],
                    'resource' => $permissionData['resource'],
                    'level' => 1,
                    'order' => $permissionData['order'],
                    'is_active' => $permissionData['is_active']
                ]);

                // تحديث المسار بعد الإنشاء
                $permission->path = $inventoryGroup->path . '.' . $permission->id;
                $permission->save();
            }
        }

        // إضافة الصلاحيات لدور المدير
        $adminRole = Role::where('slug', 'admin')->first();
        if ($adminRole) {
            $permissionIds = Permission::whereIn('slug', [
                'view_inventory_issues',
                'create_inventory_issues',
                'edit_inventory_issues',
                'delete_inventory_issues',
                'complete_inventory_issues'
            ])->pluck('id')->toArray();

            $adminRole->permissions()->syncWithoutDetaching($permissionIds);
        }

        // إضافة الصلاحيات لدور مدير المخزون إذا كان موجوداً
        $inventoryManagerRole = Role::where('slug', 'inventory_manager')->first();
        if ($inventoryManagerRole) {
            $permissionIds = Permission::whereIn('slug', [
                'view_inventory_issues',
                'create_inventory_issues',
                'edit_inventory_issues',
                'delete_inventory_issues',
                'complete_inventory_issues'
            ])->pluck('id')->toArray();

            $inventoryManagerRole->permissions()->syncWithoutDetaching($permissionIds);
        }
    }
}
