<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;
use App\Models\Role;

class InventoryExtraPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // إنشاء صلاحيات المخزون الإضافية
        $permissions = [
            // صلاحيات المخزون الإضافية
            'adjust_inventory_stock' => 'تعديل مخزون المستودع',
            'apply_auto_purchase_recommendations' => 'تطبيق توصيات الشراء التلقائي',
            'apply_seasonal_adjustments' => 'تطبيق التعديلات الموسمية',
            'apply_smart_recommendations' => 'تطبيق التوصيات الذكية',
            'approve_purchase_orders' => 'اعتماد أوامر الشراء',
            'cancel_purchase_orders' => 'إلغاء أوامر الشراء',
            'create_auto_purchase_rule' => 'إنشاء قاعدة شراء تلقائي',
            'create_inventory_batches' => 'إنشاء دفعات مخزون',
            'create_inventory_serials' => 'إنشاء أرقام تسلسلية للمخزون',
            'create_inventory_valuation' => 'إنشاء تقييم للمخزون',
            'create_recommended_rules' => 'إنشاء قواعد موصى بها',
            'create_supplier_evaluations' => 'إنشاء تقييمات للموردين',
            'create_transaction_from_barcode' => 'إنشاء معاملة من الباركود',
            'delete_inventory_batches' => 'حذف دفعات المخزون',
            'delete_inventory_serials' => 'حذف الأرقام التسلسلية للمخزون',
            'delete_inventory_valuation' => 'حذف تقييم المخزون',
            'delete_supplier_evaluations' => 'حذف تقييمات الموردين',
            'edit_inventory_batches' => 'تعديل دفعات المخزون',
            'edit_inventory_serials' => 'تعديل الأرقام التسلسلية للمخزون',
            'edit_inventory_valuation' => 'تعديل تقييم المخزون',
            'edit_supplier_evaluations' => 'تعديل تقييمات الموردين',
            'export_inventory_valuation' => 'تصدير تقييم المخزون',
            'generate_inventory_barcode' => 'إنشاء باركود للمخزون',
            'print_inventory_barcode' => 'طباعة باركود المخزون',
            'receive_purchase_orders' => 'استلام أوامر الشراء',
            'scan_inventory_barcode' => 'مسح باركود المخزون',
            'view_auto_purchase_analytics' => 'عرض تحليلات الشراء التلقائي',
        ];

        // إنشاء الصلاحيات
        foreach ($permissions as $name => $description) {
            Permission::firstOrCreate(
                ['name' => $name],
                [
                    'description' => $description,
                    'slug' => str_replace('_', '-', $name),
                    'group' => 'inventory',
                    'is_active' => true
                ]
            );
        }

        // إضافة الصلاحيات للأدوار
        $adminRole = Role::where('slug', 'admin')->first();
        $superAdminRole = Role::where('slug', 'super_admin')->first();

        if ($superAdminRole) {
            // إضافة جميع الصلاحيات لمدير النظام
            $permissionIds = Permission::whereIn('name', array_keys($permissions))->pluck('id')->toArray();
            $superAdminRole->permissions()->syncWithoutDetaching($permissionIds);
        }

        if ($adminRole) {
            // إضافة جميع الصلاحيات للمدير
            $permissionIds = Permission::whereIn('name', array_keys($permissions))->pluck('id')->toArray();
            $adminRole->permissions()->syncWithoutDetaching($permissionIds);
        }

        // إضافة الصلاحيات للأدوار الأخرى إذا كانت موجودة
        $inventoryManagerRole = Role::where('slug', 'inventory_manager')->first();
        $purchaseManagerRole = Role::where('slug', 'purchase_manager')->first();
        $warehouseManagerRole = Role::where('slug', 'warehouse_manager')->first();

        if ($inventoryManagerRole) {
            $permissionIds = Permission::whereIn('name', array_keys($permissions))->pluck('id')->toArray();
            $inventoryManagerRole->permissions()->syncWithoutDetaching($permissionIds);
        }

        if ($purchaseManagerRole) {
            $purchaseManagerPermissions = [
                'apply_auto_purchase_recommendations',
                'apply_seasonal_adjustments',
                'apply_smart_recommendations',
                'approve_purchase_orders',
                'cancel_purchase_orders',
                'create_auto_purchase_rule',
                'create_recommended_rules',
                'create_supplier_evaluations',
                'edit_supplier_evaluations',
                'view_auto_purchase_analytics',
            ];
            $permissionIds = Permission::whereIn('name', $purchaseManagerPermissions)->pluck('id')->toArray();
            $purchaseManagerRole->permissions()->syncWithoutDetaching($permissionIds);
        }

        if ($warehouseManagerRole) {
            $warehouseManagerPermissions = [
                'adjust_inventory_stock',
                'create_inventory_batches',
                'create_inventory_serials',
                'create_inventory_valuation',
                'create_transaction_from_barcode',
                'edit_inventory_batches',
                'edit_inventory_serials',
                'edit_inventory_valuation',
                'export_inventory_valuation',
                'generate_inventory_barcode',
                'print_inventory_barcode',
                'receive_purchase_orders',
                'scan_inventory_barcode',
            ];
            $permissionIds = Permission::whereIn('name', $warehouseManagerPermissions)->pluck('id')->toArray();
            $warehouseManagerRole->permissions()->syncWithoutDetaching($permissionIds);
        }
    }
}
