<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class InventoryAdvancedPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // إنشاء صلاحيات نظام الباركود
        $barcodePermissions = [
            'view_inventory_barcodes' => 'عرض الباركود',
            'generate_inventory_barcodes' => 'إنشاء الباركود',
            'scan_inventory_barcodes' => 'مسح الباركود',
            'create_inventory_transactions' => 'إنشاء معاملات المخزون من الباركود',
        ];

        // إنشاء صلاحيات تقييم المخزون
        $valuationPermissions = [
            'view_inventory_valuation' => 'عرض تقييم المخزون',
            'create_inventory_valuation' => 'إنشاء تقييم مخزون',
            'view_inventory_valuation_history' => 'عرض سجل تقييم المخزون',
        ];

        // إنشاء صلاحيات تحليلات الشراء التلقائي
        $autoPurchaseAnalyticsPermissions = [
            'view_auto_purchase_analytics' => 'عرض تحليلات الشراء التلقائي',
        ];

        // دمج جميع الصلاحيات
        $permissions = array_merge(
            $barcodePermissions,
            $valuationPermissions,
            $autoPurchaseAnalyticsPermissions
        );

        // إنشاء الصلاحيات في قاعدة البيانات
        foreach ($permissions as $name => $arabicName) {
            Permission::create([
                'name' => $name,
                'arabic_name' => $arabicName,
                'guard_name' => 'web',
            ]);
        }

        // إضافة الصلاحيات إلى الأدوار المناسبة
        $this->assignPermissionsToRoles();
    }

    /**
     * إضافة الصلاحيات إلى الأدوار المناسبة
     */
    private function assignPermissionsToRoles(): void
    {
        // الحصول على الأدوار
        $superAdmin = Role::where('name', 'super_admin')->first();
        $admin = Role::where('name', 'admin')->first();
        $inventoryManager = Role::where('name', 'inventory_manager')->first();
        $inventoryClerk = Role::where('name', 'inventory_clerk')->first();
        $purchaseManager = Role::where('name', 'purchase_manager')->first();

        // صلاحيات نظام الباركود
        $barcodePermissions = [
            'view_inventory_barcodes',
            'generate_inventory_barcodes',
            'scan_inventory_barcodes',
            'create_inventory_transactions',
        ];

        // صلاحيات تقييم المخزون
        $valuationPermissions = [
            'view_inventory_valuation',
            'create_inventory_valuation',
            'view_inventory_valuation_history',
        ];

        // صلاحيات تحليلات الشراء التلقائي
        $autoPurchaseAnalyticsPermissions = [
            'view_auto_purchase_analytics',
        ];

        // إضافة جميع الصلاحيات إلى مدير النظام والمدير العام
        if ($superAdmin) {
            $superAdmin->givePermissionTo(array_merge(
                $barcodePermissions,
                $valuationPermissions,
                $autoPurchaseAnalyticsPermissions
            ));
        }

        if ($admin) {
            $admin->givePermissionTo(array_merge(
                $barcodePermissions,
                $valuationPermissions,
                $autoPurchaseAnalyticsPermissions
            ));
        }

        // إضافة صلاحيات محددة إلى مدير المخزون
        if ($inventoryManager) {
            $inventoryManager->givePermissionTo(array_merge(
                $barcodePermissions,
                $valuationPermissions,
                $autoPurchaseAnalyticsPermissions
            ));
        }

        // إضافة صلاحيات محددة إلى موظف المخزون
        if ($inventoryClerk) {
            $inventoryClerk->givePermissionTo([
                'view_inventory_barcodes',
                'scan_inventory_barcodes',
                'create_inventory_transactions',
                'view_inventory_valuation',
            ]);
        }

        // إضافة صلاحيات محددة إلى مدير المشتريات
        if ($purchaseManager) {
            $purchaseManager->givePermissionTo([
                'view_inventory_valuation',
                'view_inventory_valuation_history',
                'view_auto_purchase_analytics',
            ]);
        }
    }
}
