<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;
use App\Models\Role;

class InstallationProjectPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // إنشاء صلاحيات نظام المشاريع والتركيبات
        $permissions = [
            // صلاحيات المشاريع
            'view_installation_projects' => 'عرض مشاريع التركيب',
            'create_installation_project' => 'إنشاء مشروع تركيب جديد',
            'edit_installation_project' => 'تعديل مشروع تركيب',
            'delete_installation_project' => 'حذف مشروع تركيب',
            'manage_installation_projects' => 'إدارة مشاريع التركيب',

            // صلاحيات مصاعد المشروع
            'view_project_elevators' => 'عرض مصاعد المشروع',
            'add_project_elevator' => 'إضافة مصعد للمشروع',
            'edit_project_elevator' => 'تعديل مصعد المشروع',
            'delete_project_elevator' => 'حذف مصعد المشروع',

            // صلاحيات مراحل المشروع
            'view_project_phases' => 'عرض مراحل المشروع',
            'add_project_phase' => 'إضافة مرحلة للمشروع',
            'edit_project_phase' => 'تعديل مرحلة المشروع',
            'delete_project_phase' => 'حذف مرحلة المشروع',

            // صلاحيات مهام المشروع
            'view_project_tasks' => 'عرض مهام المشروع',
            'add_project_task' => 'إضافة مهمة للمشروع',
            'edit_project_task' => 'تعديل مهمة المشروع',
            'delete_project_task' => 'حذف مهمة المشروع',
            'assign_project_task' => 'تعيين مهمة المشروع',

            // صلاحيات فريق المشروع
            'view_project_team' => 'عرض فريق المشروع',
            'add_project_team_member' => 'إضافة عضو لفريق المشروع',
            'edit_project_team_member' => 'تعديل عضو فريق المشروع',
            'delete_project_team_member' => 'حذف عضو فريق المشروع',

            // صلاحيات مستندات المشروع
            'view_project_documents' => 'عرض مستندات المشروع',
            'add_project_document' => 'إضافة مستند للمشروع',
            'edit_project_document' => 'تعديل مستند المشروع',
            'delete_project_document' => 'حذف مستند المشروع',

            // صلاحيات مصاريف المشروع
            'view_project_expenses' => 'عرض مصاريف المشروع',
            'add_project_expense' => 'إضافة مصروف للمشروع',
            'edit_project_expense' => 'تعديل مصروف المشروع',
            'delete_project_expense' => 'حذف مصروف المشروع',
            'approve_project_expense' => 'اعتماد مصروف المشروع',

            // صلاحيات مدفوعات المشروع
            'view_project_payments' => 'عرض مدفوعات المشروع',
            'add_project_payment' => 'إضافة دفعة للمشروع',
            'edit_project_payment' => 'تعديل دفعة المشروع',
            'delete_project_payment' => 'حذف دفعة المشروع',

            // صلاحيات مشكلات المشروع
            'view_project_issues' => 'عرض مشكلات المشروع',
            'add_project_issue' => 'إضافة مشكلة للمشروع',
            'edit_project_issue' => 'تعديل مشكلة المشروع',
            'delete_project_issue' => 'حذف مشكلة المشروع',
            'resolve_project_issue' => 'حل مشكلة المشروع',

            // صلاحيات معالم المشروع
            'view_project_milestones' => 'عرض معالم المشروع',
            'add_project_milestone' => 'إضافة معلم للمشروع',
            'edit_project_milestone' => 'تعديل معلم المشروع',
            'delete_project_milestone' => 'حذف معلم المشروع',
            'complete_project_milestone' => 'إكمال معلم المشروع',

            // صلاحيات قوائم فحص المشروع
            'view_project_checklists' => 'عرض قوائم فحص المشروع',
            'add_project_checklist' => 'إضافة قائمة فحص للمشروع',
            'edit_project_checklist' => 'تعديل قائمة فحص المشروع',
            'delete_project_checklist' => 'حذف قائمة فحص المشروع',
            'complete_project_checklist' => 'إكمال قائمة فحص المشروع',
        ];

        // إنشاء الصلاحيات
        foreach ($permissions as $name => $description) {
            Permission::firstOrCreate(
                ['name' => $name],
                [
                    'description' => $description,
                    'slug' => str_replace('_', '-', $name)
                ]
            );
        }

        // إضافة الصلاحيات للأدوار
        $adminRole = Role::where('name', 'admin')->first();
        $managerRole = Role::where('name', 'manager')->first();
        $projectManagerRole = Role::where('name', 'project_manager')->first();
        $engineerRole = Role::where('name', 'engineer')->first();
        $technicianRole = Role::where('name', 'technician')->first();

        if ($adminRole) {
            $adminRole->givePermissionTo(array_keys($permissions));
        }

        if ($managerRole) {
            $managerRole->givePermissionTo(array_keys($permissions));
        }

        if ($projectManagerRole) {
            $projectManagerPermissions = [
                'view_installation_projects',
                'edit_installation_project',
                'manage_installation_projects',
                'view_project_elevators',
                'add_project_elevator',
                'edit_project_elevator',
                'view_project_phases',
                'add_project_phase',
                'edit_project_phase',
                'view_project_tasks',
                'add_project_task',
                'edit_project_task',
                'assign_project_task',
                'view_project_team',
                'add_project_team_member',
                'edit_project_team_member',
                'view_project_documents',
                'add_project_document',
                'edit_project_document',
                'view_project_expenses',
                'add_project_expense',
                'view_project_payments',
                'view_project_issues',
                'add_project_issue',
                'edit_project_issue',
                'resolve_project_issue',
                'view_project_milestones',
                'add_project_milestone',
                'edit_project_milestone',
                'complete_project_milestone',
                'view_project_checklists',
                'add_project_checklist',
                'edit_project_checklist',
                'complete_project_checklist',
            ];
            $projectManagerRole->givePermissionTo($projectManagerPermissions);
        }

        if ($engineerRole) {
            $engineerPermissions = [
                'view_installation_projects',
                'view_project_elevators',
                'view_project_phases',
                'view_project_tasks',
                'edit_project_task',
                'view_project_team',
                'view_project_documents',
                'add_project_document',
                'view_project_expenses',
                'view_project_issues',
                'add_project_issue',
                'edit_project_issue',
                'resolve_project_issue',
                'view_project_milestones',
                'view_project_checklists',
                'edit_project_checklist',
                'complete_project_checklist',
            ];
            $engineerRole->givePermissionTo($engineerPermissions);
        }

        if ($technicianRole) {
            $technicianPermissions = [
                'view_installation_projects',
                'view_project_elevators',
                'view_project_phases',
                'view_project_tasks',
                'view_project_team',
                'view_project_documents',
                'view_project_issues',
                'add_project_issue',
                'view_project_checklists',
                'complete_project_checklist',
            ];
            $technicianRole->givePermissionTo($technicianPermissions);
        }
    }
}
